/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.Scrollable;
import javax.swing.plaf.ComponentUI;

public class LayerUI<V extends Component>
extends ComponentUI
implements Serializable {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        jComponent.paint(graphics);
    }

    public void eventDispatched(AWTEvent aWTEvent, JLayer<? extends V> jLayer) {
    }

    public void updateUI(JLayer<? extends V> jLayer) {
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.addPropertyChangeListener((JLayer)jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.removePropertyChangeListener((JLayer)jComponent);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.propertyChangeSupport.getPropertyChangeListeners(string);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public void applyPropertyChange(PropertyChangeEvent propertyChangeEvent, JLayer<? extends V> jLayer) {
    }

    public Dimension getPreferredScrollableViewportSize(JLayer<? extends V> jLayer) {
        if (jLayer.getView() instanceof Scrollable) {
            return ((Scrollable)jLayer.getView()).getPreferredScrollableViewportSize();
        }
        return jLayer.getPreferredSize();
    }

    public int getScrollableBlockIncrement(JLayer<? extends V> jLayer, Rectangle rectangle, int n, int n2) {
        if (jLayer.getView() instanceof Scrollable) {
            return ((Scrollable)jLayer.getView()).getScrollableBlockIncrement(rectangle, n, n2);
        }
        return n == 1 ? rectangle.height : rectangle.width;
    }

    public boolean getScrollableTracksViewportHeight(JLayer<? extends V> jLayer) {
        if (jLayer.getView() instanceof Scrollable) {
            return ((Scrollable)jLayer.getView()).getScrollableTracksViewportHeight();
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth(JLayer<? extends V> jLayer) {
        if (jLayer.getView() instanceof Scrollable) {
            return ((Scrollable)jLayer.getView()).getScrollableTracksViewportWidth();
        }
        return false;
    }

    public int getScrollableUnitIncrement(JLayer<? extends V> jLayer, Rectangle rectangle, int n, int n2) {
        if (jLayer.getView() instanceof Scrollable) {
            return ((Scrollable)jLayer.getView()).getScrollableUnitIncrement(rectangle, n, n2);
        }
        return 1;
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        JLayer jLayer = (JLayer)jComponent;
        if (jLayer.getView() != null) {
            return ((Component)jLayer.getView()).getBaseline(n, n2);
        }
        return super.getBaseline(jComponent, n, n2);
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent jComponent) {
        JLayer jLayer = (JLayer)jComponent;
        if (jLayer.getView() != null) {
            return ((Component)jLayer.getView()).getBaselineResizeBehavior();
        }
        return super.getBaselineResizeBehavior(jComponent);
    }
}

