/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import com.sun.java.swing.plaf.motif.MotifPasswordFieldUI;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.im.InputMethodRequests;
import java.awt.peer.ComponentPeer;
import java.awt.peer.TextFieldPeer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import sun.awt.CausedFocusEvent;
import sun.awt.ComponentAccessor;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XTextTransferHelper;
import sun.awt.X11.XToolkit;

public class XTextFieldPeer
extends XComponentPeer
implements TextFieldPeer {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XTextField");
    String text;
    XAWTTextField xtext;
    boolean firstChangeSkipped = false;
    private static final int PADDING = 16;

    public XTextFieldPeer(TextField textField) {
        super(textField);
        this.text = textField.getText();
        this.xtext = new XAWTTextField(this.text, this, textField.getParent());
        this.xtext.getDocument().addDocumentListener(this.xtext);
        this.xtext.setCursor(textField.getCursor());
        textField.enableInputMethods(true);
        this.xtext.enableInputMethods(true);
        XToolkit.specialPeerMap.put(this.xtext, this);
        TextField textField2 = textField;
        this.initTextField();
        this.setText(textField2.getText());
        if (textField2.echoCharIsSet()) {
            this.setEchoChar(textField2.getEchoChar());
        } else {
            this.setEchoChar('\u0000');
        }
        int n = textField2.getSelectionStart();
        int n2 = textField2.getSelectionEnd();
        if (n2 > n) {
            this.select(n, n2);
        }
        int n3 = Math.min(n2, this.text.length());
        this.setCaretPosition(n3);
        this.setEditable(textField2.isEditable());
        this.firstChangeSkipped = true;
    }

    @Override
    public void dispose() {
        XToolkit.specialPeerMap.remove(this.xtext);
        this.xtext.removeNotify();
        super.dispose();
    }

    void initTextField() {
        this.setVisible(this.target.isVisible());
        this.setBounds(this.x, this.y, this.width, this.height, 3);
        this.foreground = ComponentAccessor.getForeground(this.target);
        if (this.foreground == null) {
            this.foreground = SystemColor.textText;
        }
        this.setForeground(this.foreground);
        this.background = ComponentAccessor.getBackground(this.target);
        if (this.background == null) {
            this.background = ((TextField)this.target).isEditable() ? SystemColor.text : SystemColor.control;
        }
        this.setBackground(this.background);
        if (!this.target.isBackgroundSet()) {
            ComponentAccessor.setBackground(this.target, this.background);
        }
        if (!this.target.isForegroundSet()) {
            this.target.setForeground(SystemColor.textText);
        }
        this.setFont(this.font);
    }

    @Override
    public void setEditable(boolean bl) {
        if (this.xtext != null) {
            this.xtext.setEditable(bl);
            this.xtext.repaint();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.xtext != null) {
            this.xtext.setEnabled(bl);
            this.xtext.repaint();
        }
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (this.xtext != null) {
            return this.xtext.getInputMethodRequests();
        }
        return null;
    }

    @Override
    void handleJavaInputMethodEvent(InputMethodEvent inputMethodEvent) {
        if (this.xtext != null) {
            this.xtext.processInputMethodEventImpl(inputMethodEvent);
        }
    }

    @Override
    public void setEchoChar(char c) {
        if (this.xtext != null) {
            this.xtext.setEchoChar(c);
            this.xtext.putClientProperty("JPasswordField.cutCopyAllowed", this.xtext.echoCharIsSet() ? Boolean.FALSE : Boolean.TRUE);
        }
    }

    @Override
    public int getSelectionStart() {
        return this.xtext.getSelectionStart();
    }

    @Override
    public int getSelectionEnd() {
        return this.xtext.getSelectionEnd();
    }

    @Override
    public String getText() {
        return this.xtext.getText();
    }

    @Override
    public void setText(String string) {
        this.setXAWTTextField(string);
        this.repaint();
    }

    protected boolean setXAWTTextField(String string) {
        this.text = string;
        if (this.xtext != null) {
            this.xtext.getDocument().removeDocumentListener(this.xtext);
            this.xtext.setText(string);
            if (this.firstChangeSkipped) {
                this.postEvent(new TextEvent(this.target, 900));
            }
            this.xtext.getDocument().addDocumentListener(this.xtext);
            this.xtext.setCaretPosition(0);
        }
        return true;
    }

    @Override
    public void setCaretPosition(int n) {
        if (this.xtext != null) {
            this.xtext.setCaretPosition(n);
        }
    }

    public void setEchoCharacter(char c) {
        this.setEchoChar(c);
    }

    void repaintText() {
        this.xtext.repaintNow();
    }

    @Override
    public void setBackground(Color color) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("target=" + this.target + ", old=" + this.background + ", new=" + color);
        }
        this.background = color;
        if (this.xtext != null) {
            this.xtext.setBackground(color);
            this.xtext.setSelectedTextColor(color);
        }
        this.repaintText();
    }

    @Override
    public void setForeground(Color color) {
        this.foreground = color;
        if (this.xtext != null) {
            this.xtext.setForeground(this.foreground);
            this.xtext.setSelectionColor(this.foreground);
            this.xtext.setCaretColor(this.foreground);
        }
        this.repaintText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFont(Font font) {
        Object object = this.getStateLock();
        synchronized (object) {
            this.font = font;
            if (this.xtext != null) {
                this.xtext.setFont(this.font);
            }
        }
        this.xtext.validate();
    }

    public Dimension preferredSize(int n) {
        return this.getPreferredSize(n);
    }

    public void deselect() {
        int n;
        int n2 = this.xtext.getSelectionStart();
        if (n2 != (n = this.xtext.getSelectionEnd())) {
            this.xtext.select(n2, n2);
        }
    }

    @Override
    public int getCaretPosition() {
        return this.xtext.getCaretPosition();
    }

    @Override
    public void select(int n, int n2) {
        this.xtext.select(n, n2);
        this.xtext.repaint();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.xtext.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.xtext.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize(int n) {
        return this.getMinimumSize(n);
    }

    @Override
    public Dimension getMinimumSize(int n) {
        Font font = this.xtext.getFont();
        FontMetrics fontMetrics = this.xtext.getFontMetrics(font);
        return new Dimension(fontMetrics.charWidth('0') * n + 10, fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 16);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    public void action(long l, int n) {
        this.postEvent(new ActionEvent(this.target, 1001, this.text, l, n));
    }

    protected void disposeImpl() {
    }

    @Override
    public void repaint() {
        if (this.xtext != null) {
            this.xtext.repaint();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.xtext != null) {
            this.xtext.paint(graphics);
        }
    }

    @Override
    public void print(Graphics graphics) {
        if (this.xtext != null) {
            this.xtext.print(graphics);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        this.xtext.forwardFocusLost(focusEvent);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        this.xtext.forwardFocusGained(focusEvent);
    }

    @Override
    void handleJavaKeyEvent(KeyEvent keyEvent) {
        ComponentAccessor.processEvent(this.xtext, keyEvent);
    }

    @Override
    public void handleJavaMouseEvent(MouseEvent mouseEvent) {
        super.handleJavaMouseEvent(mouseEvent);
        if (this.xtext != null) {
            mouseEvent.setSource(this.xtext);
            int n = mouseEvent.getID();
            if (n == 506 || n == 503) {
                this.xtext.processMouseMotionEventImpl(mouseEvent);
            } else {
                this.xtext.processMouseEventImpl(mouseEvent);
            }
        }
    }

    @Override
    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension minimumSize(int n) {
        return this.getMinimumSize(n);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.xtext != null) {
            this.xtext.setVisible(bl);
        }
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        super.setBounds(n, n2, n3, n4, n5);
        if (this.xtext != null) {
            int n6 = n;
            int n7 = n2;
            Container container = this.target.getParent();
            while (container.isLightweight()) {
                n6 -= container.getX();
                n7 -= container.getY();
                container = container.getParent();
            }
            this.xtext.setBounds(n6, n7, n3, n4);
            this.xtext.validate();
        }
    }

    public int getIndexAtPoint(int n, int n2) {
        return -1;
    }

    public Rectangle getCharacterBounds(int n) {
        return null;
    }

    public long filterEvents(long l) {
        return 0L;
    }

    class XAWTTextField
    extends JPasswordField
    implements ActionListener,
    DocumentListener {
        boolean isFocused;
        XComponentPeer peer;

        public XAWTTextField(String string, XComponentPeer xComponentPeer, Container container) {
            super(string);
            this.isFocused = false;
            this.peer = xComponentPeer;
            this.setDoubleBuffered(true);
            this.setFocusable(false);
            ComponentAccessor.setParent(this, container);
            this.setBackground(xComponentPeer.getPeerBackground());
            this.setForeground(xComponentPeer.getPeerForeground());
            this.setFont(xComponentPeer.getPeerFont());
            this.setCaretPosition(0);
            this.addActionListener(this);
            this.addNotify();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.peer.postEvent(new ActionEvent(this.peer.target, 1001, this.getText(), actionEvent.getWhen(), actionEvent.getModifiers()));
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.peer != null) {
                this.peer.postEvent(new TextEvent(this.peer.target, 900));
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.peer != null) {
                this.peer.postEvent(new TextEvent(this.peer.target, 900));
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            if (this.peer != null) {
                this.peer.postEvent(new TextEvent(this.peer.target, 900));
            }
        }

        @Override
        public ComponentPeer getPeer() {
            return this.peer;
        }

        public void repaintNow() {
            this.paintImmediately(this.getBounds());
        }

        @Override
        public Graphics getGraphics() {
            return this.peer.getGraphics();
        }

        @Override
        public void updateUI() {
            AWTTextFieldUI aWTTextFieldUI = new AWTTextFieldUI();
            this.setUI((ComponentUI)aWTTextFieldUI);
        }

        void forwardFocusGained(FocusEvent focusEvent) {
            this.isFocused = true;
            FocusEvent focusEvent2 = CausedFocusEvent.retarget(focusEvent, this);
            super.processFocusEvent(focusEvent2);
        }

        void forwardFocusLost(FocusEvent focusEvent) {
            this.isFocused = false;
            FocusEvent focusEvent2 = CausedFocusEvent.retarget(focusEvent, this);
            super.processFocusEvent(focusEvent2);
        }

        @Override
        public boolean hasFocus() {
            return this.isFocused;
        }

        public void processInputMethodEventImpl(InputMethodEvent inputMethodEvent) {
            this.processInputMethodEvent(inputMethodEvent);
        }

        public void processMouseEventImpl(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
        }

        public void processMouseMotionEventImpl(MouseEvent mouseEvent) {
            this.processMouseMotionEvent(mouseEvent);
        }

        @Override
        public void setTransferHandler(TransferHandler transferHandler) {
            TransferHandler transferHandler2 = (TransferHandler)this.getClientProperty(XTextTransferHelper.getTransferHandlerKey());
            this.putClientProperty(XTextTransferHelper.getTransferHandlerKey(), transferHandler);
            this.firePropertyChange("transferHandler", transferHandler2, transferHandler);
        }

        @Override
        public void setEchoChar(char c) {
            super.setEchoChar(c);
            ((AWTTextFieldUI)this.ui).installKeyboardActions();
        }
    }

    class XAWTCaret
    extends DefaultCaret {
        XAWTCaret() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            super.focusGained(focusEvent);
            this.getComponent().repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            super.focusLost(focusEvent);
            this.getComponent().repaint();
        }

        @Override
        public void setSelectionVisible(boolean bl) {
            if (bl) {
                super.setSelectionVisible(bl);
            } else {
                this.setDot(this.getDot());
            }
        }
    }

    class AWTTextFieldUI
    extends MotifPasswordFieldUI {
        JTextField jtf;

        AWTTextFieldUI() {
        }

        @Override
        protected String getPropertyPrefix() {
            JTextComponent jTextComponent = this.getComponent();
            if (jTextComponent instanceof JPasswordField && ((JPasswordField)jTextComponent).echoCharIsSet()) {
                return "PasswordField";
            }
            return "TextField";
        }

        @Override
        public void installUI(JComponent jComponent) {
            Insets insets;
            Border border;
            Color color;
            Color color2;
            Color color3;
            Color color4;
            Color color5;
            Color color6;
            super.installUI(jComponent);
            JTextField jTextField = this.jtf = (JTextField)jComponent;
            UIDefaults uIDefaults = XToolkit.getUIDefaults();
            String string = this.getPropertyPrefix();
            Font font = jTextField.getFont();
            if (font == null || font instanceof UIResource) {
                jTextField.setFont(uIDefaults.getFont(string + ".font"));
            }
            if ((color6 = jTextField.getBackground()) == null || color6 instanceof UIResource) {
                jTextField.setBackground(uIDefaults.getColor(string + ".background"));
            }
            if ((color5 = jTextField.getForeground()) == null || color5 instanceof UIResource) {
                jTextField.setForeground(uIDefaults.getColor(string + ".foreground"));
            }
            if ((color4 = jTextField.getCaretColor()) == null || color4 instanceof UIResource) {
                jTextField.setCaretColor(uIDefaults.getColor(string + ".caretForeground"));
            }
            if ((color3 = jTextField.getSelectionColor()) == null || color3 instanceof UIResource) {
                jTextField.setSelectionColor(uIDefaults.getColor(string + ".selectionBackground"));
            }
            if ((color2 = jTextField.getSelectedTextColor()) == null || color2 instanceof UIResource) {
                jTextField.setSelectedTextColor(uIDefaults.getColor(string + ".selectionForeground"));
            }
            if ((color = jTextField.getDisabledTextColor()) == null || color instanceof UIResource) {
                jTextField.setDisabledTextColor(uIDefaults.getColor(string + ".inactiveForeground"));
            }
            if ((border = jTextField.getBorder()) == null || border instanceof UIResource) {
                jTextField.setBorder(uIDefaults.getBorder(string + ".border"));
            }
            if ((insets = jTextField.getMargin()) == null || insets instanceof UIResource) {
                jTextField.setMargin(uIDefaults.getInsets(string + ".margin"));
            }
        }

        @Override
        protected void installKeyboardActions() {
            super.installKeyboardActions();
            JTextComponent jTextComponent = this.getComponent();
            UIDefaults uIDefaults = XToolkit.getUIDefaults();
            String string = this.getPropertyPrefix();
            InputMap inputMap = (InputMap)uIDefaults.get(string + ".focusInputMap");
            if (inputMap != null) {
                SwingUtilities.replaceUIInputMap(jTextComponent, 0, inputMap);
            }
        }

        @Override
        protected Caret createCaret() {
            return new XAWTCaret();
        }
    }
}

