/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn;

import java.dyn.MethodHandle;
import java.dyn.MethodType;
import java.dyn.WrongMethodTypeException;
import sun.dyn.Access;
import sun.dyn.AdapterMethodHandle;
import sun.dyn.DirectMethodHandle;
import sun.dyn.MethodHandleNatives;
import sun.dyn.util.VerifyType;
import sun.dyn.util.Wrapper;

public class BoundMethodHandle
extends MethodHandle {
    private final Object argument;
    private final int vmargslot;
    private static final int REF_ARG = 0;
    private static final int PRIM_ARG = 1;
    private static final int SELF_ARG = 2;

    BoundMethodHandle(DirectMethodHandle directMethodHandle, Object object) {
        super(Access.TOKEN, directMethodHandle.type().dropParameterType(0));
        this.argument = BoundMethodHandle.checkReferenceArgument(object, directMethodHandle, 0);
        this.vmargslot = this.type().parameterSlotCount();
        if (MethodHandleNatives.JVM_SUPPORT) {
            this.vmtarget = null;
            MethodHandleNatives.init(this, (Object)directMethodHandle, 0);
        } else {
            this.vmtarget = directMethodHandle;
        }
    }

    BoundMethodHandle(MethodHandle methodHandle, Object object, int n) {
        this(methodHandle, object, n, methodHandle.type().parameterType(n).isPrimitive() ? 1 : 0);
    }

    BoundMethodHandle(MethodHandle methodHandle, Object object, int n, int n2) {
        super(Access.TOKEN, methodHandle.type().dropParameterType(n));
        if (n2 == 1) {
            this.argument = BoundMethodHandle.bindPrimitiveArgument(object, methodHandle, n);
        } else {
            if (n2 == 2) {
                object = this;
            }
            this.argument = BoundMethodHandle.checkReferenceArgument(object, methodHandle, n);
        }
        this.vmargslot = this.type().parameterSlotDepth(n);
        if (MethodHandleNatives.JVM_SUPPORT) {
            this.vmtarget = null;
            MethodHandleNatives.init(this, (Object)methodHandle, n);
        } else {
            this.vmtarget = methodHandle;
        }
    }

    BoundMethodHandle(MethodType methodType, Object object, int n) {
        super(Access.TOKEN, methodType);
        this.argument = object;
        this.vmargslot = n;
        assert (this.getClass() == AdapterMethodHandle.class);
    }

    public BoundMethodHandle(MethodHandle methodHandle, int n) {
        this(methodHandle, null, n, 2);
    }

    public BoundMethodHandle(MethodHandle methodHandle) {
        this(methodHandle, null, 0, 2);
    }

    static final Object checkReferenceArgument(Object object, MethodHandle methodHandle, int n) {
        Class<?> clazz = methodHandle.type().parameterType(n);
        if (!clazz.isPrimitive()) {
            if (object == null) {
                return null;
            }
            if (VerifyType.isNullReferenceConversion(object.getClass(), clazz)) {
                return object;
            }
        }
        throw BoundMethodHandle.badBoundArgumentException(object, methodHandle, n);
    }

    static final Object bindPrimitiveArgument(Object object, MethodHandle methodHandle, int n) {
        Class<?> clazz = methodHandle.type().parameterType(n);
        Wrapper wrapper = Wrapper.forPrimitiveType(clazz);
        Object object2 = wrapper.zero();
        if (object2 != null) {
            if (object == null) {
                if (clazz != Integer.TYPE && wrapper.isSubwordOrInt()) {
                    return 0;
                }
                return object2;
            }
            if (VerifyType.isNullReferenceConversion(object.getClass(), object2.getClass())) {
                if (clazz != Integer.TYPE && wrapper.isSubwordOrInt()) {
                    return Wrapper.INT.wrap(object);
                }
                return object;
            }
        }
        throw BoundMethodHandle.badBoundArgumentException(object, methodHandle, n);
    }

    static final RuntimeException badBoundArgumentException(Object object, MethodHandle methodHandle, int n) {
        String string = object == null ? "null" : object.getClass().toString();
        return new WrongMethodTypeException("cannot bind " + string + " argument to parameter #" + n + " of " + methodHandle.type());
    }

    @Override
    public String toString() {
        return "Bound[" + super.toString() + "]";
    }
}

