/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Scanner;
import java.util.logging.Logger;
import sun.awt.FontConfiguration;
import sun.awt.FontDescriptor;
import sun.awt.SunToolkit;
import sun.font.CompositeFontDescriptor;
import sun.font.FontManager;
import sun.java2d.SunGraphicsEnvironment;

public class FcFontConfiguration
extends FontConfiguration {
    private static final String fileVersion = "1";
    private String fcInfoFileName = null;
    private FontManager.FcCompFont[] fcCompFonts = null;

    public FcFontConfiguration(SunGraphicsEnvironment sunGraphicsEnvironment) {
        super(sunGraphicsEnvironment);
        this.init();
    }

    public FcFontConfiguration(SunGraphicsEnvironment sunGraphicsEnvironment, boolean bl, boolean bl2) {
        super(sunGraphicsEnvironment, bl, bl2);
        this.init();
    }

    @Override
    public synchronized boolean init() {
        Object object;
        Object object2;
        if (this.fcCompFonts != null) {
            return true;
        }
        this.setFontConfiguration();
        this.readFcInfo();
        if (this.fcCompFonts == null) {
            this.fcCompFonts = FontManager.loadFontConfig();
            if (this.fcCompFonts != null) {
                try {
                    this.writeFcInfo();
                }
                catch (Exception exception) {
                    if (SunGraphicsEnvironment.debugFonts) {
                        object2 = Logger.getLogger("sun.awt.FontConfiguration");
                        ((Logger)object2).warning("Exception writing fcInfo " + exception);
                    }
                }
            } else if (SunGraphicsEnvironment.debugFonts) {
                object = Logger.getLogger("sun.awt.FontConfiguration");
                ((Logger)object).warning("Failed to get info from libfontconfig");
            }
        } else {
            FontManager.populateFontConfig(this.fcCompFonts);
        }
        if (this.fcCompFonts == null) {
            return false;
        }
        object = System.getProperty("java.home");
        if (object == null) {
            throw new Error("java.home property not set");
        }
        object2 = (String)object + File.separator + "lib";
        this.getInstalledFallbackFonts((String)object2);
        return true;
    }

    @Override
    public String getFallbackFamilyName(String string, String string2) {
        String string3 = this.getCompatibilityFamilyName(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    @Override
    protected String getFaceNameFromComponentFontName(String string) {
        return null;
    }

    @Override
    protected String getFileNameFromComponentFontName(String string) {
        return null;
    }

    @Override
    public String getFileNameFromPlatformName(String string) {
        return null;
    }

    @Override
    protected Charset getDefaultFontCharset(String string) {
        return Charset.forName("ISO8859_1");
    }

    @Override
    protected String getEncoding(String string, String string2) {
        return "default";
    }

    @Override
    protected void initReorderMap() {
        this.reorderMap = new HashMap();
    }

    @Override
    public FontDescriptor[] getFontDescriptors(String string, int n) {
        return new FontDescriptor[0];
    }

    @Override
    public int getNumberCoreFonts() {
        return 1;
    }

    @Override
    public String[] getPlatformFontNames() {
        HashSet<String> hashSet = new HashSet<String>();
        FontManager.FcCompFont[] fcCompFontArray = FontManager.loadFontConfig();
        for (int i = 0; i < fcCompFontArray.length; ++i) {
            for (int j = 0; j < fcCompFontArray[i].allFonts.length; ++j) {
                hashSet.add(fcCompFontArray[i].allFonts[j].fontFile);
            }
        }
        return hashSet.toArray(new String[0]);
    }

    @Override
    public String getExtraFontPath() {
        return null;
    }

    @Override
    public boolean needToSearchForFile(String string) {
        return false;
    }

    private FontManager.FontConfigFont[] getFcFontList(FontManager.FcCompFont[] fcCompFontArray, String string, int n) {
        if (string.equals("dialog")) {
            string = "sansserif";
        } else if (string.equals("dialoginput")) {
            string = "monospaced";
        }
        for (int i = 0; i < fcCompFontArray.length; ++i) {
            if (!string.equals(fcCompFontArray[i].jdkName) || n != fcCompFontArray[i].style) continue;
            return fcCompFontArray[i].allFonts;
        }
        return fcCompFontArray[0].allFonts;
    }

    @Override
    public CompositeFontDescriptor[] get2DCompositeFontInfo() {
        FontManager.FcCompFont[] fcCompFontArray = FontManager.loadFontConfig();
        CompositeFontDescriptor[] compositeFontDescriptorArray = new CompositeFontDescriptor[20];
        for (int i = 0; i < 5; ++i) {
            String string = publicFontNames[i];
            for (int j = 0; j < 4; ++j) {
                int n;
                String string2 = string + "." + styleNames[j];
                FontManager.FontConfigFont[] fontConfigFontArray = this.getFcFontList(fcCompFontArray, fontNames[i], j);
                int n2 = fontConfigFontArray.length;
                if (installedFallbackFontFiles != null) {
                    n2 += installedFallbackFontFiles.length;
                }
                String[] stringArray = new String[n2];
                for (n = 0; n < fontConfigFontArray.length; ++n) {
                    stringArray[n] = fontConfigFontArray[n].fontFile;
                }
                if (installedFallbackFontFiles != null) {
                    System.arraycopy(stringArray, n, installedFallbackFontFiles, 0, installedFallbackFontFiles.length);
                }
                compositeFontDescriptorArray[i * 4 + j] = new CompositeFontDescriptor(string2, 1, null, stringArray, null, null);
            }
        }
        return compositeFontDescriptorArray;
    }

    private String getVersionString(File file) {
        try {
            Scanner scanner = new Scanner(file);
            return scanner.findInLine("(\\d)+((\\.)(\\d)+)*");
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected void setOsNameAndVersion() {
        block14: {
            super.setOsNameAndVersion();
            if (!osName.equals("Linux")) {
                return;
            }
            try {
                File file = new File("/etc/lsb-release");
                if (file.canRead()) {
                    Properties properties = new Properties();
                    properties.load(new FileInputStream(file));
                    osName = properties.getProperty("DISTRIB_ID");
                    osVersion = properties.getProperty("DISTRIB_RELEASE");
                } else {
                    file = new File("/etc/redhat-release");
                    if (file.canRead()) {
                        osName = "RedHat";
                        osVersion = this.getVersionString(file);
                    } else {
                        file = new File("/etc/SuSE-release");
                        if (file.canRead()) {
                            osName = "SuSE";
                            osVersion = this.getVersionString(file);
                        } else {
                            file = new File("/etc/turbolinux-release");
                            if (file.canRead()) {
                                osName = "Turbo";
                                osVersion = this.getVersionString(file);
                            } else {
                                file = new File("/etc/fedora-release");
                                if (file.canRead()) {
                                    osName = "Fedora";
                                    osVersion = this.getVersionString(file);
                                } else {
                                    file = new File("/etc/sun-release");
                                    if (file.canRead()) {
                                        osName = "Sun";
                                        osVersion = this.getVersionString(file);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!SunGraphicsEnvironment.debugFonts) break block14;
                Logger logger = Logger.getLogger("sun.awt.FontConfiguration");
                logger.warning("Exception identifying Linux distro.");
            }
        }
    }

    private File getFcInfoFile() {
        if (this.fcInfoFileName == null) {
            String string;
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                string = "localhost";
            }
            String string2 = System.getProperty("user.home");
            String string3 = System.getProperty("java.version");
            String string4 = File.separator;
            String string5 = string2 + string4 + ".java" + string4 + "fonts" + string4 + string3;
            String string6 = SunToolkit.getStartupLocale().getLanguage();
            String string7 = "fcinfo-1-" + string + "-" + osName + "-" + osVersion + "-" + string6 + ".properties";
            this.fcInfoFileName = string5 + string4 + string7;
        }
        return new File(this.fcInfoFileName);
    }

    private void writeFcInfo() {
        block7: {
            Object object;
            Object object2;
            int n;
            Properties properties = new Properties();
            properties.setProperty("version", fileVersion);
            FontManager.FontConfigInfo fontConfigInfo = FontManager.getFontConfigInfo();
            properties.setProperty("fcversion", Integer.toString(fontConfigInfo.fcVersion));
            if (fontConfigInfo.cacheDirs != null) {
                for (n = 0; n < fontConfigInfo.cacheDirs.length; ++n) {
                    if (fontConfigInfo.cacheDirs[n] == null) continue;
                    properties.setProperty("cachedir." + n, fontConfigInfo.cacheDirs[n]);
                }
            }
            for (n = 0; n < this.fcCompFonts.length; ++n) {
                object2 = this.fcCompFonts[n];
                object = ((FontManager.FcCompFont)object2).jdkName + "." + ((FontManager.FcCompFont)object2).style;
                properties.setProperty((String)object + ".length", Integer.toString(((FontManager.FcCompFont)object2).allFonts.length));
                for (int i = 0; i < ((FontManager.FcCompFont)object2).allFonts.length; ++i) {
                    properties.setProperty((String)object + "." + i + ".family", ((FontManager.FcCompFont)object2).allFonts[i].familyName);
                    properties.setProperty((String)object + "." + i + ".file", ((FontManager.FcCompFont)object2).allFonts[i].fontFile);
                }
            }
            try {
                File file = this.getFcInfoFile();
                object2 = file.getParentFile();
                ((File)object2).mkdirs();
                object = File.createTempFile("fcinfo", null, (File)object2);
                FileOutputStream fileOutputStream = new FileOutputStream((File)object);
                properties.store(fileOutputStream, "JDK Font Configuration Generated File: *Do Not Edit*");
                fileOutputStream.close();
                boolean bl = ((File)object).renameTo(file);
                if (!bl && SunGraphicsEnvironment.debugFonts) {
                    System.out.println("rename failed");
                    Logger logger = Logger.getLogger("sun.awt.FontConfiguration");
                    logger.warning("Failed renaming file to " + this.getFcInfoFile());
                }
            }
            catch (Exception exception) {
                if (!SunGraphicsEnvironment.debugFonts) break block7;
                object2 = Logger.getLogger("sun.awt.FontConfiguration");
                ((Logger)object2).warning("IOException writing to " + this.getFcInfoFile());
            }
        }
    }

    private void readFcInfo() {
        block18: {
            String[] stringArray;
            String[] stringArray2;
            Object object;
            File file = this.getFcInfoFile();
            if (!file.exists()) {
                return;
            }
            Properties properties = new Properties();
            try {
                object = new FileInputStream(file);
                properties.load((InputStream)object);
                ((FileInputStream)object).close();
            }
            catch (IOException iOException) {
                if (SunGraphicsEnvironment.debugFonts) {
                    Logger logger = Logger.getLogger("sun.awt.FontConfiguration");
                    logger.warning("IOException reading from " + file.toString());
                }
                return;
            }
            object = (String)properties.get("version");
            if (object == null || !((String)object).equals(fileVersion)) {
                return;
            }
            String string = (String)properties.get("fcversion");
            if (string != null) {
                try {
                    int n = Integer.parseInt(string);
                    if (n != 0 && n != FontManager.getFontConfigVersion()) {
                        return;
                    }
                }
                catch (Exception exception) {
                    if (SunGraphicsEnvironment.debugFonts) {
                        Logger logger = Logger.getLogger("sun.awt.FontConfiguration");
                        logger.warning("Exception parsing version " + string);
                    }
                    return;
                }
            }
            long l = file.lastModified();
            for (int i = 0; i < 4 && (stringArray2 = (String[])properties.get("cachedir." + i)) != null; ++i) {
                stringArray = new File((String)stringArray2);
                if (!stringArray.exists() || stringArray.lastModified() <= l) continue;
                return;
            }
            stringArray2 = new String[]{"sansserif", "serif", "monospaced"};
            stringArray = new String[]{"sans", "serif", "monospace"};
            int n = stringArray2.length;
            int n2 = 4;
            FontManager.FcCompFont[] fcCompFontArray = new FontManager.FcCompFont[n * n2];
            try {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        int n3 = i * n2 + j;
                        fcCompFontArray[n3] = new FontManager.FcCompFont();
                        String string2 = stringArray2[i] + "." + j;
                        fcCompFontArray[n3].jdkName = stringArray2[i];
                        fcCompFontArray[n3].fcFamily = stringArray[i];
                        fcCompFontArray[n3].style = j;
                        String string3 = (String)properties.get(string2 + ".length");
                        int n4 = Integer.parseInt(string3);
                        if (n4 <= 0) {
                            return;
                        }
                        fcCompFontArray[n3].allFonts = new FontManager.FontConfigFont[n4];
                        for (int k = 0; k < n4; ++k) {
                            String string4;
                            fcCompFontArray[n3].allFonts[k] = new FontManager.FontConfigFont();
                            String string5 = string2 + "." + k + ".family";
                            fcCompFontArray[n3].allFonts[k].familyName = string4 = (String)properties.get(string5);
                            string5 = string2 + "." + k + ".file";
                            String string6 = (String)properties.get(string5);
                            if (string6 == null) {
                                return;
                            }
                            fcCompFontArray[n3].allFonts[k].fontFile = string6;
                        }
                        fcCompFontArray[n3].firstFont = fcCompFontArray[n3].allFonts[0];
                    }
                }
                this.fcCompFonts = fcCompFontArray;
            }
            catch (Throwable throwable) {
                if (!SunGraphicsEnvironment.debugFonts) break block18;
                Logger logger = Logger.getLogger("sun.awt.FontConfiguration");
                logger.warning(throwable.toString());
            }
        }
    }
}

