/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;

public class Surrogate {
    public static final char MIN_HIGH = '\ud800';
    public static final char MAX_HIGH = '\udbff';
    public static final char MIN_LOW = '\udc00';
    public static final char MAX_LOW = '\udfff';
    public static final char MIN = '\ud800';
    public static final char MAX = '\udfff';
    public static final int UCS4_MIN = 65536;
    public static final int UCS4_MAX = 0x10FFFF;

    private Surrogate() {
    }

    public static boolean isHigh(int n) {
        return 55296 <= n && n <= 56319;
    }

    public static boolean isLow(int n) {
        return 56320 <= n && n <= 57343;
    }

    public static boolean is(int n) {
        return 55296 <= n && n <= 57343;
    }

    public static boolean isBMP(int n) {
        return (char)n == n;
    }

    public static boolean neededFor(int n) {
        return Character.isSupplementaryCodePoint(n);
    }

    public static char high(int n) {
        assert (Character.isSupplementaryCodePoint(n));
        return (char)((n >> 10) + 55232);
    }

    public static char low(int n) {
        assert (Character.isSupplementaryCodePoint(n));
        return (char)((n & 0x3FF) + 56320);
    }

    public static int toUCS4(char c, char c2) {
        assert (Character.isHighSurrogate(c) && Character.isLowSurrogate(c2));
        return Character.toCodePoint(c, c2);
    }

    public static class Generator {
        private CoderResult error = CoderResult.OVERFLOW;

        public CoderResult error() {
            assert (this.error != null);
            return this.error;
        }

        public int generate(int n, int n2, CharBuffer charBuffer) {
            if (Surrogate.isBMP(n)) {
                if (Surrogate.is(n)) {
                    this.error = CoderResult.malformedForLength(n2);
                    return -1;
                }
                if (charBuffer.remaining() < 1) {
                    this.error = CoderResult.OVERFLOW;
                    return -1;
                }
                charBuffer.put((char)n);
                this.error = null;
                return 1;
            }
            if (Character.isSupplementaryCodePoint(n)) {
                if (charBuffer.remaining() < 2) {
                    this.error = CoderResult.OVERFLOW;
                    return -1;
                }
                charBuffer.put(Surrogate.high(n));
                charBuffer.put(Surrogate.low(n));
                this.error = null;
                return 2;
            }
            this.error = CoderResult.unmappableForLength(n2);
            return -1;
        }

        public int generate(int n, int n2, char[] cArray, int n3, int n4) {
            if (Surrogate.isBMP(n)) {
                if (Surrogate.is(n)) {
                    this.error = CoderResult.malformedForLength(n2);
                    return -1;
                }
                if (n4 - n3 < 1) {
                    this.error = CoderResult.OVERFLOW;
                    return -1;
                }
                cArray[n3] = (char)n;
                this.error = null;
                return 1;
            }
            if (Character.isSupplementaryCodePoint(n)) {
                if (n4 - n3 < 2) {
                    this.error = CoderResult.OVERFLOW;
                    return -1;
                }
                cArray[n3] = Surrogate.high(n);
                cArray[n3 + 1] = Surrogate.low(n);
                this.error = null;
                return 2;
            }
            this.error = CoderResult.unmappableForLength(n2);
            return -1;
        }
    }

    public static class Parser {
        private int character;
        private CoderResult error = CoderResult.UNDERFLOW;
        private boolean isPair;

        public int character() {
            assert (this.error == null);
            return this.character;
        }

        public boolean isPair() {
            assert (this.error == null);
            return this.isPair;
        }

        public int increment() {
            assert (this.error == null);
            return this.isPair ? 2 : 1;
        }

        public CoderResult error() {
            assert (this.error != null);
            return this.error;
        }

        public CoderResult unmappableResult() {
            assert (this.error == null);
            return CoderResult.unmappableForLength(this.isPair ? 2 : 1);
        }

        public int parse(char c, CharBuffer charBuffer) {
            if (Character.isHighSurrogate(c)) {
                if (!charBuffer.hasRemaining()) {
                    this.error = CoderResult.UNDERFLOW;
                    return -1;
                }
                char c2 = charBuffer.get();
                if (Character.isLowSurrogate(c2)) {
                    this.character = Character.toCodePoint(c, c2);
                    this.isPair = true;
                    this.error = null;
                    return this.character;
                }
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            if (Character.isLowSurrogate(c)) {
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            this.character = c;
            this.isPair = false;
            this.error = null;
            return this.character;
        }

        public int parse(char c, char[] cArray, int n, int n2) {
            assert (cArray[n] == c);
            if (Character.isHighSurrogate(c)) {
                if (n2 - n < 2) {
                    this.error = CoderResult.UNDERFLOW;
                    return -1;
                }
                char c2 = cArray[n + 1];
                if (Character.isLowSurrogate(c2)) {
                    this.character = Character.toCodePoint(c, c2);
                    this.isPair = true;
                    this.error = null;
                    return this.character;
                }
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            if (Character.isLowSurrogate(c)) {
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            this.character = c;
            this.isPair = false;
            this.error = null;
            return this.character;
        }
    }
}

