/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.action.GetPropertyAction;
import sun.security.provider.certpath.ForwardBuilder;
import sun.security.provider.certpath.URICertStore;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.CRLDistributionPointsExtension;
import sun.security.x509.DistributionPoint;
import sun.security.x509.DistributionPointName;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.IssuingDistributionPointExtension;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.RDN;
import sun.security.x509.ReasonFlags;
import sun.security.x509.SerialNumber;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;

class DistributionPointFetcher {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final boolean[] ALL_REASONS = new boolean[]{true, true, true, true, true, true, true, true, true};
    private static final boolean USE_CRLDP = DistributionPointFetcher.getBooleanProperty("com.sun.security.enableCRLDP", false);
    private static final DistributionPointFetcher INSTANCE = new DistributionPointFetcher();

    public static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = AccessController.doPrivileged(new GetPropertyAction(string));
        if (string2 == null) {
            return bl;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        throw new RuntimeException("Value of " + string + " must either be 'true' or 'false'");
    }

    private DistributionPointFetcher() {
    }

    static DistributionPointFetcher getInstance() {
        return INSTANCE;
    }

    Collection<X509CRL> getCRLs(X509CRLSelector x509CRLSelector, boolean bl, PublicKey publicKey, String string, List<CertStore> list, boolean[] blArray, TrustAnchor trustAnchor) throws CertStoreException {
        if (!USE_CRLDP) {
            return Collections.emptySet();
        }
        X509Certificate x509Certificate = x509CRLSelector.getCertificateChecking();
        if (x509Certificate == null) {
            return Collections.emptySet();
        }
        try {
            CRLDistributionPointsExtension cRLDistributionPointsExtension;
            X509CertImpl x509CertImpl = X509CertImpl.toImpl(x509Certificate);
            if (debug != null) {
                debug.println("DistributionPointFetcher.getCRLs: Checking CRLDPs for " + x509CertImpl.getSubjectX500Principal());
            }
            if ((cRLDistributionPointsExtension = x509CertImpl.getCRLDistributionPointsExtension()) == null) {
                if (debug != null) {
                    debug.println("No CRLDP ext");
                }
                return Collections.emptySet();
            }
            List list2 = (List)cRLDistributionPointsExtension.get("points");
            HashSet<X509CRL> hashSet = new HashSet<X509CRL>();
            Iterator iterator = list2.iterator();
            while (iterator.hasNext() && !Arrays.equals(blArray, ALL_REASONS)) {
                DistributionPoint distributionPoint = (DistributionPoint)iterator.next();
                Collection<X509CRL> collection = this.getCRLs(x509CRLSelector, x509CertImpl, distributionPoint, blArray, bl, publicKey, string, list, trustAnchor);
                hashSet.addAll(collection);
            }
            if (debug != null) {
                debug.println("Returning " + hashSet.size() + " CRLs");
            }
            return hashSet;
        }
        catch (CertificateException certificateException) {
            return Collections.emptySet();
        }
        catch (IOException iOException) {
            return Collections.emptySet();
        }
    }

    private Collection<X509CRL> getCRLs(X509CRLSelector x509CRLSelector, X509CertImpl x509CertImpl, DistributionPoint distributionPoint, boolean[] blArray, boolean bl, PublicKey publicKey, String string, List<CertStore> list, TrustAnchor trustAnchor) {
        Object object;
        Object object2;
        Object object3;
        GeneralNames generalNames = distributionPoint.getFullName();
        if (generalNames == null) {
            object3 = distributionPoint.getRelativeName();
            if (object3 == null) {
                return Collections.emptySet();
            }
            try {
                object2 = distributionPoint.getCRLIssuer();
                if (object2 == null) {
                    generalNames = this.getFullNames((X500Name)x509CertImpl.getIssuerDN(), (RDN)object3);
                } else {
                    if (((GeneralNames)object2).size() != 1) {
                        return Collections.emptySet();
                    }
                    generalNames = this.getFullNames((X500Name)((GeneralNames)object2).get(0).getName(), (RDN)object3);
                }
            }
            catch (IOException iOException) {
                return Collections.emptySet();
            }
        }
        object3 = new ArrayList();
        object2 = new ArrayList(2);
        Iterator<GeneralName> iterator = generalNames.iterator();
        while (iterator.hasNext()) {
            X509CRL x509CRL;
            GeneralNameInterface generalNameInterface;
            object = iterator.next();
            if (((GeneralName)object).getType() == 4) {
                generalNameInterface = (X500Name)((GeneralName)object).getName();
                object3.addAll(this.getCRLs((X500Name)generalNameInterface, x509CertImpl.getIssuerX500Principal(), list));
                continue;
            }
            if (((GeneralName)object).getType() != 6 || (x509CRL = this.getCRL((URIName)(generalNameInterface = (URIName)((GeneralName)object).getName()))) == null) continue;
            object3.add(x509CRL);
        }
        iterator = object3.iterator();
        while (iterator.hasNext()) {
            object = (X509CRL)((Object)iterator.next());
            try {
                x509CRLSelector.setIssuerNames(null);
                if (!x509CRLSelector.match((CRL)object) || !this.verifyCRL(x509CertImpl, distributionPoint, (X509CRL)object, blArray, bl, publicKey, string, trustAnchor, list)) continue;
                object2.add(object);
            }
            catch (Exception exception) {
                if (debug == null) continue;
                debug.println("Exception verifying CRL: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        return object2;
    }

    private X509CRL getCRL(URIName uRIName) {
        URI uRI = uRIName.getURI();
        if (debug != null) {
            debug.println("Trying to fetch CRL from DP " + uRI);
        }
        try {
            CertStore certStore = URICertStore.getInstance(new URICertStore.URICertStoreParameters(uRI));
            Collection<? extends CRL> collection = certStore.getCRLs(null);
            if (collection.isEmpty()) {
                return null;
            }
            return (X509CRL)collection.iterator().next();
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("Exception getting CRL from CertStore: " + exception);
                exception.printStackTrace();
            }
            return null;
        }
    }

    private Collection<X509CRL> getCRLs(X500Name x500Name, X500Principal x500Principal, List<CertStore> list) {
        if (debug != null) {
            debug.println("Trying to fetch CRL from DP " + x500Name);
        }
        X509CRLSelector x509CRLSelector = new X509CRLSelector();
        x509CRLSelector.addIssuer(x500Name.asX500Principal());
        x509CRLSelector.addIssuer(x500Principal);
        ArrayList<X509CRL> arrayList = new ArrayList<X509CRL>();
        for (CertStore certStore : list) {
            try {
                for (CRL cRL : certStore.getCRLs(x509CRLSelector)) {
                    arrayList.add((X509CRL)cRL);
                }
            }
            catch (CertStoreException certStoreException) {
                if (debug == null) continue;
                debug.println("Non-fatal exception while retrieving CRLs: " + certStoreException);
                certStoreException.printStackTrace();
            }
        }
        return arrayList;
    }

    boolean verifyCRL(X509CertImpl x509CertImpl, DistributionPoint distributionPoint, X509CRL x509CRL, boolean[] blArray, boolean bl, PublicKey publicKey, String string, TrustAnchor trustAnchor, List<CertStore> list) throws CRLException, IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        boolean bl2 = false;
        X509CRLImpl x509CRLImpl = X509CRLImpl.toImpl(x509CRL);
        IssuingDistributionPointExtension issuingDistributionPointExtension = x509CRLImpl.getIssuingDistributionPointExtension();
        X500Name x500Name = (X500Name)x509CertImpl.getIssuerDN();
        X500Name x500Name2 = (X500Name)x509CRLImpl.getIssuerDN();
        GeneralNames generalNames = distributionPoint.getCRLIssuer();
        X500Name x500Name3 = null;
        if (generalNames != null) {
            if (issuingDistributionPointExtension == null || ((Boolean)issuingDistributionPointExtension.get("indirect_crl")).equals(Boolean.FALSE)) {
                return false;
            }
            boolean bl3 = false;
            object5 = generalNames.iterator();
            while (!bl3 && object5.hasNext()) {
                object4 = ((GeneralName)object5.next()).getName();
                if (!x500Name2.equals(object4)) continue;
                x500Name3 = (X500Name)object4;
                bl3 = true;
            }
            if (!bl3) {
                return false;
            }
            if (ForwardBuilder.issues(x509CertImpl, x509CRLImpl, string)) {
                publicKey = x509CertImpl.getPublicKey();
            } else {
                bl2 = true;
            }
        } else {
            if (!x500Name2.equals(x500Name)) {
                if (debug != null) {
                    debug.println("crl issuer does not equal cert issuer");
                }
                return false;
            }
            byte[] byArray = x509CertImpl.getExtensionValue(PKIXExtensions.AuthorityKey_Id.toString());
            if (!Arrays.equals(byArray, (byte[])(object5 = (Object)x509CRLImpl.getExtensionValue(PKIXExtensions.AuthorityKey_Id.toString())))) {
                if (ForwardBuilder.issues(x509CertImpl, x509CRLImpl, string)) {
                    publicKey = x509CertImpl.getPublicKey();
                } else {
                    bl2 = true;
                }
            }
        }
        if (!bl2 && !bl) {
            return false;
        }
        if (issuingDistributionPointExtension != null) {
            DistributionPointName distributionPointName = (DistributionPointName)issuingDistributionPointExtension.get("point");
            if (distributionPointName != null) {
                Object object6;
                object5 = distributionPointName.getFullName();
                if (object5 == null) {
                    object4 = distributionPointName.getRelativeName();
                    if (object4 == null) {
                        if (debug != null) {
                            debug.println("IDP must be relative or full DN");
                        }
                        return false;
                    }
                    if (debug != null) {
                        debug.println("IDP relativeName:" + object4);
                    }
                    object5 = this.getFullNames(x500Name2, (RDN)object4);
                }
                if (distributionPoint.getFullName() != null || distributionPoint.getRelativeName() != null) {
                    object4 = distributionPoint.getFullName();
                    if (object4 == null) {
                        RDN rDN = distributionPoint.getRelativeName();
                        if (rDN == null) {
                            if (debug != null) {
                                debug.println("DP must be relative or full DN");
                            }
                            return false;
                        }
                        if (debug != null) {
                            debug.println("DP relativeName:" + rDN);
                        }
                        if (bl2) {
                            if (generalNames.size() != 1) {
                                if (debug != null) {
                                    debug.println("must only be one CRL issuer when relative name present");
                                }
                                return false;
                            }
                            object4 = this.getFullNames(x500Name3, rDN);
                        } else {
                            object4 = this.getFullNames(x500Name, rDN);
                        }
                    }
                    boolean bl4 = false;
                    object6 = ((GeneralNames)object5).iterator();
                    while (!bl4 && object6.hasNext()) {
                        object3 = object6.next().getName();
                        if (debug != null) {
                            debug.println("idpName: " + object3);
                        }
                        object2 = ((GeneralNames)object4).iterator();
                        while (!bl4 && object2.hasNext()) {
                            object = ((GeneralName)object2.next()).getName();
                            if (debug != null) {
                                debug.println("pointName: " + object);
                            }
                            bl4 = object3.equals(object);
                        }
                    }
                    if (!bl4) {
                        if (debug != null) {
                            debug.println("IDP name does not match DP name");
                        }
                        return false;
                    }
                } else {
                    boolean bl5 = false;
                    Iterator<GeneralName> iterator = generalNames.iterator();
                    while (!bl5 && iterator.hasNext()) {
                        object6 = iterator.next().getName();
                        object3 = ((GeneralNames)object5).iterator();
                        while (!bl5 && object3.hasNext()) {
                            object2 = ((GeneralName)object3.next()).getName();
                            bl5 = object6.equals(object2);
                        }
                    }
                    if (!bl5) {
                        return false;
                    }
                }
            }
            if (((Boolean)(object5 = (Boolean)issuingDistributionPointExtension.get("only_user_certs"))).equals(Boolean.TRUE) && x509CertImpl.getBasicConstraints() != -1) {
                if (debug != null) {
                    debug.println("cert must be a EE cert");
                }
                return false;
            }
            object5 = (Boolean)issuingDistributionPointExtension.get("only_ca_certs");
            if (((Boolean)object5).equals(Boolean.TRUE) && x509CertImpl.getBasicConstraints() == -1) {
                if (debug != null) {
                    debug.println("cert must be a CA cert");
                }
                return false;
            }
            object5 = (Boolean)issuingDistributionPointExtension.get("only_attribute_certs");
            if (((Boolean)object5).equals(Boolean.TRUE)) {
                if (debug != null) {
                    debug.println("cert must not be an AA cert");
                }
                return false;
            }
        }
        boolean[] blArray2 = new boolean[9];
        object5 = null;
        if (issuingDistributionPointExtension != null) {
            object5 = (ReasonFlags)issuingDistributionPointExtension.get("reasons");
        }
        boolean[] blArray3 = distributionPoint.getReasonFlags();
        if (object5 != null) {
            if (blArray3 != null) {
                boolean[] blArray4 = ((ReasonFlags)object5).getFlags();
                for (int i = 0; i < blArray4.length; ++i) {
                    if (!blArray4[i] || !blArray3[i]) continue;
                    blArray2[i] = true;
                }
            } else {
                blArray2 = (boolean[])((ReasonFlags)object5).getFlags().clone();
            }
        } else if (issuingDistributionPointExtension == null || object5 == null) {
            if (blArray3 != null) {
                blArray2 = (boolean[])blArray3.clone();
            } else {
                blArray2 = new boolean[9];
                Arrays.fill(blArray2, true);
            }
        }
        boolean bl6 = false;
        for (int i = 0; i < blArray2.length && !bl6; ++i) {
            if (blArray[i] || !blArray2[i]) continue;
            bl6 = true;
        }
        if (!bl6) {
            return false;
        }
        if (bl2) {
            Object object7;
            Object object8;
            X509CertSelector x509CertSelector = new X509CertSelector();
            x509CertSelector.setSubject(x500Name2.asX500Principal());
            object3 = new boolean[]{false, false, false, false, false, false, true};
            x509CertSelector.setKeyUsage((boolean[])object3);
            object2 = x509CRLImpl.getAuthKeyIdExtension();
            if (object2 != null) {
                Object object9;
                object = (KeyIdentifier)((AuthorityKeyIdentifierExtension)object2).get("key_id");
                if (object != null) {
                    object9 = new DerOutputStream();
                    ((DerOutputStream)object9).putOctetString(((KeyIdentifier)object).getIdentifier());
                    x509CertSelector.setSubjectKeyIdentifier(((ByteArrayOutputStream)object9).toByteArray());
                }
                if ((object9 = (SerialNumber)((AuthorityKeyIdentifierExtension)object2).get("serial_number")) != null) {
                    x509CertSelector.setSerialNumber(((SerialNumber)object9).getNumber());
                }
            }
            object = new HashSet();
            if (trustAnchor != null) {
                object.add(trustAnchor);
            }
            if (publicKey != null) {
                Object object10;
                boolean bl7 = false;
                object8 = publicKey;
                object7 = x509CertImpl.getIssuerX500Principal();
                if (trustAnchor != null) {
                    PublicKey publicKey2;
                    X500Principal x500Principal;
                    object10 = trustAnchor.getTrustedCert();
                    if (object10 != null) {
                        x500Principal = ((X509Certificate)object10).getSubjectX500Principal();
                        publicKey2 = ((Certificate)object10).getPublicKey();
                    } else {
                        x500Principal = trustAnchor.getCA();
                        publicKey2 = trustAnchor.getCAPublicKey();
                    }
                    if (((X500Principal)object7).equals(x500Principal) && object8.equals(publicKey2)) {
                        bl7 = true;
                    }
                }
                if (!bl7) {
                    object10 = new TrustAnchor((X500Principal)object7, (PublicKey)object8, null);
                    object.add(object10);
                }
            }
            PKIXBuilderParameters pKIXBuilderParameters = null;
            try {
                pKIXBuilderParameters = new PKIXBuilderParameters((Set<TrustAnchor>)object, (CertSelector)x509CertSelector);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new CRLException(invalidAlgorithmParameterException);
            }
            pKIXBuilderParameters.setCertStores(list);
            pKIXBuilderParameters.setSigProvider(string);
            try {
                object8 = CertPathBuilder.getInstance("PKIX");
                object7 = (PKIXCertPathBuilderResult)((CertPathBuilder)object8).build(pKIXBuilderParameters);
                publicKey = ((PKIXCertPathValidatorResult)object7).getPublicKey();
            }
            catch (Exception exception) {
                throw new CRLException(exception);
            }
        }
        try {
            x509CRL.verify(publicKey, string);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("CRL signature failed to verify");
            }
            return false;
        }
        Set<String> set = x509CRL.getCriticalExtensionOIDs();
        if (set != null) {
            set.remove(PKIXExtensions.IssuingDistributionPoint_Id.toString());
            if (!set.isEmpty()) {
                if (debug != null) {
                    debug.println("Unrecognized critical extension(s) in CRL: " + set);
                    object3 = set.iterator();
                    while (object3.hasNext()) {
                        debug.println((String)object3.next());
                    }
                }
                return false;
            }
        }
        for (int i = 0; i < blArray2.length; ++i) {
            if (blArray[i] || !blArray2[i]) continue;
            blArray[i] = true;
        }
        return true;
    }

    private GeneralNames getFullNames(X500Name x500Name, RDN rDN) throws IOException {
        ArrayList<RDN> arrayList = new ArrayList<RDN>(x500Name.rdns());
        arrayList.add(rDN);
        X500Name x500Name2 = new X500Name(arrayList.toArray(new RDN[0]));
        GeneralNames generalNames = new GeneralNames();
        generalNames.add(new GeneralName(x500Name2));
        return generalNames;
    }
}

