/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.action;

import com.sun.java.swing.action.DelegateAction;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;

public abstract class StateChangeAction
extends DelegateAction
implements ItemListener {
    protected boolean selected = false;
    private ItemListener listener;

    public StateChangeAction(String name) {
        super(name, null);
    }

    public StateChangeAction(String name, Icon icon) {
        super(name, icon);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public synchronized void setSelected(boolean newValue) {
        boolean oldValue = this.selected;
        if (oldValue != newValue) {
            this.selected = newValue;
            this.firePropertyChange("selected", oldValue, newValue);
        }
    }

    public void setItemListener(ItemListener listener) {
        this.listener = listener;
    }

    public ItemListener getItemListener() {
        return this.listener;
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.setSelected(true);
        } else {
            this.setSelected(false);
        }
        if (this.listener != null) {
            this.listener.itemStateChanged(evt);
        }
    }
}

