/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.sparc.InstructionDecoder;
import sun.jvm.hotspot.asm.sparc.RegisterDecoder;
import sun.jvm.hotspot.asm.sparc.SPARCInstructionFactory;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;

abstract class FloatDecoder
extends InstructionDecoder {
    final int opf;
    final String name;
    final int numSources;
    final int src1Type;
    final int src2Type;
    final int resultType;

    FloatDecoder(int opf, String name, int src1Type, int src2Type, int resultType) {
        this.opf = opf;
        this.name = name;
        this.numSources = 2;
        this.src1Type = src1Type;
        this.src2Type = src2Type;
        this.resultType = resultType;
    }

    FloatDecoder(int opf, String name, int src2Type, int resultType) {
        this.opf = opf;
        this.name = name;
        this.numSources = 1;
        this.src1Type = Integer.MAX_VALUE;
        this.src2Type = src2Type;
        this.resultType = resultType;
    }

    abstract Instruction decodeFloatInstruction(int var1, SPARCRegister var2, SPARCRegister var3, SPARCRegister var4, SPARCInstructionFactory var5);

    Instruction decode(int instruction, SPARCInstructionFactory factory) {
        int rs1Num = FloatDecoder.getSourceRegister1(instruction);
        int rs2Num = FloatDecoder.getSourceRegister2(instruction);
        int rdNum = FloatDecoder.getDestinationRegister(instruction);
        SPARCRegister rs1 = null;
        if (this.numSources == 2 && (rs1 = RegisterDecoder.decode(this.src1Type, rs1Num)) == null) {
            return factory.newIllegalInstruction(instruction);
        }
        SPARCRegister rd = RegisterDecoder.decode(this.resultType, rdNum);
        SPARCRegister rs2 = RegisterDecoder.decode(this.src2Type, rs2Num);
        if (rd == null || rs2 == null) {
            return factory.newIllegalInstruction(instruction);
        }
        return this.decodeFloatInstruction(instruction, rs1, rs2, rd, factory);
    }
}

