/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Address;
import sun.jvm.hotspot.asm.LoadInstruction;
import sun.jvm.hotspot.asm.Register;
import sun.jvm.hotspot.asm.sparc.SPARCMemoryInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisterIndirectAddress;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;

public class SPARCLoadInstruction
extends SPARCMemoryInstruction
implements LoadInstruction {
    protected final SPARCRegister register2;
    protected final Register[] loadDestinations;

    public SPARCLoadInstruction(String name, int opcode, SPARCRegisterIndirectAddress address, SPARCRegister register, int dataType) {
        super(name, opcode, address, register, dataType);
        if (opcode == 3 || opcode == 19) {
            int nextRegNum = (register.getNumber() + 1) % 32;
            this.register2 = SPARCRegisters.getRegister(nextRegNum);
            this.loadDestinations = new Register[2];
            this.loadDestinations[0] = register;
            this.loadDestinations[1] = this.register2;
        } else {
            this.register2 = null;
            this.loadDestinations = new Register[1];
            this.loadDestinations[0] = register;
        }
    }

    protected String getDescription() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        buf.append(spaces);
        buf.append(this.address.toString());
        buf.append(comma);
        buf.append(this.register.toString());
        return buf.toString();
    }

    public Register[] getLoadDestinations() {
        return this.loadDestinations;
    }

    public Address getLoadSource() {
        return this.address;
    }

    public boolean isLoad() {
        return true;
    }
}

