/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.code;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import sun.jvm.hotspot.code.DebugInfoReadStream;
import sun.jvm.hotspot.code.ScopeValue;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.utilities.Assert;

public class ObjectValue
extends ScopeValue {
    private int id;
    private ScopeValue klass;
    private List fieldsValue;

    public ObjectValue(int id) {
        this.id = id;
        this.klass = null;
        this.fieldsValue = new ArrayList();
    }

    public boolean isObject() {
        return true;
    }

    public int id() {
        return this.id;
    }

    public ScopeValue getKlass() {
        return this.klass;
    }

    public List getFieldsValue() {
        return this.fieldsValue;
    }

    public ScopeValue getFieldAt(int i) {
        return (ScopeValue)this.fieldsValue.get(i);
    }

    public int fieldsSize() {
        return this.fieldsValue.size();
    }

    public OopHandle getValue() {
        return null;
    }

    void readObject(DebugInfoReadStream stream) {
        this.klass = ObjectValue.readFrom(stream);
        Assert.that(this.klass.isConstantOop(), "should be constant klass oop");
        int length = stream.readInt();
        for (int i = 0; i < length; ++i) {
            ScopeValue val = ObjectValue.readFrom(stream);
            this.fieldsValue.add(val);
        }
    }

    public void print() {
        this.printOn(System.out);
    }

    public void printOn(PrintStream tty) {
        tty.print("scalarObj[" + this.id + "]");
    }

    void printFieldsOn(PrintStream tty) {
        if (this.fieldsValue.size() > 0) {
            ((ScopeValue)this.fieldsValue.get(0)).printOn(tty);
        }
        for (int i = 1; i < this.fieldsValue.size(); ++i) {
            tty.print(", ");
            ((ScopeValue)this.fieldsValue.get(i)).printOn(tty);
        }
    }
}

