/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.bsd;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.NotInHeapException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.debugger.UnalignedAddressException;
import sun.jvm.hotspot.debugger.UnmappedAddressException;
import sun.jvm.hotspot.debugger.bsd.BsdDebugger;
import sun.jvm.hotspot.debugger.bsd.BsdOopHandle;

class BsdAddress
implements Address {
    protected BsdDebugger debugger;
    protected long addr;

    BsdAddress(BsdDebugger debugger, long addr) {
        this.debugger = debugger;
        this.addr = addr;
    }

    public boolean equals(Object arg) {
        if (arg == null) {
            return false;
        }
        if (!(arg instanceof BsdAddress)) {
            return false;
        }
        return this.addr == ((BsdAddress)arg).addr;
    }

    public int hashCode() {
        return (int)this.addr;
    }

    public String toString() {
        return this.debugger.addressValueToString(this.addr);
    }

    public long getCIntegerAt(long offset, long numBytes, boolean isUnsigned) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readCInteger(this.addr + offset, numBytes, isUnsigned);
    }

    public Address getAddressAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readAddress(this.addr + offset);
    }

    public Address getCompOopAddressAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readCompOopAddress(this.addr + offset);
    }

    public boolean getJBooleanAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJBoolean(this.addr + offset);
    }

    public byte getJByteAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJByte(this.addr + offset);
    }

    public char getJCharAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJChar(this.addr + offset);
    }

    public double getJDoubleAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJDouble(this.addr + offset);
    }

    public float getJFloatAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJFloat(this.addr + offset);
    }

    public int getJIntAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJInt(this.addr + offset);
    }

    public long getJLongAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJLong(this.addr + offset);
    }

    public short getJShortAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJShort(this.addr + offset);
    }

    public OopHandle getOopHandleAt(long offset) throws UnalignedAddressException, UnmappedAddressException, NotInHeapException {
        return this.debugger.readOopHandle(this.addr + offset);
    }

    public OopHandle getCompOopHandleAt(long offset) throws UnalignedAddressException, UnmappedAddressException, NotInHeapException {
        return this.debugger.readCompOopHandle(this.addr + offset);
    }

    public void setCIntegerAt(long offset, long numBytes, long value) {
        throw new DebuggerException("Unimplemented");
    }

    public void setAddressAt(long offset, Address value) {
        throw new DebuggerException("Unimplemented");
    }

    public void setJBooleanAt(long offset, boolean value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    public void setJByteAt(long offset, byte value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    public void setJCharAt(long offset, char value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    public void setJDoubleAt(long offset, double value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    public void setJFloatAt(long offset, float value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    public void setJIntAt(long offset, int value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    public void setJLongAt(long offset, long value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    public void setJShortAt(long offset, short value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    public void setOopHandleAt(long offset, OopHandle value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    public Address addOffsetTo(long offset) throws UnsupportedOperationException {
        long value = this.addr + offset;
        if (value == 0L) {
            return null;
        }
        return new BsdAddress(this.debugger, value);
    }

    public OopHandle addOffsetToAsOopHandle(long offset) throws UnsupportedOperationException {
        long value = this.addr + offset;
        if (value == 0L) {
            return null;
        }
        return new BsdOopHandle(this.debugger, value);
    }

    public long minus(Address arg) {
        if (arg == null) {
            return this.addr;
        }
        return this.addr - ((BsdAddress)arg).addr;
    }

    public boolean lessThan(Address a) {
        if (a == null) {
            return false;
        }
        BsdAddress arg = (BsdAddress)a;
        if (this.addr >= 0L && arg.addr < 0L) {
            return true;
        }
        if (this.addr < 0L && arg.addr >= 0L) {
            return false;
        }
        return this.addr < arg.addr;
    }

    public boolean lessThanOrEqual(Address a) {
        if (a == null) {
            return false;
        }
        BsdAddress arg = (BsdAddress)a;
        if (this.addr >= 0L && arg.addr < 0L) {
            return true;
        }
        if (this.addr < 0L && arg.addr >= 0L) {
            return false;
        }
        return this.addr <= arg.addr;
    }

    public boolean greaterThan(Address a) {
        if (a == null) {
            return true;
        }
        BsdAddress arg = (BsdAddress)a;
        if (this.addr >= 0L && arg.addr < 0L) {
            return false;
        }
        if (this.addr < 0L && arg.addr >= 0L) {
            return true;
        }
        return this.addr > arg.addr;
    }

    public boolean greaterThanOrEqual(Address a) {
        if (a == null) {
            return true;
        }
        BsdAddress arg = (BsdAddress)a;
        if (this.addr >= 0L && arg.addr < 0L) {
            return false;
        }
        if (this.addr < 0L && arg.addr >= 0L) {
            return true;
        }
        return this.addr >= arg.addr;
    }

    public Address andWithMask(long mask) throws UnsupportedOperationException {
        long value = this.addr & mask;
        if (value == 0L) {
            return null;
        }
        return new BsdAddress(this.debugger, value);
    }

    public Address orWithMask(long mask) throws UnsupportedOperationException {
        long value = this.addr | mask;
        if (value == 0L) {
            return null;
        }
        return new BsdAddress(this.debugger, value);
    }

    public Address xorWithMask(long mask) throws UnsupportedOperationException {
        long value = this.addr ^ mask;
        if (value == 0L) {
            return null;
        }
        return new BsdAddress(this.debugger, value);
    }

    long getValue() {
        return this.addr;
    }

    private static void check(boolean arg, String failMessage) {
        if (!arg) {
            System.err.println(failMessage + ": FAILED");
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        BsdAddress p1 = new BsdAddress(null, 0x7FFFFFFFFFFFFFF0L);
        BsdAddress p2 = (BsdAddress)p1.addOffsetTo(10L);
        BsdAddress n1 = (BsdAddress)p2.addOffsetTo(10L);
        BsdAddress n2 = (BsdAddress)n1.addOffsetTo(10L);
        BsdAddress.check(p1.lessThan(p2), "lessThan 1");
        BsdAddress.check(p1.lessThan(n1), "lessThan 2");
        BsdAddress.check(p1.lessThan(n2), "lessThan 3");
        BsdAddress.check(p2.lessThan(n1), "lessThan 4");
        BsdAddress.check(p2.lessThan(n2), "lessThan 5");
        BsdAddress.check(n1.lessThan(n2), "lessThan 6");
        BsdAddress.check(!p1.lessThan(p1), "lessThan 7");
        BsdAddress.check(!p2.lessThan(p2), "lessThan 8");
        BsdAddress.check(!n1.lessThan(n1), "lessThan 9");
        BsdAddress.check(!n2.lessThan(n2), "lessThan 10");
        BsdAddress.check(!p2.lessThan(p1), "lessThan 11");
        BsdAddress.check(!n1.lessThan(p1), "lessThan 12");
        BsdAddress.check(!n2.lessThan(p1), "lessThan 13");
        BsdAddress.check(!n1.lessThan(p2), "lessThan 14");
        BsdAddress.check(!n2.lessThan(p2), "lessThan 15");
        BsdAddress.check(!n2.lessThan(n1), "lessThan 16");
        BsdAddress.check(p1.lessThanOrEqual(p1), "lessThanOrEqual 1");
        BsdAddress.check(p2.lessThanOrEqual(p2), "lessThanOrEqual 2");
        BsdAddress.check(n1.lessThanOrEqual(n1), "lessThanOrEqual 3");
        BsdAddress.check(n2.lessThanOrEqual(n2), "lessThanOrEqual 4");
        BsdAddress.check(p1.lessThanOrEqual(p2), "lessThanOrEqual 5");
        BsdAddress.check(p1.lessThanOrEqual(n1), "lessThanOrEqual 6");
        BsdAddress.check(p1.lessThanOrEqual(n2), "lessThanOrEqual 7");
        BsdAddress.check(p2.lessThanOrEqual(n1), "lessThanOrEqual 8");
        BsdAddress.check(p2.lessThanOrEqual(n2), "lessThanOrEqual 9");
        BsdAddress.check(n1.lessThanOrEqual(n2), "lessThanOrEqual 10");
        BsdAddress.check(!p2.lessThanOrEqual(p1), "lessThanOrEqual 11");
        BsdAddress.check(!n1.lessThanOrEqual(p1), "lessThanOrEqual 12");
        BsdAddress.check(!n2.lessThanOrEqual(p1), "lessThanOrEqual 13");
        BsdAddress.check(!n1.lessThanOrEqual(p2), "lessThanOrEqual 14");
        BsdAddress.check(!n2.lessThanOrEqual(p2), "lessThanOrEqual 15");
        BsdAddress.check(!n2.lessThanOrEqual(n1), "lessThanOrEqual 16");
        BsdAddress.check(n2.greaterThan(p1), "greaterThan 1");
        BsdAddress.check(n2.greaterThan(p2), "greaterThan 2");
        BsdAddress.check(n2.greaterThan(n1), "greaterThan 3");
        BsdAddress.check(n1.greaterThan(p1), "greaterThan 4");
        BsdAddress.check(n1.greaterThan(p2), "greaterThan 5");
        BsdAddress.check(p2.greaterThan(p1), "greaterThan 6");
        BsdAddress.check(!p1.greaterThan(p1), "greaterThan 7");
        BsdAddress.check(!p2.greaterThan(p2), "greaterThan 8");
        BsdAddress.check(!n1.greaterThan(n1), "greaterThan 9");
        BsdAddress.check(!n2.greaterThan(n2), "greaterThan 10");
        BsdAddress.check(!p1.greaterThan(n2), "greaterThan 11");
        BsdAddress.check(!p2.greaterThan(n2), "greaterThan 12");
        BsdAddress.check(!n1.greaterThan(n2), "greaterThan 13");
        BsdAddress.check(!p1.greaterThan(n1), "greaterThan 14");
        BsdAddress.check(!p2.greaterThan(n1), "greaterThan 15");
        BsdAddress.check(!p1.greaterThan(p2), "greaterThan 16");
        BsdAddress.check(p1.greaterThanOrEqual(p1), "greaterThanOrEqual 1");
        BsdAddress.check(p2.greaterThanOrEqual(p2), "greaterThanOrEqual 2");
        BsdAddress.check(n1.greaterThanOrEqual(n1), "greaterThanOrEqual 3");
        BsdAddress.check(n2.greaterThanOrEqual(n2), "greaterThanOrEqual 4");
        BsdAddress.check(n2.greaterThanOrEqual(p1), "greaterThanOrEqual 5");
        BsdAddress.check(n2.greaterThanOrEqual(p2), "greaterThanOrEqual 6");
        BsdAddress.check(n2.greaterThanOrEqual(n1), "greaterThanOrEqual 7");
        BsdAddress.check(n1.greaterThanOrEqual(p1), "greaterThanOrEqual 8");
        BsdAddress.check(n1.greaterThanOrEqual(p2), "greaterThanOrEqual 9");
        BsdAddress.check(p2.greaterThanOrEqual(p1), "greaterThanOrEqual 10");
        BsdAddress.check(!p1.greaterThanOrEqual(n2), "greaterThanOrEqual 11");
        BsdAddress.check(!p2.greaterThanOrEqual(n2), "greaterThanOrEqual 12");
        BsdAddress.check(!n1.greaterThanOrEqual(n2), "greaterThanOrEqual 13");
        BsdAddress.check(!p1.greaterThanOrEqual(n1), "greaterThanOrEqual 14");
        BsdAddress.check(!p2.greaterThanOrEqual(n1), "greaterThanOrEqual 15");
        BsdAddress.check(!p1.greaterThanOrEqual(p2), "greaterThanOrEqual 16");
        System.err.println("BsdAddress: all tests passed successfully.");
    }
}

