/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.BlockSym;
import sun.jvm.hotspot.debugger.cdbg.LocalSym;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCDebugInfoDataBase;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicLocalSym;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicSym;
import sun.jvm.hotspot.debugger.cdbg.basic.ResolveListener;

public class BasicBlockSym
extends BasicSym
implements BlockSym {
    private BlockSym parent;
    private long length;
    private Address addr;
    private List locals;

    public BasicBlockSym(BlockSym parent, long length, Address addr, String name) {
        super(name);
        this.parent = parent;
        this.length = length;
        this.addr = addr;
    }

    public BlockSym asBlock() {
        return this;
    }

    public BlockSym getParent() {
        return this.parent;
    }

    public long getLength() {
        return this.length;
    }

    public Address getAddress() {
        return this.addr;
    }

    public int getNumLocals() {
        if (this.locals == null) {
            return 0;
        }
        return this.locals.size();
    }

    public LocalSym getLocal(int i) {
        return (LocalSym)this.locals.get(i);
    }

    public void addLocal(LocalSym local) {
        if (this.locals == null) {
            this.locals = new ArrayList();
        }
        this.locals.add(local);
    }

    public void resolve(BasicCDebugInfoDataBase db, ResolveListener listener) {
        this.parent = (BlockSym)db.resolveSym(this, this.parent, listener, "resolving parent of block");
        if (this.locals != null) {
            Iterator iter = this.locals.iterator();
            while (iter.hasNext()) {
                ((BasicLocalSym)iter.next()).resolve(db, listener);
            }
        }
    }
}

