/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.BlockSym;
import sun.jvm.hotspot.debugger.cdbg.FunctionSym;
import sun.jvm.hotspot.debugger.cdbg.FunctionType;
import sun.jvm.hotspot.debugger.cdbg.Type;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicBlockSym;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCDebugInfoDataBase;
import sun.jvm.hotspot.debugger.cdbg.basic.ResolveListener;

public class BasicFunctionSym
extends BasicBlockSym
implements FunctionSym {
    private Type type;
    private boolean isModuleLocal;

    public BasicFunctionSym(BlockSym parent, long length, Address addr, String name, Type type, boolean isModuleLocal) {
        super(parent, length, addr, name);
        this.type = type;
        this.isModuleLocal = isModuleLocal;
    }

    public FunctionSym asFunction() {
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isModuleLocal() {
        return this.isModuleLocal;
    }

    public void resolve(BasicCDebugInfoDataBase db, ResolveListener listener) {
        super.resolve(db, listener);
        this.type = db.resolveType(this, this.type, listener, "resolving type of function symbol");
    }

    public String toString() {
        if (this.getName() == null) {
            return null;
        }
        StringBuffer res = new StringBuffer();
        res.append(this.getName());
        res.append("(");
        FunctionType type = (FunctionType)this.getType();
        if (type != null) {
            int nargs = type.getNumArguments();
            for (int i = 0; i < nargs; ++i) {
                res.append(((Object)type.getArgumentType(i)).toString());
                if (i == nargs - 1) continue;
                res.append(", ");
            }
        }
        res.append(")");
        return res.toString();
    }
}

