/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.linux.x86;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.ClosestSymbol;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCFrame;
import sun.jvm.hotspot.debugger.linux.LinuxDebugger;

public final class LinuxX86CFrame
extends BasicCFrame {
    private static final int ADDRESS_SIZE = 4;
    private Address pc;
    private Address ebp;
    private LinuxDebugger dbg;

    public LinuxX86CFrame(LinuxDebugger dbg, Address ebp, Address pc) {
        super(dbg.getCDebugger());
        this.ebp = ebp;
        this.pc = pc;
        this.dbg = dbg;
    }

    public ClosestSymbol closestSymbolToPC() {
        return this.dbg.lookup(this.dbg.getAddressValue(this.pc()));
    }

    public Address pc() {
        return this.pc;
    }

    public Address localVariableBase() {
        return this.ebp;
    }

    public CFrame sender() {
        if (this.ebp == null) {
            return null;
        }
        Address nextEBP = this.ebp.getAddressAt(0L);
        if (nextEBP == null) {
            return null;
        }
        Address nextPC = this.ebp.getAddressAt(4L);
        if (nextPC == null) {
            return null;
        }
        return new LinuxX86CFrame(this.dbg, nextEBP, nextPC);
    }
}

