/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.win32;

import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.cdbg.AccessControl;
import sun.jvm.hotspot.debugger.cdbg.BlockSym;
import sun.jvm.hotspot.debugger.cdbg.CDebugInfoDataBase;
import sun.jvm.hotspot.debugger.cdbg.CVAttributes;
import sun.jvm.hotspot.debugger.cdbg.GlobalSym;
import sun.jvm.hotspot.debugger.cdbg.LocalSym;
import sun.jvm.hotspot.debugger.cdbg.Sym;
import sun.jvm.hotspot.debugger.cdbg.Type;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicArrayType;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicBaseClass;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicBitType;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicBlockSym;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCDebugInfoDataBase;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCompoundType;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicDoubleType;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicEnumType;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicField;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicFloatType;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicFunctionSym;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicFunctionType;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicGlobalSym;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicIntType;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicLineNumberInfo;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicLocalSym;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicMemberFunctionType;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicPointerType;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicType;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicVoidType;
import sun.jvm.hotspot.debugger.cdbg.basic.CompoundTypeKind;
import sun.jvm.hotspot.debugger.cdbg.basic.LazyBlockSym;
import sun.jvm.hotspot.debugger.cdbg.basic.LazyType;
import sun.jvm.hotspot.debugger.cdbg.basic.ResolveListener;
import sun.jvm.hotspot.debugger.win32.Win32Debugger;
import sun.jvm.hotspot.debugger.win32.coff.COFFFile;
import sun.jvm.hotspot.debugger.win32.coff.COFFFileParser;
import sun.jvm.hotspot.debugger.win32.coff.COFFHeader;
import sun.jvm.hotspot.debugger.win32.coff.DebugDirectory;
import sun.jvm.hotspot.debugger.win32.coff.DebugDirectoryEntry;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50MemberAttributes;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSAlignSym;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSGlobalSym;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSGlobalTypes;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSSegMap;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSSrcModule;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSSymbolBase;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SrcModFileDesc;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SrcModLineNumberMap;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50Subsection;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SubsectionDirectory;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SubsectionTypes;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SymbolIterator;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SymbolTypes;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50TypeEnums;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50TypeIterator;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50TypeLeafIndices;
import sun.jvm.hotspot.debugger.win32.coff.OptionalHeader;
import sun.jvm.hotspot.debugger.win32.coff.OptionalHeaderDataDirectories;
import sun.jvm.hotspot.debugger.win32.coff.SectionHeader;
import sun.jvm.hotspot.utilities.Assert;

class Win32CDebugInfoBuilder
implements DebugVC50SubsectionTypes,
DebugVC50TypeLeafIndices,
DebugVC50TypeEnums,
DebugVC50SymbolTypes,
DebugVC50MemberAttributes,
CVAttributes,
AccessControl {
    private Win32Debugger dbg;
    private Address base;
    private DebugVC50 vc50;
    private BasicCDebugInfoDataBase db;
    private DebugVC50TypeIterator iter;
    private DebugVC50SymbolIterator symIter;
    private COFFFile file;
    private DebugVC50SSSegMap segMap;
    private Map primIndexToTypeMap;
    private BasicEnumType unnamedEnum;
    private Stack blockStack;
    private int endsToSkip;
    private static final int POINTER_SIZE = 4;

    Win32CDebugInfoBuilder(Win32Debugger dbg) {
        this.dbg = dbg;
    }

    CDebugInfoDataBase buildDataBase(String dllName, Address base) {
        int i;
        this.base = base;
        this.file = COFFFileParser.getParser().parse(dllName);
        this.vc50 = Win32CDebugInfoBuilder.getDebugVC50(this.file);
        if (this.vc50 == null) {
            return null;
        }
        this.segMap = this.getSegMap();
        this.primIndexToTypeMap = new HashMap();
        this.blockStack = new Stack();
        this.endsToSkip = 0;
        this.db = new BasicCDebugInfoDataBase();
        this.db.beginConstruction();
        DebugVC50SSGlobalTypes types = this.getGlobalTypes();
        this.iter = types.getTypeIterator();
        while (!this.iter.done()) {
            while (!this.iter.typeStringDone()) {
                switch (this.iter.typeStringLeaf()) {
                    case 4097: {
                        int idx = this.iter.getModifierIndex();
                        BasicType target = this.getTypeByIndex(idx);
                        short windowsMods = this.iter.getModifierAttribute();
                        short mods = 0;
                        if ((windowsMods & 1) != 0) {
                            mods = (short)(mods | 1);
                        }
                        if ((windowsMods & 2) != 0) {
                            mods = (short)(mods | 2);
                        }
                        this.putType(target.getCVVariant(mods));
                        break;
                    }
                    case 4098: {
                        int idx = this.iter.getPointerType();
                        BasicType target = this.getTypeByIndex(idx);
                        short windowsMods = this.iter.getModifierAttribute();
                        short mods = 0;
                        if ((windowsMods & 0x400) != 0) {
                            mods = (short)(mods | 1);
                        }
                        if ((windowsMods & 0x200) != 0) {
                            mods = (short)(mods | 2);
                        }
                        BasicPointerType ptrType = new BasicPointerType(4, target);
                        if (mods != 0) {
                            ptrType = (BasicPointerType)ptrType.getCVVariant(mods);
                        }
                        this.putType(ptrType);
                        break;
                    }
                    case 4099: {
                        BasicType elemType = this.getTypeByIndex(this.iter.getArrayElementType());
                        this.putType(new BasicArrayType(this.iter.getArrayName(), elemType, this.iter.getArrayLength()));
                        break;
                    }
                    case 4100: 
                    case 4101: {
                        CompoundTypeKind kind = this.iter.typeStringLeaf() == 4100 ? CompoundTypeKind.CLASS : CompoundTypeKind.STRUCT;
                        BasicCompoundType type = new BasicCompoundType(this.iter.getClassName(), this.iter.getClassSize(), kind);
                        if ((this.iter.getClassProperty() & 0x80) == 0) {
                            DebugVC50TypeIterator fieldIter = this.iter.getClassFieldListIterator();
                            if (Assert.ASSERTS_ENABLED) {
                                Assert.that(fieldIter.typeStringLeaf() == 4611, "Expected field list");
                            }
                            boolean advance = false;
                            while (!fieldIter.typeStringDone()) {
                                advance = true;
                                switch (fieldIter.typeStringLeaf()) {
                                    case 4611: {
                                        break;
                                    }
                                    case 5120: {
                                        int accessControl = this.memberAttributeToAccessControl(fieldIter.getBClassAttribute());
                                        BasicType baseType = this.getTypeByIndex(fieldIter.getBClassType());
                                        type.addBaseClass(new BasicBaseClass(accessControl, false, baseType));
                                        break;
                                    }
                                    case 5121: {
                                        int accessControl = this.memberAttributeToAccessControl(fieldIter.getVBClassAttribute());
                                        BasicType baseType = this.getTypeByIndex(fieldIter.getVBClassBaseClassType());
                                        type.addBaseClass(new BasicBaseClass(accessControl, true, baseType));
                                        break;
                                    }
                                    case 5122: {
                                        break;
                                    }
                                    case 5124: {
                                        fieldIter = fieldIter.getIndexIterator();
                                        advance = false;
                                        break;
                                    }
                                    case 5125: {
                                        BasicField field = new BasicField(fieldIter.getMemberName(), this.getTypeByIndex(fieldIter.getMemberType()), this.memberAttributeToAccessControl(fieldIter.getMemberAttribute()), false);
                                        field.setOffset(fieldIter.getMemberOffset());
                                        type.addField(field);
                                        break;
                                    }
                                    case 5126: {
                                        BasicField field = new BasicField(fieldIter.getStaticName(), this.getTypeByIndex(fieldIter.getStaticType()), this.memberAttributeToAccessControl(fieldIter.getStaticAttribute()), true);
                                        type.addField(field);
                                        break;
                                    }
                                    case 5127: {
                                        break;
                                    }
                                    case 5131: {
                                        break;
                                    }
                                    case 5128: {
                                        break;
                                    }
                                    case 5133: {
                                        break;
                                    }
                                    case 5129: {
                                        break;
                                    }
                                    case 5130: {
                                        break;
                                    }
                                    case 5132: {
                                        break;
                                    }
                                    case 5134: {
                                        break;
                                    }
                                    case 240: 
                                    case 241: 
                                    case 242: 
                                    case 243: 
                                    case 244: 
                                    case 245: 
                                    case 246: 
                                    case 247: 
                                    case 248: 
                                    case 249: 
                                    case 250: 
                                    case 251: 
                                    case 252: 
                                    case 253: 
                                    case 254: 
                                    case 255: {
                                        break;
                                    }
                                    default: {
                                        System.err.println("WARNING: unexpected leaf index " + fieldIter.typeStringLeaf() + " in field list for type " + this.iter.getTypeIndex());
                                    }
                                }
                                if (!advance) continue;
                                fieldIter.typeStringNext();
                            }
                        }
                        this.putType(type);
                        break;
                    }
                    case 4102: {
                        BasicCompoundType type = new BasicCompoundType(this.iter.getUnionName(), this.iter.getUnionSize(), CompoundTypeKind.UNION);
                        if ((this.iter.getClassProperty() & 0x80) == 0) {
                            DebugVC50TypeIterator fieldIter = this.iter.getUnionFieldListIterator();
                            if (Assert.ASSERTS_ENABLED) {
                                Assert.that(fieldIter.typeStringLeaf() == 4611, "Expected field list");
                            }
                            boolean advance = false;
                            while (!fieldIter.typeStringDone()) {
                                advance = true;
                                switch (fieldIter.typeStringLeaf()) {
                                    case 4611: {
                                        break;
                                    }
                                    case 5120: {
                                        break;
                                    }
                                    case 5121: {
                                        break;
                                    }
                                    case 5122: {
                                        break;
                                    }
                                    case 5124: {
                                        fieldIter = fieldIter.getIndexIterator();
                                        advance = false;
                                        break;
                                    }
                                    case 5125: {
                                        BasicField field = new BasicField(fieldIter.getMemberName(), this.getTypeByIndex(fieldIter.getMemberType()), this.memberAttributeToAccessControl(fieldIter.getMemberAttribute()), false);
                                        field.setOffset(fieldIter.getMemberOffset());
                                        type.addField(field);
                                        break;
                                    }
                                    case 5126: {
                                        System.err.println("WARNING: I didn't think unions could contain static fields...");
                                        BasicField field = new BasicField(fieldIter.getStaticName(), this.getTypeByIndex(fieldIter.getStaticType()), this.memberAttributeToAccessControl(fieldIter.getStaticAttribute()), true);
                                        type.addField(field);
                                        break;
                                    }
                                    case 5127: {
                                        break;
                                    }
                                    case 5131: {
                                        break;
                                    }
                                    case 5128: {
                                        break;
                                    }
                                    case 5133: {
                                        break;
                                    }
                                    case 5129: {
                                        break;
                                    }
                                    case 5130: {
                                        break;
                                    }
                                    case 5132: {
                                        break;
                                    }
                                    case 5134: {
                                        break;
                                    }
                                    case 240: 
                                    case 241: 
                                    case 242: 
                                    case 243: 
                                    case 244: 
                                    case 245: 
                                    case 246: 
                                    case 247: 
                                    case 248: 
                                    case 249: 
                                    case 250: 
                                    case 251: 
                                    case 252: 
                                    case 253: 
                                    case 254: 
                                    case 255: {
                                        break;
                                    }
                                    default: {
                                        System.err.println("WARNING: unexpected leaf index " + fieldIter.typeStringLeaf() + " in field list for union of type " + this.iter.getTypeIndex());
                                    }
                                }
                                if (!advance) continue;
                                fieldIter.typeStringNext();
                            }
                        }
                        this.putType(type);
                        break;
                    }
                    case 4103: {
                        String name = this.iter.getEnumName();
                        BasicEnumType enumType = null;
                        if (name == null || name.equals("")) {
                            if (this.unnamedEnum == null) {
                                this.unnamedEnum = new BasicEnumType(null, this.getTypeByIndex(this.iter.getEnumType()));
                            }
                            enumType = this.unnamedEnum;
                        } else {
                            enumType = new BasicEnumType(name, this.getTypeByIndex(this.iter.getEnumType()));
                        }
                        DebugVC50TypeIterator fieldIter = this.iter.getEnumFieldListIterator();
                        if (Assert.ASSERTS_ENABLED) {
                            Assert.that(fieldIter.typeStringLeaf() == 4611, "Expected field list");
                        }
                        boolean advance = false;
                        while (!fieldIter.typeStringDone()) {
                            advance = true;
                            switch (fieldIter.typeStringLeaf()) {
                                case 4611: {
                                    break;
                                }
                                case 1027: {
                                    String enumName = fieldIter.getEnumerateName();
                                    long enumVal = fieldIter.getEnumerateValue();
                                    enumType.addEnum(enumName, enumVal);
                                    break;
                                }
                                case 5124: {
                                    fieldIter = fieldIter.getIndexIterator();
                                    advance = false;
                                    break;
                                }
                                case 240: 
                                case 241: 
                                case 242: 
                                case 243: 
                                case 244: 
                                case 245: 
                                case 246: 
                                case 247: 
                                case 248: 
                                case 249: 
                                case 250: 
                                case 251: 
                                case 252: 
                                case 253: 
                                case 254: 
                                case 255: {
                                    break;
                                }
                                default: {
                                    System.err.println("WARNING: unexpected leaf index " + fieldIter.typeStringLeaf() + " in field list for enum of type " + this.iter.getTypeIndex());
                                }
                            }
                            if (!advance) continue;
                            fieldIter.typeStringNext();
                        }
                        this.putType(enumType);
                        break;
                    }
                    case 4104: {
                        BasicType retType = this.getTypeByIndex(this.iter.getProcedureReturnType());
                        BasicFunctionType func = new BasicFunctionType(null, 4, retType);
                        DebugVC50TypeIterator argIter = this.iter.getProcedureArgumentListIterator();
                        if (Assert.ASSERTS_ENABLED) {
                            Assert.that(argIter.typeStringLeaf() == 4609, "Expected argument list");
                        }
                        for (int i2 = 0; i2 < argIter.getArgListCount(); ++i2) {
                            func.addArgumentType(this.getTypeByIndex(argIter.getArgListType(i2)));
                        }
                        this.putType(func);
                        break;
                    }
                    case 4105: {
                        BasicType retType = this.getTypeByIndex(this.iter.getMFunctionReturnType());
                        BasicType container = this.getTypeByIndex(this.iter.getMFunctionContainingClass());
                        BasicType thisType = this.getTypeByIndex(this.iter.getMFunctionThis());
                        long thisAdjust = this.iter.getMFunctionThisAdjust();
                        BasicMemberFunctionType func = new BasicMemberFunctionType(null, 4, retType, container, thisType, thisAdjust);
                        DebugVC50TypeIterator argIter = this.iter.getMFunctionArgumentListIterator();
                        for (int i3 = 0; i3 < argIter.getArgListCount(); ++i3) {
                            func.addArgumentType(this.getTypeByIndex(argIter.getArgListType(i3)));
                        }
                        this.putType(func);
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 4107: {
                        System.err.println("FIXME: don't know what to do with LF_BARRAY leaves (convert to pointers?");
                        break;
                    }
                    case 14: {
                        break;
                    }
                    case 15: {
                        break;
                    }
                    case 4108: {
                        System.err.println("FIXME: don't know what to do with LF_DIMARRAY leaves yet");
                        break;
                    }
                    case 4109: {
                        break;
                    }
                    case 4110: {
                        break;
                    }
                    case 20: {
                        break;
                    }
                    case 4111: {
                        break;
                    }
                    case 22: {
                        break;
                    }
                    case 4608: {
                        break;
                    }
                    case 4609: {
                        this.skipTypeRecord();
                        break;
                    }
                    case 4610: {
                        System.err.println("FIXME: handle default arguments (dereference the type)");
                        break;
                    }
                    case 4611: {
                        this.skipTypeRecord();
                        break;
                    }
                    case 4612: {
                        break;
                    }
                    case 4613: {
                        BasicType underlyingType = this.getTypeByIndex(this.iter.getBitfieldFieldType());
                        BasicBitType bit = new BasicBitType(underlyingType, this.iter.getBitfieldLength() & 0xFF, this.iter.getBitfieldPosition() & 0xFF);
                        this.putType(bit);
                        break;
                    }
                    case 4614: {
                        break;
                    }
                    case 4615: 
                    case 4616: 
                    case 4617: 
                    case 4618: {
                        break;
                    }
                    case 524: {
                        break;
                    }
                    case 240: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 250: 
                    case 251: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: {
                        break;
                    }
                    default: {
                        System.err.println("Unexpected leaf index " + this.iter.typeStringLeaf() + " at offset 0x" + Integer.toHexString(this.iter.typeStringOffset()));
                    }
                }
                if (this.iter.typeStringDone()) continue;
                this.iter.typeStringNext();
            }
            this.iter.next();
        }
        DebugVC50SubsectionDirectory dir = this.vc50.getSubsectionDirectory();
        boolean moduleNumber = false;
        for (i = 0; i < dir.getNumEntries(); ++i) {
            DebugVC50Subsection syms;
            DebugVC50Subsection ss = dir.getSubsection(i);
            short ssType = ss.getSubsectionType();
            boolean process = false;
            if (ssType == 297 || ssType == 298 || ssType == 308) {
                syms = (DebugVC50SSSymbolBase)ss;
                this.symIter = syms.getSymbolIterator();
                process = true;
            }
            if (ssType == 293) {
                syms = (DebugVC50SSAlignSym)ss;
                this.symIter = syms.getSymbolIterator();
                process = true;
            }
            if (!process) continue;
            while (!this.symIter.done()) {
                switch (this.symIter.getType()) {
                    case 1: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        try {
                            if (this.endsToSkip == 0) {
                                this.blockStack.pop();
                                break;
                            }
                            --this.endsToSkip;
                        }
                        catch (EmptyStackException e) {
                            System.err.println("WARNING: mismatched block begins/ends in debug information");
                        }
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 12: {
                        break;
                    }
                    case 13: {
                        break;
                    }
                    case 14: {
                        break;
                    }
                    case 4097: {
                        break;
                    }
                    case 4098: {
                        break;
                    }
                    case 4099: {
                        break;
                    }
                    case 4100: {
                        break;
                    }
                    case 4101: {
                        break;
                    }
                    case 4102: {
                        BasicLocalSym sym = new BasicLocalSym(this.symIter.getBPRelName(), this.getTypeByIndex(this.symIter.getBPRelType()), this.symIter.getBPRelOffset());
                        this.addLocalToCurBlock(sym);
                        break;
                    }
                    case 4103: 
                    case 4104: {
                        boolean isModuleLocal = this.symIter.getType() == 4103;
                        BasicGlobalSym sym = new BasicGlobalSym(this.symIter.getLGDataName(), this.getTypeByIndex(this.symIter.getLGDataType()), this.newAddress(this.symIter.getLGDataOffset(), this.symIter.getLGDataSegment()), isModuleLocal);
                        this.addGlobalSym(sym);
                        break;
                    }
                    case 4105: {
                        break;
                    }
                    case 4106: 
                    case 4107: {
                        BasicFunctionSym sym = new BasicFunctionSym(this.newLazyBlockSym(this.symIter.getLGProcParentOffset()), this.symIter.getLGProcLength(), this.newAddress(this.symIter.getLGProcOffset(), this.symIter.getLGProcSegment()), this.symIter.getLGProcName(), this.getTypeByIndex(this.symIter.getLGProcType()), this.symIter.getType() == 4106);
                        this.addBlock(sym);
                        break;
                    }
                    case 518: {
                        this.skipEnd();
                        break;
                    }
                    case 519: {
                        BasicBlockSym sym = new BasicBlockSym(this.newLazyBlockSym(this.symIter.getBlockParentOffset()), this.symIter.getBlockLength(), this.newAddress(this.symIter.getBlockOffset(), this.symIter.getBlockSegment()), this.symIter.getBlockName());
                        this.addBlock(sym);
                        break;
                    }
                    case 520: {
                        break;
                    }
                    case 521: {
                        break;
                    }
                    case 522: {
                        break;
                    }
                    case 4108: {
                        break;
                    }
                    case 4109: {
                        break;
                    }
                    case 4110: {
                        break;
                    }
                    case 4111: {
                        break;
                    }
                    case 1024: {
                        break;
                    }
                    case 1025: {
                        break;
                    }
                    case 1026: {
                        break;
                    }
                    default: {
                        if (this.symIter.getType() == 0 || this.symIter.getType() == 4115) break;
                        System.err.println("  NOTE: Unexpected symbol of type " + this.symIter.getType() + " at offset 0x" + Integer.toHexString(this.symIter.getOffset()));
                    }
                }
                this.symIter.next();
            }
        }
        for (i = 0; i < dir.getNumEntries(); ++i) {
            DebugVC50Subsection ss = dir.getSubsection(i);
            if (ss.getSubsectionType() != 295) continue;
            DebugVC50SSSrcModule srcMod = (DebugVC50SSSrcModule)ss;
            for (int sf = 0; sf < srcMod.getNumSourceFiles(); ++sf) {
                DebugVC50SrcModFileDesc desc = srcMod.getSourceFileDesc(sf);
                String name = desc.getSourceFileName().intern();
                for (int cs = 0; cs < desc.getNumCodeSegments(); ++cs) {
                    DebugVC50SrcModLineNumberMap map = desc.getLineNumberMap(cs);
                    SectionHeader seg = this.file.getHeader().getSectionHeader(map.getSegment());
                    for (int lp = 0; lp < map.getNumSourceLinePairs(); ++lp) {
                        Address startPC = base.addOffsetTo(seg.getVirtualAddress() + map.getCodeOffset(lp));
                        Address endPC = base.addOffsetTo(seg.getSize());
                        this.db.addLineNumberInfo(new BasicLineNumberInfo(name, map.getLineNumber(lp), startPC, endPC));
                    }
                }
            }
        }
        this.db.resolve(new ResolveListener(){

            public void resolveFailed(Type containingType, LazyType failedResolve, String detail) {
                System.err.println("WARNING: failed to resolve type of index " + (Integer)failedResolve.getKey() + " in type " + containingType.getName() + " (class " + containingType.getClass().getName() + ") while " + detail);
            }

            public void resolveFailed(Type containingType, String staticFieldName) {
                System.err.println("WARNING: failed to resolve address of static field \"" + staticFieldName + "\" in type " + containingType.getName());
            }

            public void resolveFailed(Sym containingSymbol, LazyType failedResolve, String detail) {
                System.err.println("WARNING: failed to resolve type of index " + (Integer)failedResolve.getKey() + " in symbol of type " + containingSymbol.getClass().getName() + " while " + detail);
            }

            public void resolveFailed(Sym containingSymbol, LazyBlockSym failedResolve, String detail) {
                System.err.println("WARNING: failed to resolve block at offset 0x" + Integer.toHexString((Integer)failedResolve.getKey()) + " in symbol of type " + containingSymbol.getClass().getName() + " while " + detail);
            }
        });
        this.db.endConstruction();
        return this.db;
    }

    private static DebugVC50 getDebugVC50(COFFFile file) {
        COFFHeader header = file.getHeader();
        OptionalHeader opt = header.getOptionalHeader();
        if (opt == null) {
            return null;
        }
        OptionalHeaderDataDirectories dd = opt.getDataDirectories();
        if (dd == null) {
            return null;
        }
        DebugDirectory debug = dd.getDebugDirectory();
        if (debug == null) {
            return null;
        }
        for (int i = 0; i < debug.getNumEntries(); ++i) {
            DebugDirectoryEntry entry = debug.getEntry(i);
            if (entry.getType() != 2) continue;
            return entry.getDebugVC50();
        }
        return null;
    }

    private DebugVC50SSSegMap getSegMap() {
        return (DebugVC50SSSegMap)this.findSubsection((short)301);
    }

    private DebugVC50SSGlobalTypes getGlobalTypes() {
        return (DebugVC50SSGlobalTypes)this.findSubsection((short)299);
    }

    private DebugVC50SSGlobalSym getGlobalSymbols() {
        return (DebugVC50SSGlobalSym)this.findSubsection((short)297);
    }

    private DebugVC50Subsection findSubsection(short ssType) {
        DebugVC50SubsectionDirectory dir = this.vc50.getSubsectionDirectory();
        for (int i = 0; i < dir.getNumEntries(); ++i) {
            DebugVC50Subsection ss = dir.getSubsection(i);
            if (ss.getSubsectionType() != ssType) continue;
            return ss;
        }
        throw new DebuggerException("Unable to find subsection of type " + ssType);
    }

    private void putType(Type t) {
        this.db.addType(new Integer(this.iter.getTypeIndex()), t);
    }

    private Address newAddress(int offset, short segment) {
        int seg = segment & 0xFFFF;
        SectionHeader section = this.file.getHeader().getSectionHeader(seg);
        return this.base.addOffsetTo(section.getVirtualAddress() + offset);
    }

    private BasicType getTypeByIndex(int intIndex) {
        Integer index = new Integer(intIndex);
        if (intIndex <= 4095) {
            BasicType type = (BasicType)this.primIndexToTypeMap.get(index);
            if (type != null) {
                return type;
            }
            int primMode = intIndex & 0x700;
            if (primMode == 0) {
                int primType = intIndex & 0x70;
                block0 : switch (primType) {
                    case 16: 
                    case 32: {
                        boolean unsigned = primType == 32;
                        int size = 0;
                        String name = null;
                        switch (intIndex & 7) {
                            case 0: {
                                size = 1;
                                name = "char";
                                break;
                            }
                            case 1: {
                                size = 2;
                                name = "short";
                                break;
                            }
                            case 2: {
                                size = 4;
                                name = "int";
                                break;
                            }
                            case 3: {
                                size = 8;
                                name = "__int64";
                                break;
                            }
                            default: {
                                throw new DebuggerException("Illegal size of integer type " + intIndex);
                            }
                        }
                        type = new BasicIntType(name, size, unsigned);
                        break;
                    }
                    case 48: {
                        int size = 0;
                        switch (intIndex & 7) {
                            case 0: {
                                size = 1;
                                break;
                            }
                            case 1: {
                                size = 2;
                                break;
                            }
                            case 2: {
                                size = 4;
                                break;
                            }
                            case 3: {
                                size = 8;
                                break;
                            }
                            default: {
                                throw new DebuggerException("Illegal size of boolean type " + intIndex);
                            }
                        }
                        type = new BasicIntType("bool", size, false);
                        break;
                    }
                    case 64: {
                        switch (intIndex & 7) {
                            case 0: {
                                type = new BasicFloatType("float", 4);
                                break block0;
                            }
                            case 1: {
                                type = new BasicDoubleType("double", 8);
                                break block0;
                            }
                        }
                        throw new DebuggerException("Unsupported floating-point size in type " + intIndex);
                    }
                    case 112: {
                        switch (intIndex & 7) {
                            case 0: {
                                type = new BasicIntType("char", 1, false);
                                break block0;
                            }
                            case 1: {
                                type = new BasicIntType("wchar", 2, false);
                                break block0;
                            }
                            case 2: {
                                type = new BasicIntType("short", 2, false);
                                break block0;
                            }
                            case 3: {
                                type = new BasicIntType("short", 2, true);
                                break block0;
                            }
                            case 4: {
                                type = new BasicIntType("int", 4, false);
                                break block0;
                            }
                            case 5: {
                                type = new BasicIntType("int", 4, true);
                                break block0;
                            }
                            case 6: {
                                type = new BasicIntType("__int64", 8, false);
                                break block0;
                            }
                            case 7: {
                                type = new BasicIntType("__int64", 8, true);
                                break block0;
                            }
                        }
                        throw new DebuggerException("Illegal REALLY_INT size in type " + intIndex);
                    }
                    case 0: {
                        switch (intIndex & 7) {
                            case 0: 
                            case 3: {
                                type = new BasicVoidType();
                                break block0;
                            }
                        }
                        throw new DebuggerException("Don't know how to handle reserved special type " + intIndex);
                    }
                    default: {
                        throw new DebuggerException("Don't know how to handle reserved type " + intIndex);
                    }
                }
            } else {
                BasicType targetType = this.getTypeByIndex(intIndex & 0xFFFFF8FF);
                type = new BasicPointerType(4, targetType);
            }
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(type != null, "Got null Type for primitive type " + intIndex);
            }
            this.primIndexToTypeMap.put(index, type);
            return type;
        }
        return new LazyType(index);
    }

    private void addBlock(BlockSym block) {
        this.db.addBlock(new Integer(this.symIter.getOffset()), block);
        this.blockStack.push(block);
    }

    private void skipEnd() {
        ++this.endsToSkip;
    }

    private BlockSym newLazyBlockSym(int offset) {
        if (offset == 0) {
            return null;
        }
        return new LazyBlockSym(new Integer(offset));
    }

    private int memberAttributeToAccessControl(short memberAttribute) {
        int acc = memberAttribute & 3;
        switch (acc) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        throw new RuntimeException("Should not reach here");
    }

    private void addLocalToCurBlock(LocalSym local) {
        ((BasicBlockSym)this.blockStack.peek()).addLocal(local);
    }

    private void addGlobalSym(GlobalSym sym) {
        this.db.addGlobalSym(sym);
    }

    private void skipTypeRecord() {
        while (!this.iter.typeStringDone()) {
            this.iter.typeStringNext();
        }
    }
}

