/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.windbg.ia64;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.windbg.WindbgDebugger;
import sun.jvm.hotspot.debugger.windbg.ia64.WindbgIA64ThreadContext;

class WindbgIA64Thread
implements ThreadProxy {
    private WindbgDebugger debugger;
    private long sysId;
    private boolean gotID;
    private long id;

    WindbgIA64Thread(WindbgDebugger debugger, Address addr) {
        this.debugger = debugger;
        this.sysId = (int)addr.addOffsetTo(debugger.getAddressSize()).getCIntegerAt(0L, 4L, true);
        this.gotID = false;
    }

    WindbgIA64Thread(WindbgDebugger debugger, long sysId) {
        this.debugger = debugger;
        this.sysId = sysId;
        this.gotID = false;
    }

    public ThreadContext getContext() throws IllegalThreadStateException {
        long[] data = this.debugger.getThreadIntegerRegisterSet(this.getThreadID());
        WindbgIA64ThreadContext context = new WindbgIA64ThreadContext(this.debugger);
        for (int i = 0; i < data.length; ++i) {
            context.setRegister(i, data[i]);
        }
        return context;
    }

    public boolean canSetContext() throws DebuggerException {
        return false;
    }

    public void setContext(ThreadContext thrCtx) throws IllegalThreadStateException, DebuggerException {
        throw new DebuggerException("Unimplemented");
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof WindbgIA64Thread)) {
            return false;
        }
        return ((WindbgIA64Thread)obj).getThreadID() == this.getThreadID();
    }

    public int hashCode() {
        return (int)this.getThreadID();
    }

    public String toString() {
        return Long.toString(this.getThreadID());
    }

    private long getThreadID() {
        if (!this.gotID) {
            this.id = this.debugger.getThreadIdFromSysId(this.sysId);
        }
        return this.id;
    }
}

