/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.Transport;
import com.sun.tools.jdi.VirtualMachineManagerService;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import sun.jvm.hotspot.jdi.ConnectorImpl;

public class SADebugServerAttachingConnector
extends ConnectorImpl
implements AttachingConnector {
    static final String ARG_DEBUG_SERVER_NAME = "debugServerName";
    private Transport transport;

    public SADebugServerAttachingConnector(VirtualMachineManagerService ignored) {
        this();
    }

    public SADebugServerAttachingConnector() {
        this.addStringArgument(ARG_DEBUG_SERVER_NAME, "Debug Server", "Name of a remote SA Debug Server", "", true);
        this.transport = new Transport(){

            public String name() {
                return "RMI";
            }
        };
    }

    private VirtualMachine createVirtualMachine(Class vmImplClass, String debugServerName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method connectByServerMethod = vmImplClass.getMethod("createVirtualMachineForServer", VirtualMachineManager.class, String.class, Integer.TYPE);
        return (VirtualMachine)connectByServerMethod.invoke(null, Bootstrap.virtualMachineManager(), debugServerName, new Integer(0));
    }

    public VirtualMachine attach(Map arguments) throws IOException, IllegalConnectorArgumentsException {
        VirtualMachine myVM;
        String debugServerName = this.argument(ARG_DEBUG_SERVER_NAME, arguments).value();
        if (debugServerName == null || debugServerName.equals("")) {
            throw new IllegalConnectorArgumentsException("debugServerName should be non-null and non-empty", ARG_DEBUG_SERVER_NAME);
        }
        try {
            try {
                Class vmImplClass = SADebugServerAttachingConnector.loadVirtualMachineImplClass();
                myVM = this.createVirtualMachine(vmImplClass, debugServerName);
            }
            catch (InvocationTargetException ite) {
                Class vmImplClass = SADebugServerAttachingConnector.handleVMVersionMismatch(ite);
                if (vmImplClass != null) {
                    return this.createVirtualMachine(vmImplClass, debugServerName);
                }
                throw ite;
            }
        }
        catch (Exception ee) {
            if (DEBUG) {
                System.out.println("VirtualMachineImpl() got an exception:");
                ee.printStackTrace();
                System.out.println("debug server name = " + debugServerName);
            }
            throw (IOException)new IOException().initCause(ee);
        }
        SADebugServerAttachingConnector.setVMDisposeObserver(myVM);
        return myVM;
    }

    public String name() {
        return "sun.jvm.hotspot.jdi.SADebugServerAttachingConnector";
    }

    public String description() {
        return this.getString("This connector allows you to attach to a Java Process via a debug server with the Serviceability Agent");
    }

    public Transport transport() {
        return this.transport;
    }
}

