/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.ObjectMonitor;
import sun.jvm.hotspot.runtime.ObjectSynchronizer;
import sun.jvm.hotspot.runtime.Threads;
import sun.jvm.hotspot.runtime.VM;

public class MonitorCacheDumpPanel
extends JPanel {
    private static Threads threads = VM.getVM().getThreads();
    private static ObjectHeap heap = VM.getVM().getObjectHeap();

    public MonitorCacheDumpPanel() {
        this.setLayout(new BorderLayout());
        JScrollPane scroller = new JScrollPane();
        JTextArea textArea = new JTextArea();
        textArea = new JTextArea();
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        scroller.getViewport().add(textArea);
        this.add((Component)scroller, "Center");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream tty = new PrintStream(bos);
        tty.println("Monitor Cache Dump (not including JVMTI raw monitors):");
        tty.println();
        this.dumpOn(tty);
        textArea.setText(bos.toString());
    }

    private static void dumpMonitor(PrintStream tty, ObjectMonitor mon, boolean raw) {
        JavaThread thread;
        tty.print("ObjectMonitor@" + mon.getAddress());
        if (raw) {
            tty.print("(Raw Monitor)");
        }
        tty.println();
        tty.println("  _header: 0x" + Long.toHexString(mon.header().value()));
        OopHandle obj = mon.object();
        Oop oop = heap.newOop(obj);
        tty.println("  _object: " + obj + ", a " + oop.getKlass().getName().asString());
        Address owner = mon.owner();
        tty.println("  _owner: " + owner);
        if (!raw && owner != null && (thread = threads.owningThreadFromMonitor(mon)) != null) {
            tty.println("    owning thread: " + thread.getThreadName());
            if (!((Object)thread.getAddress()).equals(owner) && !thread.isLockOwned(owner)) {
                tty.println("    WARNING! _owner doesn't fall in " + thread + "'s stack space");
            }
        }
        tty.println("  _count: " + mon.count());
        tty.println("  _waiters: " + mon.waiters());
        tty.println("  _recursions: " + mon.recursions());
    }

    private void dumpOn(PrintStream tty) {
        Iterator i = ObjectSynchronizer.objectMonitorIterator();
        if (i == null) {
            tty.println("This version of HotSpot VM doesn't support monitor cache dump.");
            tty.println("You need 1.4.0_04, 1.4.1_01 or later versions");
            return;
        }
        while (i.hasNext()) {
            ObjectMonitor mon = (ObjectMonitor)i.next();
            if (mon.count() == 0L && mon.waiters() == 0L && mon.owner() == null) continue;
            OopHandle object = mon.object();
            if (object == null) {
                MonitorCacheDumpPanel.dumpMonitor(tty, mon, true);
                continue;
            }
            MonitorCacheDumpPanel.dumpMonitor(tty, mon, false);
        }
    }
}

