/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui.tree;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.FieldIdentifier;
import sun.jvm.hotspot.ui.tree.FieldTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.SimpleTreeNode;

public class BadAddressTreeNodeAdapter
extends FieldTreeNodeAdapter {
    private boolean usingAddress;
    private Address addr;
    private long addrValue;

    public BadAddressTreeNodeAdapter(Address addr, FieldIdentifier id) {
        this(addr, id, false);
    }

    public BadAddressTreeNodeAdapter(Address addr, FieldIdentifier id, boolean treeTableMode) {
        super(id, treeTableMode);
        this.addr = addr;
        this.usingAddress = true;
    }

    public BadAddressTreeNodeAdapter(long addr, FieldIdentifier id) {
        this(addr, id, false);
    }

    public BadAddressTreeNodeAdapter(long addrValue, FieldIdentifier id, boolean treeTableMode) {
        super(id, treeTableMode);
        this.addrValue = addrValue;
        this.usingAddress = false;
    }

    public int getChildCount() {
        return 0;
    }

    public SimpleTreeNode getChild(int index) {
        throw new RuntimeException("Should not call this");
    }

    public boolean isLeaf() {
        return true;
    }

    public int getIndexOfChild(SimpleTreeNode child) {
        throw new RuntimeException("Should not call this");
    }

    public String getValue() {
        String addrString = null;
        addrString = this.usingAddress ? (this.addr == null ? "0x0" : this.addr.toString()) : "0x" + Long.toHexString(this.addrValue);
        return "** BAD ADDRESS " + addrString + " **";
    }
}

