/*
 * Copyright 1999-2002 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

package javax.sound.midi;


/**
 * A <code>MidiUnavailableException</code> is thrown when a requested MIDI
 * component cannot be opened or created because it is unavailable.  This often
 * occurs when a device is in use by another application.  More generally, it
 * can occur when there is a finite number of a certain kind of resource that can
 * be used for some purpose, and all of them are already in use (perhaps all by
 * this application).  For an example of the latter case, see the
 * {@link Transmitter#setReceiver(Receiver) setReceiver} method of
 * <code>Transmitter</code>.
 *
 * @author Kara Kytle
 */
public class MidiUnavailableException extends Exception {

    /**
     * Constructs a <code>MidiUnavailableException</code> that has
     * <code>null</code> as its error detail message.
     */
    public MidiUnavailableException() {

        super();
    }


    /**
     *  Constructs a <code>MidiUnavailableException</code> with the
     * specified detail message.
     *
     * @param message the string to display as an error detail message
     */
    public MidiUnavailableException(String message) {

        super(message);
    }
}
