/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveDeepCopy;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JosmAction
extends AbstractAction
implements Destroyable {
    protected Shortcut sc;
    private LayerChangeAdapter layerChangeAdapter;
    private SelectionChangeAdapter selectionChangeAdapter;

    public Shortcut getShortcut() {
        if (this.sc == null) {
            this.sc = Shortcut.registerShortcut("core:none", I18n.tr("No Shortcut"), 0, 0);
        }
        return this.sc;
    }

    public JosmAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean register) {
        super(name, iconName == null ? null : ImageProvider.get(iconName));
        this.setHelpId();
        this.sc = shortcut;
        if (this.sc != null) {
            Main.registerActionShortcut((Action)this, this.sc);
        }
        this.putValue("ShortDescription", Main.platform.makeTooltip(tooltip, this.sc));
        this.putValue("toolbar", iconName);
        if (register) {
            Main.toolbar.register(this);
        }
        this.installAdapters();
    }

    public JosmAction() {
        this(true);
    }

    public JosmAction(boolean installAdapters) {
        this.setHelpId();
        if (installAdapters) {
            this.installAdapters();
        }
    }

    @Override
    public void destroy() {
        if (this.sc != null) {
            Main.unregisterActionShortcut(this.sc);
        }
        MapView.removeLayerChangeListener(this.layerChangeAdapter);
        DataSet.selListeners.remove(this.selectionChangeAdapter);
    }

    public void pasteBufferChanged(PrimitiveDeepCopy newPasteBuffer) {
    }

    public void addListener(JosmAction a) {
    }

    private void setHelpId() {
        String helpId = "Action/" + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        if (helpId.endsWith("Action")) {
            helpId = helpId.substring(0, helpId.length() - 6);
        }
        this.putValue("help", helpId);
    }

    protected OsmDataLayer getEditLayer() {
        return Main.main.getEditLayer();
    }

    protected DataSet getCurrentDataSet() {
        return Main.main.getCurrentDataSet();
    }

    protected void installAdapters() {
        this.layerChangeAdapter = new LayerChangeAdapter();
        this.selectionChangeAdapter = new SelectionChangeAdapter();
        MapView.addLayerChangeListener(this.layerChangeAdapter);
        DataSet.selListeners.add(this.selectionChangeAdapter);
        this.initEnabledState();
    }

    protected void initEnabledState() {
        this.updateEnabledState();
    }

    protected void updateEnabledState() {
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectionChangeAdapter
    implements SelectionChangedListener {
        private SelectionChangeAdapter() {
        }

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
            JosmAction.this.updateEnabledState(newSelection);
        }
    }

    private class LayerChangeAdapter
    implements MapView.LayerChangeListener {
        private LayerChangeAdapter() {
        }

        public void activeLayerChange(Layer oldLayer, Layer newLayer) {
            JosmAction.this.updateEnabledState();
        }

        public void layerAdded(Layer newLayer) {
            JosmAction.this.updateEnabledState();
        }

        public void layerRemoved(Layer oldLayer) {
            JosmAction.this.updateEnabledState();
        }
    }
}

