/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawAction
extends MapMode
implements MapViewPaintable,
SelectionChangedListener,
AWTEventListener {
    private final Cursor cursorCrosshair;
    private final Cursor cursorJoinNode;
    private final Cursor cursorJoinWay;
    private Cursors currCursor = Cursors.crosshair;
    private Node lastUsedNode = null;
    private double PHI = Math.toRadians(90.0);
    private boolean ctrl;
    private boolean alt;
    private boolean shift;
    private Node mouseOnExistingNode;
    private Set<Way> mouseOnExistingWays = new HashSet<Way>();
    private Set<OsmPrimitive> oldHighlights = new HashSet<OsmPrimitive>();
    private boolean drawHelperLine;
    private boolean wayIsFinished = false;
    private boolean drawTargetHighlight;
    private boolean drawTargetCursor;
    private Point mousePos;
    private Point oldMousePos;
    private Color selectedColor;
    private Node currentBaseNode;
    private EastNorth currentMouseEastNorth;
    private Shortcut extraShortcut = Shortcut.registerShortcut("mapmode:drawfocus", I18n.tr("Mode: Draw Focus"), 78, 3);

    public DrawAction(MapFrame mapFrame) {
        super(I18n.tr("Draw"), "node/autonode", I18n.tr("Draw nodes"), Shortcut.registerShortcut("mapmode:draw", I18n.tr("Mode: {0}", I18n.tr("Draw")), 65, 3), mapFrame, DrawAction.getCursor());
        Main.registerActionShortcut((Action)this, this.extraShortcut);
        this.cursorCrosshair = DrawAction.getCursor();
        this.cursorJoinNode = ImageProvider.getCursor("crosshair", "joinnode");
        this.cursorJoinWay = ImageProvider.getCursor("crosshair", "joinway");
    }

    private static Cursor getCursor() {
        try {
            return ImageProvider.getCursor("crosshair", null);
        }
        catch (Exception exception) {
            return Cursor.getPredefinedCursor(1);
        }
    }

    private void setCursor(final Cursors c) {
        if (this.currCursor.equals((Object)c) || !this.drawTargetCursor && this.currCursor.equals((Object)Cursors.crosshair)) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (!(Main.map.mapMode instanceof DrawAction)) {
                    return;
                }
                switch (c) {
                    case way: {
                        Main.map.mapView.setCursor(DrawAction.this.cursorJoinWay);
                        break;
                    }
                    case node: {
                        Main.map.mapView.setCursor(DrawAction.this.cursorJoinNode);
                        break;
                    }
                    default: {
                        Main.map.mapView.setCursor(DrawAction.this.cursorCrosshair);
                    }
                }
            }
        });
        this.currCursor = c;
    }

    private void redrawIfRequired() {
        this.updateStatusLine();
        if (!(this.drawHelperLine && !this.wayIsFinished || this.drawTargetHighlight)) {
            return;
        }
        Main.map.mapView.repaint();
    }

    private void addHighlighting() {
        this.removeHighlighting();
        if (this.ctrl) {
            this.setCursor(Cursors.crosshair);
            return;
        }
        if (this.mouseOnExistingNode == null && this.getCurrentDataSet().getSelected().size() == 0 && this.mousePos != null) {
            this.mouseOnExistingNode = Main.map.mapView.getNearestNode(this.mousePos, OsmPrimitive.isSelectablePredicate);
        }
        if (this.mouseOnExistingNode != null) {
            this.setCursor(Cursors.node);
            this.oldHighlights.add(this.mouseOnExistingNode);
            if (this.drawTargetHighlight) {
                this.mouseOnExistingNode.setHighlighted(true);
            }
            return;
        }
        if (this.mouseOnExistingWays.size() == 0) {
            this.setCursor(Cursors.crosshair);
            return;
        }
        this.setCursor(Cursors.way);
        this.oldHighlights.addAll(this.mouseOnExistingWays);
        if (!this.drawTargetHighlight) {
            return;
        }
        for (Way w : this.mouseOnExistingWays) {
            w.setHighlighted(true);
        }
    }

    private void removeHighlighting() {
        for (OsmPrimitive prim : this.oldHighlights) {
            prim.setHighlighted(false);
        }
        this.oldHighlights = new HashSet<OsmPrimitive>();
    }

    @Override
    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        this.currCursor = Cursors.crosshair;
        this.selectedColor = PaintColors.SELECTED.get();
        this.drawHelperLine = Main.pref.getBoolean("draw.helper-line", true);
        this.drawTargetHighlight = Main.pref.getBoolean("draw.target-highlight", true);
        this.drawTargetCursor = Main.pref.getBoolean("draw.target-cursor", true);
        this.wayIsFinished = false;
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        Main.map.mapView.addTemporaryLayer(this);
        DataSet.selListeners.add(this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.mapView.removeTemporaryLayer(this);
        DataSet.selListeners.remove(this);
        this.removeHighlighting();
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        DataSet ds = this.getCurrentDataSet();
        if (ds != null) {
            ds.fireSelectionChanged();
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (Main.map == null || Main.map.mapView == null || !Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiers((InputEvent)event);
        this.computeHelperLine();
        this.addHighlighting();
        this.redrawIfRequired();
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.computeHelperLine();
        this.addHighlighting();
        this.redrawIfRequired();
    }

    private void tryAgain(MouseEvent e) {
        this.getCurrentDataSet().setSelected(new PrimitiveId[0]);
        this.mouseReleased(e);
    }

    private void finishDrawing() {
        Main.main.getCurrentDataSet().fireSelectionChanged();
        this.lastUsedNode = null;
        this.wayIsFinished = true;
        Main.map.selectSelectTool(true);
        this.computeHelperLine();
        this.removeHighlighting();
        this.redrawIfRequired();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        String title;
        if (e.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        Main.map.mapView.requestFocus();
        if (e.getClickCount() > 1 && this.mousePos != null && this.mousePos.equals(this.oldMousePos)) {
            this.finishDrawing();
            return;
        }
        this.oldMousePos = this.mousePos;
        this.updateKeyModifiers(e);
        this.mousePos = e.getPoint();
        DataSet ds = this.getCurrentDataSet();
        ArrayList<OsmPrimitive> selection = new ArrayList<OsmPrimitive>(ds.getSelected());
        LinkedList<Command> cmds = new LinkedList<Command>();
        LinkedList<OsmPrimitive> newSelection = new LinkedList<OsmPrimitive>(ds.getSelected());
        ArrayList<Way> reuseWays = new ArrayList<Way>();
        ArrayList replacedWays = new ArrayList();
        boolean newNode = false;
        Node n = null;
        if (!this.ctrl) {
            n = Main.map.mapView.getNearestNode(this.mousePos, OsmPrimitive.isSelectablePredicate);
        }
        if (n != null) {
            if (selection.isEmpty() || this.wayIsFinished) {
                newSelection.clear();
                newSelection.add(n);
                this.getCurrentDataSet().setSelected(n);
                this.wayIsFinished = false;
                return;
            }
        } else {
            n = new Node(Main.map.mapView.getLatLon(e.getX(), e.getY()));
            if (n.getCoor().isOutSideWorld()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot add a node outside of the world."), I18n.tr("Warning"), 2);
                return;
            }
            newNode = true;
            cmds.add(new AddCommand(n));
            if (!this.ctrl) {
                List<WaySegment> wss = Main.map.mapView.getNearestWaySegments(e.getPoint(), OsmPrimitive.isSelectablePredicate);
                HashMap insertPoints = new HashMap();
                for (WaySegment ws : wss) {
                    void var14_16;
                    if (insertPoints.containsKey(ws.way)) {
                        List list = (List)insertPoints.get(ws.way);
                    } else {
                        ArrayList arrayList = new ArrayList();
                        insertPoints.put(ws.way, arrayList);
                    }
                    var14_16.add(ws.lowerIndex);
                }
                HashSet<Pair<Node, Node>> segSet = new HashSet<Pair<Node, Node>>();
                for (Map.Entry entry : insertPoints.entrySet()) {
                    int i;
                    Way w = (Way)entry.getKey();
                    List is = (List)entry.getValue();
                    Way wnew = new Way(w);
                    DrawAction.pruneSuccsAndReverse(is);
                    Iterator<Node> i$ = is.iterator();
                    while (i$.hasNext()) {
                        i = (Integer)((Object)i$.next());
                        segSet.add(Pair.sort(new Pair<Node, Node>(w.getNode(i), w.getNode(i + 1))));
                    }
                    i$ = is.iterator();
                    while (i$.hasNext()) {
                        i = (Integer)((Object)i$.next());
                        wnew.addNode(i + 1, n);
                    }
                    if (this.alt) {
                        newSelection.add((OsmPrimitive)entry.getKey());
                    }
                    cmds.add(new ChangeCommand((OsmPrimitive)entry.getKey(), wnew));
                    replacedWays.add(entry.getKey());
                    reuseWays.add(wnew);
                }
                DrawAction.adjustNode(segSet, n);
            }
        }
        boolean extendedWay = false;
        boolean wayIsFinishedTemp = this.wayIsFinished;
        this.wayIsFinished = false;
        if (selection.size() > 0 && !this.shift) {
            Node selectedNode = null;
            Way selectedWay = null;
            for (OsmPrimitive p : selection) {
                if (p instanceof Node) {
                    if (selectedNode != null) {
                        this.tryAgain(e);
                        return;
                    }
                    selectedNode = (Node)p;
                    continue;
                }
                if (!(p instanceof Way)) continue;
                if (selectedWay != null) {
                    this.tryAgain(e);
                    return;
                }
                selectedWay = (Way)p;
            }
            Node node = this.findNodeToContinueFrom(selectedNode, selectedWay);
            if (node == null) {
                this.tryAgain(e);
                return;
            }
            if (!wayIsFinishedTemp) {
                Way wayToSelect;
                Way way;
                if (this.isSelfContainedWay(selectedWay, node, n)) {
                    return;
                }
                if (node == n) {
                    this.finishDrawing();
                    return;
                }
                Way way2 = this.alt ? null : (way = selectedWay != null ? selectedWay : this.getWayForNode(node));
                if (way != null) {
                    int nodeCount = 0;
                    for (Node p : way.getNodes()) {
                        if (!p.equals(node)) continue;
                        ++nodeCount;
                    }
                    if (nodeCount > 1) {
                        way = null;
                    }
                }
                if (way == null) {
                    way = new Way();
                    way.addNode(node);
                    cmds.add(new AddCommand(way));
                    wayToSelect = way;
                } else {
                    int i = replacedWays.indexOf(way);
                    if (i != -1) {
                        wayToSelect = way = (Way)reuseWays.get(i);
                    } else {
                        wayToSelect = way;
                        Way wnew = new Way(way);
                        cmds.add(new ChangeCommand(way, wnew));
                        way = wnew;
                    }
                }
                if (way.containsNode(n)) {
                    this.wayIsFinished = true;
                    selection.clear();
                }
                if (way.getNode(way.getNodesCount() - 1) == node) {
                    way.addNode(n);
                } else {
                    way.addNode(0, n);
                }
                extendedWay = true;
                newSelection.clear();
                newSelection.add(wayToSelect);
            }
        }
        if (!extendedWay) {
            if (!newNode) {
                return;
            }
            if (reuseWays.isEmpty()) {
                title = I18n.tr("Add node");
            } else {
                title = I18n.tr("Add node into way");
                for (Way way : reuseWays) {
                    newSelection.remove(way);
                }
            }
            newSelection.clear();
            newSelection.add(n);
        } else {
            title = !newNode ? I18n.tr("Connect existing way to node") : (reuseWays.isEmpty() ? I18n.tr("Add a new node to an existing way") : I18n.tr("Add node into way and connect"));
        }
        SequenceCommand c = new SequenceCommand(title, cmds);
        Main.main.undoRedo.add(c);
        if (!this.wayIsFinished) {
            this.lastUsedNode = n;
        }
        this.getCurrentDataSet().setSelected(newSelection);
        this.computeHelperLine();
        this.removeHighlighting();
        this.redrawIfRequired();
    }

    private boolean isSelfContainedWay(Way selectedWay, Node currentNode, Node targetNode) {
        int posn0;
        if (selectedWay != null && ((posn0 = selectedWay.getNodes().indexOf(currentNode)) != -1 && posn0 >= 1 && targetNode.equals(selectedWay.getNode(posn0 - 1)) || posn0 < selectedWay.getNodesCount() - 1 && targetNode.equals(selectedWay.getNode(posn0 + 1)))) {
            this.getCurrentDataSet().setSelected(targetNode);
            this.lastUsedNode = targetNode;
            return true;
        }
        return false;
    }

    private Node findNodeToContinueFrom(Node selectedNode, Way selectedWay) {
        if (selectedNode == null && selectedWay == null) {
            return null;
        }
        if (selectedNode == null) {
            if (selectedWay.isFirstLastNode(this.lastUsedNode)) {
                return this.lastUsedNode;
            }
            return null;
        }
        if (selectedWay == null) {
            return selectedNode;
        }
        if (selectedWay.isFirstLastNode(selectedNode)) {
            return selectedNode;
        }
        return null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiers(e);
        this.mousePos = e.getPoint();
        this.computeHelperLine();
        this.addHighlighting();
        this.redrawIfRequired();
    }

    private void updateKeyModifiers(InputEvent e) {
        this.ctrl = (e.getModifiers() & 2) != 0;
        this.alt = (e.getModifiers() & 0x28) != 0;
        this.shift = (e.getModifiers() & 1) != 0;
    }

    private void updateKeyModifiers(MouseEvent e) {
        this.ctrl = (e.getModifiers() & 2) != 0;
        this.alt = (e.getModifiers() & 0x28) != 0;
        this.shift = (e.getModifiers() & 1) != 0;
    }

    private void computeHelperLine() {
        MapView mv = Main.map.mapView;
        if (this.mousePos == null) {
            this.currentMouseEastNorth = null;
            this.currentBaseNode = null;
            return;
        }
        double distance = -1.0;
        double angle = -1.0;
        Collection<OsmPrimitive> selection = this.getCurrentDataSet().getSelected();
        Node selectedNode = null;
        Way selectedWay = null;
        Node currentMouseNode = null;
        this.mouseOnExistingNode = null;
        this.mouseOnExistingWays = new HashSet<Way>();
        Main.map.statusLine.setAngle(-1.0);
        Main.map.statusLine.setHeading(-1.0);
        Main.map.statusLine.setDist(-1.0);
        if (!this.ctrl && this.mousePos != null) {
            currentMouseNode = mv.getNearestNode(this.mousePos, OsmPrimitive.isSelectablePredicate);
        }
        if (!this.ctrl && currentMouseNode == null) {
            List<WaySegment> wss = mv.getNearestWaySegments(this.mousePos, OsmPrimitive.isSelectablePredicate);
            for (WaySegment ws : wss) {
                this.mouseOnExistingWays.add(ws.way);
            }
        }
        if (currentMouseNode != null) {
            if (selection.isEmpty()) {
                return;
            }
            this.currentMouseEastNorth = currentMouseNode.getEastNorth();
            this.mouseOnExistingNode = currentMouseNode;
        } else {
            this.currentMouseEastNorth = mv.getEastNorth(this.mousePos.x, this.mousePos.y);
        }
        for (OsmPrimitive p : selection) {
            if (p instanceof Node) {
                if (selectedNode != null) {
                    return;
                }
                selectedNode = (Node)p;
                continue;
            }
            if (!(p instanceof Way)) continue;
            if (selectedWay != null) {
                return;
            }
            selectedWay = (Way)p;
        }
        this.currentBaseNode = null;
        Node previousNode = null;
        if (selectedNode == null) {
            if (selectedWay == null) {
                return;
            }
            if (selectedWay.isFirstLastNode(this.lastUsedNode)) {
                this.currentBaseNode = this.lastUsedNode;
                if (this.lastUsedNode == selectedWay.getNode(selectedWay.getNodesCount() - 1) && selectedWay.getNodesCount() > 1) {
                    previousNode = selectedWay.getNode(selectedWay.getNodesCount() - 2);
                }
            }
        } else if (selectedWay == null) {
            this.currentBaseNode = selectedNode;
        } else if (selectedNode == selectedWay.getNode(0) || selectedNode == selectedWay.getNode(selectedWay.getNodesCount() - 1)) {
            this.currentBaseNode = selectedNode;
        }
        if (this.currentBaseNode == null || this.currentBaseNode == currentMouseNode) {
            return;
        }
        LatLon mouseLatLon = mv.getProjection().eastNorth2latlon(this.currentMouseEastNorth);
        distance = this.currentBaseNode.getCoor().greatCircleDistance(mouseLatLon);
        double hdg = Math.toDegrees(this.currentBaseNode.getEastNorth().heading(this.currentMouseEastNorth));
        if (previousNode != null) {
            angle += (angle = hdg - Math.toDegrees(previousNode.getEastNorth().heading(this.currentBaseNode.getEastNorth()))) < 0.0 ? 360.0 : 0.0;
        }
        Main.map.statusLine.setAngle(angle);
        Main.map.statusLine.setHeading(hdg);
        Main.map.statusLine.setDist(distance);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.mousePos = e.getPoint();
        Main.map.mapView.repaint();
    }

    public Way getWayForNode(Node n) {
        Way way = null;
        for (Way w : OsmPrimitive.getFilteredList(n.getReferrers(), Way.class)) {
            if (!w.isUsable() || w.getNodesCount() < 1) continue;
            Node firstNode = w.getNode(0);
            Node lastNode = w.getNode(w.getNodesCount() - 1);
            if (firstNode != n && lastNode != n || firstNode == lastNode) continue;
            if (way != null) {
                return null;
            }
            way = w;
        }
        return way;
    }

    private static void pruneSuccsAndReverse(List<Integer> is) {
        HashSet<Integer> is2 = new HashSet<Integer>();
        for (int i : is) {
            if (is2.contains(i - 1) || is2.contains(i + 1)) continue;
            is2.add(i);
        }
        is.clear();
        is.addAll(is2);
        Collections.sort(is);
        Collections.reverse(is);
    }

    private static void adjustNode(Collection<Pair<Node, Node>> segs, Node n) {
        double q;
        EastNorth B;
        EastNorth A;
        Pair<Node, Node> seg;
        switch (segs.size()) {
            case 0: {
                return;
            }
            case 2: {
                Iterator<Pair<Node, Node>> i = segs.iterator();
                seg = i.next();
                A = ((Node)seg.a).getEastNorth();
                B = ((Node)seg.b).getEastNorth();
                seg = i.next();
                EastNorth C = ((Node)seg.a).getEastNorth();
                EastNorth D = ((Node)seg.b).getEastNorth();
                double u = DrawAction.det(B.east() - A.east(), B.north() - A.north(), C.east() - D.east(), C.north() - D.north());
                if (u == 0.0) {
                    return;
                }
                q = DrawAction.det(B.north() - C.north(), B.east() - C.east(), D.north() - C.north(), D.east() - C.east()) / u;
                EastNorth intersection = new EastNorth(B.east() + q * (A.east() - B.east()), B.north() + q * (A.north() - B.north()));
                int snapToIntersectionThreshold = Main.pref.getInteger("edit.snap-intersection-threshold", 10);
                if (!(Main.map.mapView.getPoint(n).distance(Main.map.mapView.getPoint(intersection)) < (double)snapToIntersectionThreshold)) break;
                n.setEastNorth(intersection);
                return;
            }
        }
        EastNorth P = n.getEastNorth();
        seg = segs.iterator().next();
        A = ((Node)seg.a).getEastNorth();
        B = ((Node)seg.b).getEastNorth();
        double a = P.distanceSq(B);
        double b = P.distanceSq(A);
        double c = A.distanceSq(B);
        q = (a - b + c) / (2.0 * c);
        n.setEastNorth(new EastNorth(B.east() + q * (A.east() - B.east()), B.north() + q * (A.north() - B.north())));
    }

    static double det(double a, double b, double c, double d) {
        return a * d - b * c;
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        if (!this.drawHelperLine || this.wayIsFinished || this.shift) {
            return;
        }
        if (Main.map.mapView == null) {
            return;
        }
        if (this.mousePos == null) {
            return;
        }
        if (this.currentBaseNode == null || this.currentMouseEastNorth == null) {
            return;
        }
        if (!Main.map.mapView.getBounds().contains(this.mousePos)) {
            return;
        }
        Graphics2D g2 = g;
        g2.setColor(this.selectedColor);
        g2.setStroke(new BasicStroke(3.0f, 1, 1));
        GeneralPath b = new GeneralPath();
        Point p1 = mv.getPoint(this.currentBaseNode);
        Point p2 = mv.getPoint(this.currentMouseEastNorth);
        double t = Math.atan2(p2.y - p1.y, p2.x - p1.x) + Math.PI;
        b.moveTo(p1.x, p1.y);
        b.lineTo(p2.x, p2.y);
        if (this.alt) {
            b.moveTo((int)((double)p1.x + 8.0 * Math.cos(t + this.PHI)), (int)((double)p1.y + 8.0 * Math.sin(t + this.PHI)));
            b.lineTo((int)((double)p1.x + 8.0 * Math.cos(t - this.PHI)), (int)((double)p1.y + 8.0 * Math.sin(t - this.PHI)));
        }
        g2.draw(b);
        g2.setStroke(new BasicStroke(1.0f));
    }

    @Override
    public String getModeHelpText() {
        Node n;
        OsmPrimitive x;
        String rv = "";
        rv = this.ctrl || this.oldHighlights.isEmpty() ? I18n.tr("Create new node.") : ((x = this.oldHighlights.iterator().next()) instanceof Node ? I18n.tr("Select node under cursor.") : I18n.trn("Insert new node into way.", "Insert new node into {0} ways.", this.oldHighlights.size(), this.oldHighlights.size()));
        if (this.currentBaseNode != null && !this.wayIsFinished) {
            rv = this.alt ? rv + " " + I18n.tr("Start new way from last node.") : rv + " " + I18n.tr("Continue way from last node.");
        }
        if ((n = this.mouseOnExistingNode) != null && this.getCurrentDataSet() != null && this.getCurrentDataSet().getSelectedNodes().contains(n)) {
            rv = this.wayIsFinished ? I18n.tr("Select node under cursor.") : I18n.tr("Finish drawing.");
        }
        if (this.getCurrentDataSet() != null && this.getCurrentDataSet().getSelectedWays().size() > 0 && !this.wayIsFinished && !this.alt) {
            Way w = this.getCurrentDataSet().getSelectedWays().iterator().next();
            for (Node m : w.getNodes()) {
                if (!m.equals(this.mouseOnExistingNode) && !this.mouseOnExistingWays.contains(w)) continue;
                rv = rv + " " + I18n.tr("Finish drawing.");
                break;
            }
        }
        return rv;
    }

    @Override
    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getEditLayer() != null);
    }

    @Override
    public void destroy() {
        super.destroy();
        Main.unregisterActionShortcut(this.extraShortcut);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Cursors {
        crosshair,
        node,
        way;

    }
}

