/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.Base64;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.XmlObjectParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerSidePreferences
extends Preferences {
    private static final Logger logger = Logger.getLogger(ServerSidePreferences.class.getName());
    private final Connection connection;

    public ServerSidePreferences(URL serverUrl) {
        Connection connection = null;
        try {
            connection = new Connection(new URL(serverUrl + "user/preferences"));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not load preferences from server."), I18n.tr("Error"), 0);
        }
        this.connection = connection;
    }

    @Override
    public String getPreferencesDir() {
        return this.connection.serverUrl.toString();
    }

    @Override
    public void load() {
    }

    @Override
    public void save() {
    }

    public void download(String userName, String password) {
        String cont;
        this.resetToDefault();
        if (!this.properties.containsKey("osm-server.username") && userName != null) {
            this.properties.put("osm-server.username", userName);
        }
        if (!this.properties.containsKey("osm-server.password") && password != null) {
            this.properties.put("osm-server.password", password);
        }
        if ((cont = this.connection.download()) == null) {
            return;
        }
        StringReader in = new StringReader(cont);
        try {
            XmlObjectParser.Uniform<Prop> parser = new XmlObjectParser.Uniform<Prop>(in, "tag", Prop.class);
            for (Prop p : parser) {
                this.properties.put(p.key, p.value);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public void upload() {
        StringBuilder b = new StringBuilder("<preferences>\n");
        for (Map.Entry p : this.properties.entrySet()) {
            if (((String)p.getKey()).equals("osm-server.password")) continue;
            b.append("<tag key='");
            b.append(XmlWriter.encode((String)p.getKey()));
            b.append("' value='");
            b.append(XmlWriter.encode((String)p.getValue()));
            b.append("' />\n");
        }
        b.append("</preferences>");
        this.connection.upload(b.toString());
    }

    @Override
    public Collection<Preferences.Bookmark> loadBookmarks() {
        URL url = null;
        try {
            LinkedList<Preferences.Bookmark> bookmarks = new LinkedList<Preferences.Bookmark>();
            url = new URL("http://" + this.connection.serverUrl.getHost() + "/josm/bookmarks");
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = in.readLine();
            while (line != null) {
                StringTokenizer st = new StringTokenizer(line, ",");
                if (st.countTokens() != 5) {
                    System.err.println(I18n.tr("Error: Unexpected line ''{0}'' in bookmark list from server", line));
                } else {
                    Preferences.Bookmark b = new Preferences.Bookmark();
                    b.setName(st.nextToken());
                    double[] values = new double[4];
                    for (int i = 0; i < 4; ++i) {
                        String token = st.nextToken();
                        try {
                            values[i] = Double.parseDouble(token);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            System.err.println(I18n.tr("Error: Illegal double value ''{0}'' on line ''{1}'' in bookmark list from server", token, line));
                        }
                    }
                    b.setArea(new Bounds(values));
                    bookmarks.add(b);
                }
                line = in.readLine();
            }
            in.close();
            return bookmarks;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
            logger.warning(I18n.tr("Failed to load bookmarks from ''{0}'' for security reasons. Exception was: {1}", url == null ? "null" : url.toExternalForm(), e.toString()));
        }
        return Collections.emptyList();
    }

    @Override
    public void saveBookmarks(Collection<Preferences.Bookmark> bookmarks) {
    }

    public static class Prop {
        public String key;
        public String value;
    }

    private class Connection
    extends OsmConnection {
        URL serverUrl;

        public Connection(URL serverUrl) {
            this.serverUrl = serverUrl;
        }

        public String download() {
            try {
                System.out.println("reading preferences from " + this.serverUrl);
                URLConnection con = this.serverUrl.openConnection();
                if (con instanceof HttpURLConnection) {
                    this.addAuth((HttpURLConnection)con);
                }
                con.connect();
                BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuilder b = new StringBuilder();
                String line = reader.readLine();
                while (line != null) {
                    b.append(line);
                    b.append("\n");
                    line = reader.readLine();
                }
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
                return b.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (OsmTransferException e) {
                e.printStackTrace();
            }
            return null;
        }

        public void upload(String s) {
            try {
                URL u = new URL(ServerSidePreferences.this.getPreferencesDir());
                System.out.println("uploading preferences to " + u);
                HttpURLConnection con = (HttpURLConnection)u.openConnection();
                con.addRequestProperty("Authorization", "Basic " + Base64.encode(ServerSidePreferences.this.get("osm-server.username") + ":" + ServerSidePreferences.this.get("osm-server.password")));
                con.setRequestMethod("POST");
                con.setDoOutput(true);
                con.connect();
                PrintWriter out = new PrintWriter(new OutputStreamWriter(con.getOutputStream()));
                out.println(s);
                out.close();
                con.getInputStream().close();
                con.disconnect();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Preferences stored on {0}", u.getHost()), I18n.tr("Information"), 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not upload preferences. Reason: {0}", e.getMessage()), I18n.tr("Error"), 0);
            }
        }
    }
}

