/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.Point;

public class LineClip {
    private Point p1;
    private Point p2;

    public int computeOutCode(long x, long y, long xmin, long ymin, long xmax, long ymax) {
        int code = 0;
        if (y > ymax) {
            code |= 2;
        } else if (y < ymin) {
            code |= 8;
        }
        if (x > xmax) {
            code |= 4;
        } else if (x < xmin) {
            code |= 1;
        }
        return code;
    }

    public boolean cohenSutherland(long x1, long y1, long x2, long y2, long xmin, long ymin, long xmax, long ymax) {
        boolean accept = false;
        boolean done = false;
        int outcode0 = this.computeOutCode(x1, y1, xmin, ymin, xmax, ymax);
        int outcode1 = this.computeOutCode(x2, y2, xmin, ymin, xmax, ymax);
        do {
            int outcodeOut;
            if ((outcode0 | outcode1) == 0) {
                accept = true;
                done = true;
                continue;
            }
            if ((outcode0 & outcode1) > 0) {
                done = true;
                continue;
            }
            long x = 0L;
            long y = 0L;
            int n = outcodeOut = outcode0 != 0 ? outcode0 : outcode1;
            if ((outcodeOut & 2) > 0) {
                x = x1 + (x2 - x1) * (ymax - y1) / (y2 - y1);
                y = ymax;
            } else if ((outcodeOut & 8) > 0) {
                x = x1 + (x2 - x1) * (ymin - y1) / (y2 - y1);
                y = ymin;
            } else if ((outcodeOut & 4) > 0) {
                y = y1 + (y2 - y1) * (xmax - x1) / (x2 - x1);
                x = xmax;
            } else if ((outcodeOut & 1) > 0) {
                y = y1 + (y2 - y1) * (xmin - x1) / (x2 - x1);
                x = xmin;
            }
            if (outcodeOut == outcode0) {
                x1 = x;
                y1 = y;
                outcode0 = this.computeOutCode(x1, y1, xmin, ymin, xmax, ymax);
                continue;
            }
            x2 = x;
            y2 = y;
            outcode1 = this.computeOutCode(x2, y2, xmin, ymin, xmax, ymax);
        } while (!done);
        if (accept) {
            this.p1 = new Point((int)x1, (int)y1);
            this.p2 = new Point((int)x2, (int)y2);
            return true;
        }
        return false;
    }

    public Point getP1() {
        return this.p1;
    }

    public Point getP2() {
        return this.p2;
    }
}

