/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

public class NTV2Util {
    private NTV2Util() {
    }

    public static final int getIntLE(byte[] b, int i) {
        return b[i++] & 0xFF | b[i++] << 8 & 0xFF00 | b[i++] << 16 & 0xFF0000 | b[i] << 24;
    }

    public static final int getIntBE(byte[] b, int i) {
        return b[i++] << 24 | b[i++] << 16 & 0xFF0000 | b[i++] << 8 & 0xFF00 | b[i] & 0xFF;
    }

    public static final int getInt(byte[] b, boolean bigEndian) {
        if (bigEndian) {
            return NTV2Util.getIntBE(b, 0);
        }
        return NTV2Util.getIntLE(b, 0);
    }

    public static final float getFloat(byte[] b, boolean bigEndian) {
        int i = 0;
        i = bigEndian ? NTV2Util.getIntBE(b, 0) : NTV2Util.getIntLE(b, 0);
        return Float.intBitsToFloat(i);
    }

    public static final double getDouble(byte[] b, boolean bigEndian) {
        int i = 0;
        int j = 0;
        if (bigEndian) {
            i = NTV2Util.getIntBE(b, 0);
            j = NTV2Util.getIntBE(b, 4);
        } else {
            i = NTV2Util.getIntLE(b, 4);
            j = NTV2Util.getIntLE(b, 0);
        }
        long l = (long)i << 32 | (long)j & 0xFFFFFFFFL;
        return Double.longBitsToDouble(l);
    }

    public static boolean isNioAvailable() {
        boolean nioAvailable = false;
        try {
            Class.forName("java.nio.channels.FileChannel");
            nioAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return nioAvailable;
    }
}

