/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTM
implements Projection,
ProjectionSubPrefs {
    public static final int DEFAULT_ZONE = 30;
    private int zone = 30;
    private static final double UTMScaleFactor = 0.9996;

    private double ArcLengthOfMeridian(double phi) {
        double n = (Ellipsoid.GRS80.a - Ellipsoid.GRS80.b) / (Ellipsoid.GRS80.a + Ellipsoid.GRS80.b);
        double alpha = (Ellipsoid.GRS80.a + Ellipsoid.GRS80.b) / 2.0 * (1.0 + Math.pow(n, 2.0) / 4.0 + Math.pow(n, 4.0) / 64.0);
        double beta = -3.0 * n / 2.0 + 9.0 * Math.pow(n, 3.0) / 16.0 + -3.0 * Math.pow(n, 5.0) / 32.0;
        double gamma = 15.0 * Math.pow(n, 2.0) / 16.0 + -15.0 * Math.pow(n, 4.0) / 32.0;
        double delta = -35.0 * Math.pow(n, 3.0) / 48.0 + 105.0 * Math.pow(n, 5.0) / 256.0;
        double epsilon = 315.0 * Math.pow(n, 4.0) / 512.0;
        return alpha * (phi + beta * Math.sin(2.0 * phi) + gamma * Math.sin(4.0 * phi) + delta * Math.sin(6.0 * phi) + epsilon * Math.sin(8.0 * phi));
    }

    private double UTMCentralMeridian(int zone) {
        return Math.toRadians(-183.0 + (double)zone * 6.0);
    }

    private double UTMCentralMeridianDeg(int zone) {
        return -183.0 + (double)zone * 6.0;
    }

    private double FootpointLatitude(double y) {
        double n = (Ellipsoid.GRS80.a - Ellipsoid.GRS80.b) / (Ellipsoid.GRS80.a + Ellipsoid.GRS80.b);
        double alpha_ = (Ellipsoid.GRS80.a + Ellipsoid.GRS80.b) / 2.0 * (1.0 + Math.pow(n, 2.0) / 4.0 + Math.pow(n, 4.0) / 64.0);
        double y_ = y / alpha_;
        double beta_ = 3.0 * n / 2.0 + -27.0 * Math.pow(n, 3.0) / 32.0 + 269.0 * Math.pow(n, 5.0) / 512.0;
        double gamma_ = 21.0 * Math.pow(n, 2.0) / 16.0 + -55.0 * Math.pow(n, 4.0) / 32.0;
        double delta_ = 151.0 * Math.pow(n, 3.0) / 96.0 + -417.0 * Math.pow(n, 5.0) / 128.0;
        double epsilon_ = 1097.0 * Math.pow(n, 4.0) / 512.0;
        return y_ + beta_ * Math.sin(2.0 * y_) + gamma_ * Math.sin(4.0 * y_) + delta_ * Math.sin(6.0 * y_) + epsilon_ * Math.sin(8.0 * y_);
    }

    public EastNorth mapLatLonToXY(double phi, double lambda, double lambda0) {
        double ep2 = (Math.pow(Ellipsoid.GRS80.a, 2.0) - Math.pow(Ellipsoid.GRS80.b, 2.0)) / Math.pow(Ellipsoid.GRS80.b, 2.0);
        double nu2 = ep2 * Math.pow(Math.cos(phi), 2.0);
        double N = Math.pow(Ellipsoid.GRS80.a, 2.0) / (Ellipsoid.GRS80.b * Math.sqrt(1.0 + nu2));
        double t = Math.tan(phi);
        double t2 = t * t;
        double l = lambda - lambda0;
        double l3coef = 1.0 - t2 + nu2;
        double l4coef = 5.0 - t2 + 9.0 * nu2 + 4.0 * (nu2 * nu2);
        double l5coef = 5.0 - 18.0 * t2 + t2 * t2 + 14.0 * nu2 - 58.0 * t2 * nu2;
        double l6coef = 61.0 - 58.0 * t2 + t2 * t2 + 270.0 * nu2 - 330.0 * t2 * nu2;
        double l7coef = 61.0 - 479.0 * t2 + 179.0 * (t2 * t2) - t2 * t2 * t2;
        double l8coef = 1385.0 - 3111.0 * t2 + 543.0 * (t2 * t2) - t2 * t2 * t2;
        return new EastNorth(N * Math.cos(phi) * l + N / 6.0 * Math.pow(Math.cos(phi), 3.0) * l3coef * Math.pow(l, 3.0) + N / 120.0 * Math.pow(Math.cos(phi), 5.0) * l5coef * Math.pow(l, 5.0) + N / 5040.0 * Math.pow(Math.cos(phi), 7.0) * l7coef * Math.pow(l, 7.0), this.ArcLengthOfMeridian(phi) + t / 2.0 * N * Math.pow(Math.cos(phi), 2.0) * Math.pow(l, 2.0) + t / 24.0 * N * Math.pow(Math.cos(phi), 4.0) * l4coef * Math.pow(l, 4.0) + t / 720.0 * N * Math.pow(Math.cos(phi), 6.0) * l6coef * Math.pow(l, 6.0) + t / 40320.0 * N * Math.pow(Math.cos(phi), 8.0) * l8coef * Math.pow(l, 8.0));
    }

    public LatLon mapXYToLatLon(double x, double y, double lambda0) {
        double Nf;
        double phif = this.FootpointLatitude(y);
        double ep2 = (Math.pow(Ellipsoid.GRS80.a, 2.0) - Math.pow(Ellipsoid.GRS80.b, 2.0)) / Math.pow(Ellipsoid.GRS80.b, 2.0);
        double cf = Math.cos(phif);
        double nuf2 = ep2 * Math.pow(cf, 2.0);
        double Nfpow = Nf = Math.pow(Ellipsoid.GRS80.a, 2.0) / (Ellipsoid.GRS80.b * Math.sqrt(1.0 + nuf2));
        double tf = Math.tan(phif);
        double tf2 = tf * tf;
        double tf4 = tf2 * tf2;
        double x1frac = 1.0 / (Nfpow * cf);
        double x2frac = tf / (2.0 * (Nfpow *= Nf));
        double x3frac = 1.0 / (6.0 * (Nfpow *= Nf) * cf);
        double x4frac = tf / (24.0 * (Nfpow *= Nf));
        double x5frac = 1.0 / (120.0 * (Nfpow *= Nf) * cf);
        double x6frac = tf / (720.0 * (Nfpow *= Nf));
        double x7frac = 1.0 / (5040.0 * (Nfpow *= Nf) * cf);
        double x8frac = tf / (40320.0 * (Nfpow *= Nf));
        double x2poly = -1.0 - nuf2;
        double x3poly = -1.0 - 2.0 * tf2 - nuf2;
        double x4poly = 5.0 + 3.0 * tf2 + 6.0 * nuf2 - 6.0 * tf2 * nuf2 - 3.0 * (nuf2 * nuf2) - 9.0 * tf2 * (nuf2 * nuf2);
        double x5poly = 5.0 + 28.0 * tf2 + 24.0 * tf4 + 6.0 * nuf2 + 8.0 * tf2 * nuf2;
        double x6poly = -61.0 - 90.0 * tf2 - 45.0 * tf4 - 107.0 * nuf2 + 162.0 * tf2 * nuf2;
        double x7poly = -61.0 - 662.0 * tf2 - 1320.0 * tf4 - 720.0 * (tf4 * tf2);
        double x8poly = 1385.0 + 3633.0 * tf2 + 4095.0 * tf4 + 1575.0 * (tf4 * tf2);
        return new LatLon(Math.toDegrees(phif + x2frac * x2poly * (x * x) + x4frac * x4poly * Math.pow(x, 4.0) + x6frac * x6poly * Math.pow(x, 6.0) + x8frac * x8poly * Math.pow(x, 8.0)), Math.toDegrees(lambda0 + x1frac * x + x3frac * x3poly * Math.pow(x, 3.0) + x5frac * x5poly * Math.pow(x, 5.0) + x7frac * x7poly * Math.pow(x, 7.0)));
    }

    @Override
    public EastNorth latlon2eastNorth(LatLon p) {
        EastNorth a = this.mapLatLonToXY(Math.toRadians(p.lat()), Math.toRadians(p.lon()), this.UTMCentralMeridian(this.getzone()));
        return new EastNorth(a.east() * 0.9996 + 3500000.0, a.north() * 0.9996);
    }

    @Override
    public LatLon eastNorth2latlon(EastNorth p) {
        return this.mapXYToLatLon((p.east() - 3500000.0) / 0.9996, p.north() / 0.9996, this.UTMCentralMeridian(this.getzone()));
    }

    @Override
    public String toString() {
        return I18n.tr("UTM");
    }

    public int getzone() {
        return this.zone;
    }

    @Override
    public String toCode() {
        return "EPSG:" + (325800 + this.getzone());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + this.zone;
    }

    @Override
    public String getCacheDirectoryName() {
        return "epsg" + (325800 + this.getzone());
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(-85.0, this.UTMCentralMeridianDeg(this.getzone()) - 5.0), new LatLon(85.0, this.UTMCentralMeridianDeg(this.getzone()) + 5.0));
    }

    @Override
    public double getDefaultZoomInPPD() {
        return 10.0;
    }

    @Override
    public void setupPreferencePanel(JPanel p) {
        JComboBox<Integer> prefcb = new JComboBox<Integer>();
        for (int i = 1; i <= 60; ++i) {
            prefcb.addItem(i);
        }
        prefcb.setSelectedIndex(this.zone - 1);
        p.setLayout(new GridBagLayout());
        p.add((Component)new JLabel(I18n.tr("UTM Zone")), GBC.std().insets(5, 5, 0, 5));
        p.add(GBC.glue(1, 0), GBC.std().fill(2));
        p.add(prefcb, GBC.eop().fill(2));
        p.add(GBC.glue(1, 1), GBC.eol().fill(1));
    }

    @Override
    public Collection<String> getPreferences(JPanel p) {
        Component prefcb = p.getComponent(2);
        if (!(prefcb instanceof JComboBox)) {
            return null;
        }
        int zone = ((JComboBox)prefcb).getSelectedIndex() + 1;
        return Collections.singleton(Integer.toString(zone));
    }

    @Override
    public void setPreferences(Collection<String> args) {
        this.zone = 30;
        if (args != null) {
            try {
                Iterator<String> i$ = args.iterator();
                if (i$.hasNext()) {
                    String s = i$.next();
                    this.zone = Integer.parseInt(s);
                    if (this.zone <= 0 || this.zone > 60) {
                        this.zone = 30;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public Collection<String> getPreferencesFromCode(String code) {
        if (code.startsWith("EPSG:3258")) {
            try {
                String zonestring = code.substring(9);
                int zoneval = Integer.parseInt(zonestring);
                if (zoneval > 0 && zoneval <= 60) {
                    return Collections.singleton(zonestring);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

