/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OsmUrlToBounds;

public class BoundingBoxSelection
implements DownloadSelection {
    private JTextField[] latlon = null;
    private final JTextArea tfOsmUrl = new JTextArea();
    private final JTextArea showUrl = new JTextArea();
    private DownloadDialog parent;
    private Border errorBorder = BorderFactory.createLineBorder(Color.RED, 1);

    protected void registerBoundingBoxBuilder() {
        BoundingBoxBuilder bboxbuilder = new BoundingBoxBuilder();
        for (int i = 0; i < this.latlon.length; ++i) {
            this.latlon[i].addFocusListener(bboxbuilder);
            this.latlon[i].addActionListener(bboxbuilder);
        }
    }

    protected void buildDownloadAreaInputFields() {
        this.latlon = new JTextField[4];
        for (int i = 0; i < 4; ++i) {
            this.latlon[i] = new JTextField(11);
            this.latlon[i].setMinimumSize(new Dimension(100, new JTextField().getMinimumSize().height));
            this.latlon[i].addFocusListener(new SelectAllOnFocusHandler(this.latlon[i]));
        }
        LatValueChecker latChecker = new LatValueChecker(this.latlon[0]);
        this.latlon[0].addFocusListener(latChecker);
        this.latlon[0].addActionListener(latChecker);
        latChecker = new LatValueChecker(this.latlon[2]);
        this.latlon[2].addFocusListener(latChecker);
        this.latlon[2].addActionListener(latChecker);
        LonValueChecker lonChecker = new LonValueChecker(this.latlon[1]);
        this.latlon[1].addFocusListener(lonChecker);
        this.latlon[1].addActionListener(lonChecker);
        lonChecker = new LonValueChecker(this.latlon[3]);
        this.latlon[3].addFocusListener(lonChecker);
        this.latlon[3].addActionListener(lonChecker);
        this.registerBoundingBoxBuilder();
    }

    public void addGui(DownloadDialog gui) {
        this.buildDownloadAreaInputFields();
        JPanel dlg = new JPanel(new GridBagLayout());
        this.tfOsmUrl.getDocument().addDocumentListener(new OsmUrlRefresher());
        this.tfOsmUrl.addFocusListener(new SelectAllOnFocusHandler(this.tfOsmUrl));
        this.tfOsmUrl.setLineWrap(true);
        this.tfOsmUrl.setBorder(this.latlon[0].getBorder());
        dlg.add((Component)new JLabel(I18n.tr("min lat")), GBC.std().insets(10, 20, 5, 0));
        dlg.add((Component)this.latlon[0], GBC.std().insets(0, 20, 0, 0));
        dlg.add((Component)new JLabel(I18n.tr("min lon")), GBC.std().insets(10, 20, 5, 0));
        dlg.add((Component)this.latlon[1], GBC.eol().insets(0, 20, 0, 0));
        dlg.add((Component)new JLabel(I18n.tr("max lat")), GBC.std().insets(10, 0, 5, 0));
        dlg.add((Component)this.latlon[2], GBC.std());
        dlg.add((Component)new JLabel(I18n.tr("max lon")), GBC.std().insets(10, 0, 5, 0));
        dlg.add((Component)this.latlon[3], GBC.eol());
        dlg.add((Component)new JLabel(I18n.tr("URL from www.openstreetmap.org (you can paste an URL here to download the area)")), GBC.eol().insets(10, 20, 5, 0));
        dlg.add((Component)this.tfOsmUrl, GBC.eop().insets(10, 0, 5, 0).fill());
        this.tfOsmUrl.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.checkPopup(e);
            }

            public void mouseClicked(MouseEvent e) {
                this.checkPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.checkPopup(e);
            }

            private void checkPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    OsmUrlPopup popup = new OsmUrlPopup();
                    popup.show(BoundingBoxSelection.this.tfOsmUrl, e.getX(), e.getY());
                }
            }
        });
        dlg.add((Component)this.showUrl, GBC.eop().insets(10, 0, 5, 5));
        this.showUrl.setEditable(false);
        this.showUrl.setBackground(dlg.getBackground());
        this.showUrl.addFocusListener(new SelectAllOnFocusHandler(this.showUrl));
        gui.addDownloadAreaSelector(dlg, I18n.tr("Bounding Box"));
        this.parent = gui;
    }

    public void setDownloadArea(Bounds area) {
        this.updateBboxFields(area);
        this.updateUrl(area);
    }

    public Bounds getDownloadArea() {
        double[] values = new double[4];
        for (int i = 0; i < 4; ++i) {
            try {
                values[i] = Double.parseDouble(this.latlon[i].getText());
                continue;
            }
            catch (NumberFormatException x) {
                return null;
            }
        }
        if (!LatLon.isValidLat(values[0]) || !LatLon.isValidLon(values[1])) {
            return null;
        }
        if (!LatLon.isValidLat(values[2]) || !LatLon.isValidLon(values[3])) {
            return null;
        }
        return new Bounds(values);
    }

    private boolean parseURL(DownloadDialog gui) {
        Bounds b = OsmUrlToBounds.parse(this.tfOsmUrl.getText());
        if (b == null) {
            return false;
        }
        gui.boundingBoxChanged(b, this);
        this.updateBboxFields(b);
        this.updateUrl(b);
        return true;
    }

    private void updateBboxFields(Bounds area) {
        if (area == null) {
            return;
        }
        this.latlon[0].setText(Double.toString(area.getMin().lat()));
        this.latlon[1].setText(Double.toString(area.getMin().lon()));
        this.latlon[2].setText(Double.toString(area.getMax().lat()));
        this.latlon[3].setText(Double.toString(area.getMax().lon()));
        for (JTextField tf : this.latlon) {
            this.resetErrorMessage(tf);
        }
    }

    private void updateUrl(Bounds area) {
        if (area == null) {
            return;
        }
        this.showUrl.setText(OsmUrlToBounds.getURL(area));
    }

    protected void setErrorMessage(JTextField tf, String msg) {
        tf.setBorder(this.errorBorder);
        tf.setToolTipText(msg);
    }

    protected void resetErrorMessage(JTextField tf) {
        tf.setBorder(UIManager.getBorder("TextField.border"));
        tf.setToolTipText("");
    }

    class BoundingBoxBuilder
    extends FocusAdapter
    implements ActionListener {
        BoundingBoxBuilder() {
        }

        protected Bounds build() {
            double maxlat;
            double maxlon;
            double minlat;
            double minlon;
            try {
                minlon = Double.parseDouble(BoundingBoxSelection.this.latlon[0].getText().trim());
                minlat = Double.parseDouble(BoundingBoxSelection.this.latlon[1].getText().trim());
                maxlon = Double.parseDouble(BoundingBoxSelection.this.latlon[2].getText().trim());
                maxlat = Double.parseDouble(BoundingBoxSelection.this.latlon[3].getText().trim());
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (!(LatLon.isValidLon(minlon) && LatLon.isValidLon(maxlon) && LatLon.isValidLat(minlat) && LatLon.isValidLat(maxlat))) {
                return null;
            }
            if (minlon > maxlon) {
                return null;
            }
            if (minlat > maxlat) {
                return null;
            }
            return new Bounds(minlon, minlat, maxlon, maxlat);
        }

        protected void refreshBounds() {
            Bounds b = this.build();
            BoundingBoxSelection.this.parent.boundingBoxChanged(b, BoundingBoxSelection.this);
        }

        public void focusLost(FocusEvent e) {
            this.refreshBounds();
        }

        public void actionPerformed(ActionEvent e) {
            this.refreshBounds();
        }
    }

    class OsmUrlPopup
    extends JPopupMenu {
        public OsmUrlPopup() {
            this.add(new PasteUrlAction());
        }
    }

    class PasteUrlAction
    extends AbstractAction
    implements FlavorListener {
        public PasteUrlAction() {
            this.putValue("Name", I18n.tr("Paste"));
            this.putValue("SmallIcon", ImageProvider.get("paste"));
            this.putValue("ShortDescription", I18n.tr("Paste URL from clipboard"));
            Toolkit.getDefaultToolkit().getSystemClipboard().addFlavorListener(this);
        }

        protected String getClipboardContent() {
            Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            try {
                if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String text = (String)t.getTransferData(DataFlavor.stringFlavor);
                    return text;
                }
            }
            catch (UnsupportedFlavorException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return null;
            }
            return null;
        }

        public void actionPerformed(ActionEvent e) {
            String content = this.getClipboardContent();
            if (content != null) {
                BoundingBoxSelection.this.tfOsmUrl.setText(content);
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(this.getClipboardContent() != null);
        }

        public void flavorsChanged(FlavorEvent e) {
            this.updateEnabledState();
        }
    }

    class OsmUrlRefresher
    implements DocumentListener {
        OsmUrlRefresher() {
        }

        public void changedUpdate(DocumentEvent e) {
            BoundingBoxSelection.this.parseURL(BoundingBoxSelection.this.parent);
        }

        public void insertUpdate(DocumentEvent e) {
            BoundingBoxSelection.this.parseURL(BoundingBoxSelection.this.parent);
        }

        public void removeUpdate(DocumentEvent e) {
            BoundingBoxSelection.this.parseURL(BoundingBoxSelection.this.parent);
        }
    }

    static class SelectAllOnFocusHandler
    extends FocusAdapter {
        private JTextComponent tfTarget;

        public SelectAllOnFocusHandler(JTextComponent tfTarget) {
            this.tfTarget = tfTarget;
        }

        public void focusGained(FocusEvent e) {
            this.tfTarget.selectAll();
        }
    }

    class LonValueChecker
    extends FocusAdapter
    implements ActionListener {
        private JTextField tfLonValue;

        public LonValueChecker(JTextField tfLonValue) {
            this.tfLonValue = tfLonValue;
        }

        protected void check() {
            double value = 0.0;
            try {
                value = Double.parseDouble(this.tfLonValue.getText());
            }
            catch (NumberFormatException ex) {
                BoundingBoxSelection.this.setErrorMessage(this.tfLonValue, I18n.tr("The string ''{0}'' is not a valid double value.", this.tfLonValue.getText()));
                return;
            }
            if (!LatLon.isValidLon(value)) {
                BoundingBoxSelection.this.setErrorMessage(this.tfLonValue, I18n.tr("Value for longitude in range [-180,180] required.", this.tfLonValue.getText()));
                return;
            }
            BoundingBoxSelection.this.resetErrorMessage(this.tfLonValue);
        }

        public void focusLost(FocusEvent e) {
            this.check();
        }

        public void actionPerformed(ActionEvent e) {
            this.check();
        }
    }

    class LatValueChecker
    extends FocusAdapter
    implements ActionListener {
        private JTextField tfLatValue;

        public LatValueChecker(JTextField tfLatValue) {
            this.tfLatValue = tfLatValue;
        }

        protected void check() {
            double value = 0.0;
            try {
                value = Double.parseDouble(this.tfLatValue.getText());
            }
            catch (NumberFormatException ex) {
                BoundingBoxSelection.this.setErrorMessage(this.tfLatValue, I18n.tr("The string ''{0}'' is not a valid double value.", this.tfLatValue.getText()));
                return;
            }
            if (!LatLon.isValidLat(value)) {
                BoundingBoxSelection.this.setErrorMessage(this.tfLatValue, I18n.tr("Value for latitude in range [-90,90] required.", this.tfLatValue.getText()));
                return;
            }
            BoundingBoxSelection.this.resetErrorMessage(this.tfLatValue);
        }

        public void focusLost(FocusEvent e) {
            this.check();
        }

        public void actionPerformed(ActionEvent e) {
            this.check();
        }
    }
}

