/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class CredentialDialog
extends JDialog {
    private boolean canceled;
    private CredentialPanel pnlCredentials;

    public static CredentialDialog getOsmApiCredentialDialog(String username, String password) {
        CredentialDialog dialog = new CredentialDialog();
        dialog.prepareForOsmApiCredentials(username, password);
        dialog.pack();
        return dialog;
    }

    public static CredentialDialog getHttpProxyCredentialDialog(String username, String password) {
        CredentialDialog dialog = new CredentialDialog();
        dialog.prepareForProxyCredentials(username, password);
        dialog.pack();
        return dialog;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            WindowGeometry.centerInWindow(Main.parent, new Dimension(350, 300)).apply(this);
        }
        super.setVisible(visible);
    }

    protected JPanel createButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout());
        pnl.add(new SideButton(new OKAction()));
        pnl.add(new SideButton(new CancelAction()));
        pnl.add(new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/PasswordDialog"))));
        return pnl;
    }

    protected void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createButtonPanel(), "South");
        this.addWindowListener(new WindowEventHander());
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "escape");
        this.getRootPane().getActionMap().put("escape", new CancelAction());
        this.getRootPane().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public CredentialDialog() {
        this.setModal(true);
        try {
            this.setAlwaysOnTop(true);
        }
        catch (SecurityException e) {
            System.out.println(I18n.tr("Warning: failed to put Credential Dialog always on top. Caught security exception."));
        }
        this.build();
    }

    public void prepareForOsmApiCredentials(String username, String password) {
        this.setTitle(I18n.tr("Enter credentials for OSM API"));
        this.pnlCredentials = new OsmApiCredentialsPanel();
        this.getContentPane().add((Component)this.pnlCredentials, "Center");
        this.pnlCredentials.init(username, password);
        this.validate();
    }

    public void prepareForProxyCredentials(String username, String password) {
        this.setTitle(I18n.tr("Enter credentials for HTTP proxy"));
        this.pnlCredentials = new HttpProxyCredentialsPanel();
        this.getContentPane().add((Component)this.pnlCredentials, "Center");
        this.pnlCredentials.init(username, password);
        this.validate();
    }

    public String getUsername() {
        if (this.pnlCredentials == null) {
            return null;
        }
        return this.pnlCredentials.getUserName();
    }

    public char[] getPassword() {
        if (this.pnlCredentials == null) {
            return null;
        }
        return this.pnlCredentials.getPassword();
    }

    public boolean isSaveCredentials() {
        if (this.pnlCredentials == null) {
            return false;
        }
        return this.pnlCredentials.isSaveCredentials();
    }

    class WindowEventHander
    extends WindowAdapter {
        WindowEventHander() {
        }

        public void windowActivated(WindowEvent e) {
            if (CredentialDialog.this.pnlCredentials != null) {
                CredentialDialog.this.pnlCredentials.startUserInput();
            }
        }

        public void windowClosing(WindowEvent e) {
            new CancelAction().cancel();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("ShortDescription", I18n.tr("Cancel authentication"));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
        }

        public void cancel() {
            CredentialDialog.this.setCanceled(true);
            CredentialDialog.this.setVisible(false);
        }

        public void actionPerformed(ActionEvent arg0) {
            this.cancel();
        }
    }

    class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("Name", I18n.tr("Authenticate"));
            this.putValue("ShortDescription", I18n.tr("Authenticate with the supplied username and password"));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
        }

        public void actionPerformed(ActionEvent arg0) {
            CredentialDialog.this.setCanceled(false);
            CredentialDialog.this.setVisible(false);
        }
    }

    private static class SelectAllOnFocusHandler
    extends FocusAdapter {
        private SelectAllOnFocusHandler() {
        }

        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof JTextField) {
                JTextField tf = (JTextField)e.getSource();
                tf.selectAll();
            }
        }
    }

    private static class HttpProxyCredentialsPanel
    extends CredentialPanel {
        protected void build() {
            super.build();
            this.tfUserName.setToolTipText(I18n.tr("Please enter the user name for authenticating at your proxy server"));
            this.tfPassword.setToolTipText(I18n.tr("Please enter the password for authenticating at your proxy server"));
            this.lblHeading.setText("<html>" + I18n.tr("Authenticating at the HTTP proxy ''{0}'' failed. Please enter a valid username and a valid password.", System.getProperty("http.proxyHost") + ":" + System.getProperty("http.proxyPort")) + "</html>");
            this.lblWarning.setText("<html>" + I18n.tr("Warning: depending on the authentication method the proxy server uses the password may be transferred unencrypted.") + "</html>");
        }

        public HttpProxyCredentialsPanel() {
            this.build();
        }
    }

    private static class OsmApiCredentialsPanel
    extends CredentialPanel {
        protected void build() {
            super.build();
            this.tfUserName.setToolTipText(I18n.tr("Please enter the user name of your OSM account"));
            this.tfPassword.setToolTipText(I18n.tr("Please enter the password of your OSM account"));
            this.lblHeading.setText("<html>" + I18n.tr("Authenticating at the OSM API ''{0}'' failed. Please enter a valid username and a valid password.", OsmApi.getOsmApi().getBaseUrl()) + "</html>");
            this.lblWarning.setText(I18n.tr("Warning: The password is transferred unencrypted."));
        }

        public OsmApiCredentialsPanel() {
            this.build();
        }
    }

    private static class CredentialPanel
    extends JPanel {
        protected JTextField tfUserName;
        protected JPasswordField tfPassword;
        protected JCheckBox cbSaveCredentials;
        protected JMultilineLabel lblHeading;
        protected JMultilineLabel lblWarning;

        protected void build() {
            this.tfUserName = new JTextField(20);
            this.tfPassword = new JPasswordField(20);
            this.tfUserName.addFocusListener(new SelectAllOnFocusHandler());
            this.tfPassword.addFocusListener(new SelectAllOnFocusHandler());
            this.cbSaveCredentials = new JCheckBox(I18n.tr("Save user and password (unencrypted)"));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridwidth = 2;
            gc.gridheight = 1;
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.insets = new Insets(0, 0, 10, 0);
            this.lblHeading = new JMultilineLabel("");
            this.add((Component)this.lblHeading, gc);
            gc.gridx = 0;
            gc.gridy = 1;
            gc.gridwidth = 1;
            gc.gridheight = 1;
            gc.fill = 2;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            gc.insets = new Insets(0, 0, 10, 10);
            this.add((Component)new JLabel(I18n.tr("Username")), gc);
            gc.gridx = 1;
            gc.gridy = 1;
            gc.weightx = 1.0;
            this.add((Component)this.tfUserName, gc);
            gc.gridx = 0;
            gc.gridy = 2;
            gc.weightx = 0.0;
            this.add((Component)new JLabel(I18n.tr("Password")), gc);
            gc.gridx = 1;
            gc.gridy = 2;
            gc.weightx = 0.0;
            this.add((Component)this.tfPassword, gc);
            gc.gridx = 0;
            gc.gridy = 3;
            gc.gridwidth = 2;
            gc.gridheight = 1;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            this.lblWarning = new JMultilineLabel("");
            this.lblWarning.setFont(this.lblWarning.getFont().deriveFont(2));
            this.add((Component)this.lblWarning, gc);
            gc.gridx = 0;
            gc.gridy = 4;
            gc.weighty = 0.0;
            this.add((Component)this.cbSaveCredentials, gc);
            gc.gridx = 0;
            gc.gridy = 5;
            gc.weighty = 1.0;
            this.add((Component)new JPanel(), gc);
        }

        public void init(String username, String password) {
            username = username == null ? "" : username;
            password = password == null ? "" : password;
            this.tfUserName.setText(username);
            this.tfPassword.setText(password);
            this.cbSaveCredentials.setSelected(!username.equals("") && !password.equals(""));
        }

        public void startUserInput() {
            this.tfUserName.requestFocusInWindow();
        }

        public String getUserName() {
            return this.tfUserName.getText();
        }

        public char[] getPassword() {
            return this.tfPassword.getPassword();
        }

        public boolean isSaveCredentials() {
            return this.cbSaveCredentials.isSelected();
        }
    }
}

