/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Icon;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.ImageMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerProducers;
import org.openstreetmap.josm.gui.layer.markerlayer.WebMarker;
import org.openstreetmap.josm.tools.ImageProvider;

public class Marker
implements ActionListener {
    public final String text;
    public final Icon symbol;
    public final MarkerLayer parentLayer;
    public double time;
    public double offset;
    private CachedLatLon coor;
    public static LinkedList<MarkerProducers> markerProducers = new LinkedList();

    public final void setCoor(LatLon coor) {
        if (this.coor == null) {
            this.coor = new CachedLatLon(coor);
        } else {
            this.coor.setCoor(coor);
        }
    }

    public final LatLon getCoor() {
        return this.coor;
    }

    public final void setEastNorth(EastNorth eastNorth) {
        this.coor.setEastNorth(eastNorth);
    }

    public final EastNorth getEastNorth() {
        return this.coor.getEastNorth();
    }

    public Marker(LatLon ll, String text, String iconName, MarkerLayer parentLayer, double time, double offset) {
        this.setCoor(ll);
        this.text = text;
        this.offset = offset;
        this.time = time;
        this.symbol = ImageProvider.getIfAvailable("markers", iconName);
        this.parentLayer = parentLayer;
    }

    public boolean containsPoint(Point p) {
        return false;
    }

    public void actionPerformed(ActionEvent ev) {
    }

    public void paint(Graphics g, MapView mv, boolean mousePressed, boolean showTextOrIcon) {
        Point screen = mv.getPoint(this.getEastNorth());
        if (this.symbol != null && showTextOrIcon) {
            this.symbol.paintIcon(mv, g, screen.x - this.symbol.getIconWidth() / 2, screen.y - this.symbol.getIconHeight() / 2);
        } else {
            g.drawLine(screen.x - 2, screen.y - 2, screen.x + 2, screen.y + 2);
            g.drawLine(screen.x + 2, screen.y - 2, screen.x - 2, screen.y + 2);
        }
        if (this.text != null && showTextOrIcon) {
            g.drawString(this.text, screen.x + 4, screen.y + 2);
        }
    }

    public static Marker createMarker(WayPoint wpt, File relativePath, MarkerLayer parentLayer, double time, double offset) {
        for (MarkerProducers maker : markerProducers) {
            Marker marker = maker.createMarker(wpt, relativePath, parentLayer, time, offset);
            if (marker == null) continue;
            return marker;
        }
        return null;
    }

    public AudioMarker audioMarkerFromMarker(String uri) {
        AudioMarker audioMarker = AudioMarker.create(this.getCoor(), this.text, uri, this.parentLayer, this.time, this.offset);
        return audioMarker;
    }

    static {
        markerProducers.add(new MarkerProducers(){

            public Marker createMarker(WayPoint wpt, File relativePath, MarkerLayer parentLayer, double time, double offset) {
                String uri = null;
                try {
                    Iterator i$ = ((Collection)wpt.attr.get("meta.links")).iterator();
                    if (i$.hasNext()) {
                        GpxLink oneLink = (GpxLink)i$.next();
                        uri = oneLink.uri;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (relativePath != null && uri != null && !this.isWellFormedAddress(uri)) {
                    uri = new File(relativePath.getParentFile(), uri).toURI().toString();
                }
                String name_desc = "";
                if (wpt.attr.containsKey("name")) {
                    name_desc = wpt.getString("name");
                } else if (wpt.attr.containsKey("desc")) {
                    name_desc = wpt.getString("desc");
                }
                if (uri == null) {
                    String symbolName = wpt.getString("symbol");
                    if (symbolName == null) {
                        symbolName = wpt.getString("sym");
                    }
                    return new Marker(wpt.getCoor(), name_desc, symbolName, parentLayer, time, offset);
                }
                if (uri.endsWith(".wav")) {
                    return AudioMarker.create(wpt.getCoor(), name_desc, uri, parentLayer, time, offset);
                }
                if (uri.endsWith(".png") || uri.endsWith(".jpg") || uri.endsWith(".jpeg") || uri.endsWith(".gif")) {
                    return ImageMarker.create(wpt.getCoor(), uri, parentLayer, time, offset);
                }
                return WebMarker.create(wpt.getCoor(), uri, parentLayer, time, offset);
            }

            private boolean isWellFormedAddress(String link) {
                try {
                    new URL(link);
                    return true;
                }
                catch (MalformedURLException x) {
                    return false;
                }
            }
        });
    }
}

