/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleConstants;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPritority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompletingComboBox
extends JComboBox {
    private boolean autocompleteEnabled = true;

    public AutoCompletingComboBox() {
        this.setRenderer(new AutoCompleteListCellRenderer());
        final JTextComponent editor = (JTextComponent)this.getEditor().getEditorComponent();
        editor.setDocument(new AutoCompletingComboBoxDocument(this));
        editor.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                editor.selectAll();
            }
        });
    }

    @Override
    public void configureEditor(ComboBoxEditor editor, Object item) {
        if (item == null) {
            editor.setItem(null);
        } else if (item instanceof String) {
            editor.setItem(item);
        } else if (item instanceof AutoCompletionListItem) {
            editor.setItem(((AutoCompletionListItem)item).getValue());
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item == null) {
            super.setSelectedItem(null);
        } else if (item instanceof AutoCompletionListItem) {
            super.setSelectedItem(item);
        } else if (item instanceof String) {
            String s = (String)item;
            for (int i = 0; i < this.getModel().getSize(); ++i) {
                AutoCompletionListItem acItem = (AutoCompletionListItem)this.getModel().getElementAt(i);
                if (!s.equals(acItem.getValue())) continue;
                super.setSelectedItem(acItem);
                return;
            }
            super.setSelectedItem(new AutoCompletionListItem(s, AutoCompletionItemPritority.UNKNOWN));
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void setPossibleItems(Collection<String> elems) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        Object oldValue = this.getEditor().getItem();
        model.removeAllElements();
        for (String elem : elems) {
            model.addElement(new AutoCompletionListItem(elem, AutoCompletionItemPritority.UNKNOWN));
        }
        this.getEditor().setItem(oldValue);
    }

    public void setPossibleACItems(Collection<AutoCompletionListItem> elems) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        Object oldValue = this.getEditor().getItem();
        model.removeAllElements();
        for (AutoCompletionListItem elem : elems) {
            model.addElement(elem);
        }
        this.getEditor().setItem(oldValue);
    }

    protected boolean isAutocompleteEnabled() {
        return this.autocompleteEnabled;
    }

    protected void setAutocompleteEnabled(boolean autocompleteEnabled) {
        this.autocompleteEnabled = autocompleteEnabled;
    }

    public class AutoCompleteListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public AutoCompleteListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            AutoCompletionListItem item = (AutoCompletionListItem)value;
            this.setText(item.getValue());
            return this;
        }
    }

    class AutoCompletingComboBoxDocument
    extends PlainDocument {
        private JComboBox comboBox;
        private boolean selecting = false;

        public AutoCompletingComboBoxDocument(JComboBox comboBox) {
            this.comboBox = comboBox;
        }

        public void remove(int offs, int len) throws BadLocationException {
            if (this.selecting) {
                return;
            }
            super.remove(offs, len);
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            String newText;
            int start;
            if (this.selecting || offs == 0 && str.equals(this.getText(0, this.getLength()))) {
                return;
            }
            boolean initial = offs == 0 && this.getLength() == 0 && str.length() > 1;
            super.insertString(offs, str, a);
            if (this.selecting) {
                return;
            }
            if (!AutoCompletingComboBox.this.autocompleteEnabled) {
                return;
            }
            if (a != null && a.isDefined(StyleConstants.ComposedTextAttribute)) {
                return;
            }
            int size = this.getLength();
            int end = start = offs + str.length();
            String curText = this.getText(0, size);
            if (Main.pref.getBoolean("autocomplete.dont_complete_numbers", true)) {
                try {
                    Long.parseLong(str);
                    if (curText.length() == 0) {
                        return;
                    }
                    Long.parseLong(curText);
                    return;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            Object item = this.lookupItem(curText);
            this.setSelectedItem(item);
            if (initial) {
                start = 0;
            }
            if (item != null && !(newText = ((AutoCompletionListItem)item).getValue()).equals(curText)) {
                this.selecting = true;
                super.remove(0, size);
                super.insertString(0, newText, a);
                this.selecting = false;
                start = size;
                end = this.getLength();
            }
            JTextComponent editor = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
            editor.setSelectionStart(start);
            editor.setSelectionEnd(end);
        }

        private void setSelectedItem(Object item) {
            this.selecting = true;
            this.comboBox.setSelectedItem(item);
            this.selecting = false;
        }

        private Object lookupItem(String pattern) {
            ComboBoxModel model = this.comboBox.getModel();
            AutoCompletionListItem bestItem = null;
            int n = model.getSize();
            for (int i = 0; i < n; ++i) {
                AutoCompletionListItem currentItem = (AutoCompletionListItem)model.getElementAt(i);
                if (!currentItem.getValue().startsWith(pattern) || bestItem != null && currentItem.getPriority().compareTo(bestItem.getPriority()) <= 0) continue;
                bestItem = currentItem;
            }
            return bestItem;
        }
    }
}

