/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmTransferCancelledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.tools.I18n;

public abstract class OsmServerReader
extends OsmConnection {
    private static final Logger logger = Logger.getLogger(OsmServerReader.class.getName());
    private OsmApi api = OsmApi.getOsmApi();
    private boolean doAuthenticate = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getInputStream(String urlStr, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            this.api.initialize(progressMonitor);
            urlStr = this.api.getBaseUrl() + urlStr;
            InputStream inputStream = this.getInputStreamRaw(urlStr, progressMonitor);
            return inputStream;
        }
        finally {
            progressMonitor.invalidate();
        }
    }

    protected InputStream getInputStreamRaw(String urlStr, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            URL url = null;
            try {
                url = new URL(urlStr.replace(" ", "%20"));
            }
            catch (MalformedURLException e) {
                throw new OsmTransferException(e);
            }
            try {
                this.activeConnection = (HttpURLConnection)url.openConnection();
            }
            catch (Exception e) {
                throw new OsmTransferException(I18n.tr("Failed to open connection to API {0}.", url.toExternalForm()), e);
            }
            if (this.cancel) {
                this.activeConnection.disconnect();
                InputStream e = null;
                return e;
            }
            if (this.doAuthenticate) {
                this.addAuth(this.activeConnection);
            }
            if (this.cancel) {
                throw new OsmTransferCancelledException();
            }
            if (Main.pref.getBoolean("osm-server.use-compression", true)) {
                this.activeConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
            }
            this.activeConnection.setConnectTimeout(15000);
            try {
                System.out.println("GET " + url);
                this.activeConnection.connect();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new OsmTransferException(I18n.tr("Could not connect to the OSM server. Please check your internet connection."), e);
            }
            try {
                if (this.activeConnection.getResponseCode() == 401) {
                    throw new OsmApiException(401, null, null);
                }
                if (this.activeConnection.getResponseCode() == 407) {
                    throw new OsmTransferCancelledException();
                }
                if (this.activeConnection.getResponseCode() != 200) {
                    String errorHeader = this.activeConnection.getHeaderField("Error");
                    InputStream i = null;
                    i = this.activeConnection.getErrorStream();
                    StringBuilder errorBody = new StringBuilder();
                    if (i != null) {
                        String s;
                        BufferedReader in = new BufferedReader(new InputStreamReader(i));
                        while ((s = in.readLine()) != null) {
                            errorBody.append(s);
                            errorBody.append("\n");
                        }
                    }
                    throw new OsmApiException(this.activeConnection.getResponseCode(), errorHeader, errorBody.toString());
                }
                String encoding = this.activeConnection.getContentEncoding();
                InputStream inputStream = new ProgressInputStream(this.activeConnection, progressMonitor);
                if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
                    inputStream = new GZIPInputStream(inputStream);
                } else if (encoding != null && encoding.equalsIgnoreCase("deflate")) {
                    inputStream = new InflaterInputStream(inputStream, new Inflater(true));
                }
                ProgressInputStream progressInputStream = inputStream;
                return progressInputStream;
            }
            catch (Exception e) {
                if (e instanceof OsmTransferException) {
                    throw (OsmTransferException)e;
                }
                throw new OsmTransferException(e);
            }
        }
        finally {
            progressMonitor.invalidate();
        }
    }

    public abstract DataSet parseOsm(ProgressMonitor var1) throws OsmTransferException;

    public boolean isDoAuthenticate() {
        return this.doAuthenticate;
    }

    public void setDoAuthenticate(boolean doAuthenticate) {
        this.doAuthenticate = doAuthenticate;
    }
}

