/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.auth;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.io.CredentialDialog;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.io.auth.CredentialsManagerException;
import org.openstreetmap.josm.io.auth.CredentialsManagerResponse;

public class JosmPreferencesCredentialManager
implements CredentialsManager {
    Map<Authenticator.RequestorType, PasswordAuthentication> memoryCredentialsCache = new HashMap<Authenticator.RequestorType, PasswordAuthentication>();

    public PasswordAuthentication lookup(Authenticator.RequestorType requestorType) throws CredentialsManagerException {
        if (requestorType == null) {
            return null;
        }
        switch (requestorType) {
            case SERVER: {
                String user = Main.pref.get("osm-server.username", null);
                String password = Main.pref.get("osm-server.password", null);
                if (user == null) {
                    return null;
                }
                return new PasswordAuthentication(user, password == null ? new char[]{} : password.toCharArray());
            }
            case PROXY: {
                String user = Main.pref.get("proxy.user", null);
                String password = Main.pref.get("proxy.pass", null);
                if (user == null) {
                    return null;
                }
                return new PasswordAuthentication(user, password == null ? null : password.toCharArray());
            }
        }
        return null;
    }

    public void store(Authenticator.RequestorType requestorType, PasswordAuthentication credentials) throws CredentialsManagerException {
        if (requestorType == null) {
            return;
        }
        switch (requestorType) {
            case SERVER: {
                Main.pref.put("osm-server.username", credentials.getUserName());
                if (credentials.getPassword() == null) {
                    Main.pref.put("osm-server.password", null);
                    break;
                }
                Main.pref.put("osm-server.password", String.valueOf(credentials.getPassword()));
                break;
            }
            case PROXY: {
                Main.pref.put("proxy.user", credentials.getUserName());
                if (credentials.getPassword() == null) {
                    Main.pref.put("proxy.pass", null);
                    break;
                }
                Main.pref.put("proxy.pass", String.valueOf(credentials.getPassword()));
            }
        }
    }

    public CredentialsManagerResponse getCredentials(Authenticator.RequestorType requestorType, boolean noSuccessWithLastResponse) throws CredentialsManagerException {
        if (requestorType == null) {
            return null;
        }
        PasswordAuthentication credentials = this.lookup(requestorType);
        String username = credentials == null || credentials.getUserName() == null ? "" : credentials.getUserName();
        String password = credentials == null || credentials.getPassword() == null ? "" : String.valueOf(credentials.getPassword());
        CredentialsManagerResponse response = new CredentialsManagerResponse();
        if (!noSuccessWithLastResponse && credentials == null && this.memoryCredentialsCache.containsKey((Object)requestorType)) {
            PasswordAuthentication pa = this.memoryCredentialsCache.get((Object)requestorType);
            response.setUsername(pa.getUserName());
            response.setPassword(pa.getPassword());
            response.setCanceled(false);
        } else if (noSuccessWithLastResponse || username.equals("") || password.equals("")) {
            CredentialDialog dialog = null;
            switch (requestorType) {
                case SERVER: {
                    dialog = CredentialDialog.getOsmApiCredentialDialog(username, password);
                    break;
                }
                case PROXY: {
                    dialog = CredentialDialog.getHttpProxyCredentialDialog(username, password);
                }
            }
            dialog.setVisible(true);
            response.setCanceled(dialog.isCanceled());
            if (dialog.isCanceled()) {
                return response;
            }
            response.setUsername(dialog.getUsername());
            response.setPassword(dialog.getPassword());
            if (dialog.isSaveCredentials()) {
                this.store(requestorType, new PasswordAuthentication(response.getUsername(), response.getPassword()));
            } else {
                PasswordAuthentication pa = new PasswordAuthentication(dialog.getUsername(), dialog.getPassword());
                this.memoryCredentialsCache.put(requestorType, pa);
            }
        } else {
            response.setUsername(username);
            response.setPassword(password.toCharArray());
            response.setCanceled(false);
        }
        return response;
    }

    public OAuthToken lookupOAuthAccessToken() throws CredentialsManagerException {
        String accessTokenKey = Main.pref.get("oauth.access-token.key", null);
        String accessTokenSecret = Main.pref.get("oauth.access-token.secret", null);
        if (accessTokenKey == null && accessTokenSecret == null) {
            return null;
        }
        return new OAuthToken(accessTokenKey, accessTokenSecret);
    }

    public void storeOAuthAccessToken(OAuthToken accessToken) throws CredentialsManagerException {
        if (accessToken == null) {
            Main.pref.put("oauth.access-token.key", null);
            Main.pref.put("oauth.access-token.secret", null);
        } else {
            Main.pref.put("oauth.access-token.key", accessToken.getKey());
            Main.pref.put("oauth.access-token.secret", accessToken.getSecret());
        }
    }
}

