/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginPreferenceFactory;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.plugins.ReadLocalPluginInformationTask;
import org.openstreetmap.josm.plugins.ReadRemotePluginInformationTask;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginHandler {
    public static final String[] DEPRECATED_PLUGINS = new String[]{"mappaint", "unglueplugin", "lang-de", "lang-en_GB", "lang-fr", "lang-it", "lang-pl", "lang-ro", "lang-ru", "ewmsplugin", "ywms", "tways-0.2", "geotagged", "landsat", "namefinder", "waypoints", "slippy_map_chooser", "tcx-support", "usertools", "AgPifoJ", "utilsplugin"};
    public static final String[] UNMAINTAINED_PLUGINS = new String[]{"gpsbabelgui", "Intersect_way"};
    public static final Collection<PluginProxy> pluginList = new LinkedList<PluginProxy>();

    private static void filterDeprecatedPlugins(Window parent, Collection<String> plugins) {
        HashSet<String> removedPlugins = new HashSet<String>();
        for (String p : DEPRECATED_PLUGINS) {
            if (!plugins.contains(p)) continue;
            plugins.remove(p);
            Main.pref.removeFromCollection("plugins", p);
            removedPlugins.add(p);
        }
        if (removedPlugins.isEmpty()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append(I18n.trn("The following plugin is no longer necessary and has been deactivated:", "The following plugins are no longer necessary and have been deactivated:", removedPlugins.size()));
        sb.append("<ul>");
        for (String name : removedPlugins) {
            sb.append("<li>").append(name).append("</li>");
        }
        sb.append("</ul>");
        sb.append("</html>");
        JOptionPane.showMessageDialog(parent, sb.toString(), I18n.tr("Warning"), 2);
    }

    private static void filterUnmaintainedPlugins(Window parent, Collection<String> plugins) {
        for (String unmaintained : UNMAINTAINED_PLUGINS) {
            if (!plugins.contains(unmaintained)) continue;
            String msg = I18n.tr("<html>Loading of the plugin \"{0}\" was requested.<br>This plugin is no longer developed and very likely will produce errors.<br>It should be disabled.<br>Delete from preferences?</html>", unmaintained);
            if (!PluginHandler.confirmDisablePlugin(parent, msg, unmaintained)) continue;
            Main.pref.removeFromCollection("plugins", unmaintained);
            plugins.remove(unmaintained);
        }
    }

    public static boolean checkAndConfirmPluginUpdate(Window parent) {
        String message = null;
        String togglePreferenceKey = null;
        int v = Version.getInstance().getVersion();
        if (Main.pref.getInteger("pluginmanager.version", 0) < v) {
            message = "<html>" + I18n.tr("You updated your JOSM software.<br>To prevent problems the plugins should be updated as well.<br><br>Update plugins now?") + "</html>";
            togglePreferenceKey = "pluginmanager.version-based-update.policy";
        } else {
            long tim = System.currentTimeMillis();
            long last = Main.pref.getLong("pluginmanager.lastupdate", 0L);
            Integer maxTime = Main.pref.getInteger("pluginmanager.time-based-update.interval", 60);
            long d = (tim - last) / 86400000L;
            if (last <= 0L || maxTime <= 0) {
                Main.pref.put("pluginmanager.lastupdate", Long.toString(tim));
            } else if (d > (long)maxTime.intValue()) {
                message = "<html>" + I18n.tr("Last plugin update more than {0} days ago.", d) + "</html>";
                togglePreferenceKey = "pluginmanager.time-based-update.policy";
            }
        }
        if (message == null) {
            return false;
        }
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Update plugins"), ImageProvider.get("dialogs", "refresh"), I18n.tr("Click to update the activated plugins"), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Skip update"), ImageProvider.get("cancel"), I18n.tr("Click to skip updating the activated plugins"), null)};
        UpdatePluginsMessagePanel pnlMessage = new UpdatePluginsMessagePanel();
        pnlMessage.setMessage(message);
        pnlMessage.initDontShowAgain(togglePreferenceKey);
        String policy = Main.pref.get(togglePreferenceKey, "ask");
        policy = policy.trim().toLowerCase();
        if (policy.equals("never")) {
            if ("pluginmanager.version-based-update.policy".equals(togglePreferenceKey)) {
                System.out.println(I18n.tr("Skipping plugin update after JOSM upgrade. Automatic update at startup is disabled."));
            } else if ("pluginmanager.time-based-update.policy".equals(togglePreferenceKey)) {
                System.out.println(I18n.tr("Skipping plugin update after elapsed update interval. Automatic update at startup is disabled."));
            }
            return false;
        }
        if (policy.equals("always")) {
            if ("pluginmanager.time-based-update.policy".equals(togglePreferenceKey)) {
                System.out.println(I18n.tr("Running plugin update after JOSM upgrade. Automatic update at startup is enabled."));
            } else if ("pluginmanager.time-based-update.policy".equals(togglePreferenceKey)) {
                System.out.println(I18n.tr("Running plugin update after elapsed update interval. Automatic update at startup is disabled."));
            }
            return true;
        }
        if (!policy.equals("ask")) {
            System.err.println(I18n.tr("Unexpected value ''{0}'' for preference ''{1}''. Assuming value ''ask''.", policy, togglePreferenceKey));
        }
        int ret = HelpAwareOptionPane.showOptionDialog(parent, pnlMessage, I18n.tr("Update plugins"), 2, null, options, options[0], HelpUtil.ht("/Preferences/Plugins#AutomaticUpdate"));
        if (pnlMessage.isRememberDecision()) {
            switch (ret) {
                case 0: {
                    Main.pref.put(togglePreferenceKey, "always");
                    break;
                }
                case -1: 
                case 1: {
                    Main.pref.put(togglePreferenceKey, "never");
                }
            }
        } else {
            Main.pref.put(togglePreferenceKey, "ask");
        }
        return ret == 0;
    }

    private static void alertMissingRequiredPlugin(Window parent, String plugin, Set<String> missingRequiredPlugin) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(I18n.trn("Plugin {0} requires a plugin which was not found. The missing plugin is:", "Plugin {0} requires {1} plugins which were not found. The missing plugins are:", missingRequiredPlugin.size(), plugin, missingRequiredPlugin.size()));
        sb.append("<ul>");
        for (String p : missingRequiredPlugin) {
            sb.append("<li>").append(p).append("</li>");
        }
        sb.append("</ul>").append("</html>");
        JOptionPane.showMessageDialog(parent, sb.toString(), I18n.tr("Error"), 0);
    }

    private static void alertJOSMUpdateRequired(Window parent, String plugin, int requiredVersion) {
        HelpAwareOptionPane.showOptionDialog(parent, I18n.tr("<html>Plugin {0} requires JOSM version {1}. The current JOSM version is {2}.<br>You have to update JOSM in order to use this plugin.</html>", plugin, requiredVersion, Version.getInstance().getVersion()), I18n.tr("Warning"), 2, HelpUtil.ht("/Plugin/Loading#JOSMUpdateRequired"));
    }

    public static boolean checkLoadPreconditions(Window parent, Collection<PluginInformation> plugins, PluginInformation plugin) {
        int josmVersion = Version.getInstance().getVersion();
        if (plugin.mainversion > josmVersion && josmVersion != 0) {
            PluginHandler.alertJOSMUpdateRequired(parent, plugin.name, plugin.mainversion);
            return false;
        }
        if (plugin.requires != null) {
            HashSet<String> pluginNames = new HashSet<String>();
            for (PluginInformation pi : plugins) {
                pluginNames.add(pi.name);
            }
            HashSet<String> missingPlugins = new HashSet<String>();
            for (String requiredPlugin : plugin.requires.split(";")) {
                if (pluginNames.contains(requiredPlugin)) continue;
                missingPlugins.add(requiredPlugin);
            }
            if (!missingPlugins.isEmpty()) {
                PluginHandler.alertMissingRequiredPlugin(parent, plugin.name, missingPlugins);
                return false;
            }
        }
        return true;
    }

    public static ClassLoader createClassLoader(Collection<PluginInformation> plugins) {
        LinkedList<URL> allPluginLibraries = new LinkedList<URL>();
        File pluginDir = Main.pref.getPluginsDirectory();
        for (PluginInformation info : plugins) {
            if (info.libraries == null) continue;
            allPluginLibraries.addAll(info.libraries);
            File pluginJar = new File(pluginDir, info.name + ".jar");
            URL pluginJarUrl = PluginInformation.fileToURL(pluginJar);
            allPluginLibraries.add(pluginJarUrl);
        }
        URL[] jarUrls = new URL[allPluginLibraries.size()];
        jarUrls = allPluginLibraries.toArray(jarUrls);
        URLClassLoader pluginClassLoader = new URLClassLoader(jarUrls, Main.class.getClassLoader());
        return pluginClassLoader;
    }

    public static void loadPlugin(Window parent, PluginInformation plugin, ClassLoader pluginClassLoader) {
        String msg = I18n.tr("Could not load plugin {0}. Delete from preferences?", plugin.name);
        try {
            Class<?> klass = plugin.loadClass(pluginClassLoader);
            if (klass != null) {
                System.out.println(I18n.tr("loading plugin ''{0}'' (version {1})", plugin.name, plugin.localversion));
                pluginList.add(plugin.load(klass));
            }
            msg = null;
        }
        catch (PluginException e) {
            e.printStackTrace();
            if (e.getCause() instanceof ClassNotFoundException) {
                msg = I18n.tr("<html>Could not load plugin {0} because the plugin<br>main class ''{1}'' was not found.<br>Delete from preferences?", plugin.name, plugin.className);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (msg != null && PluginHandler.confirmDisablePlugin(parent, msg, plugin.name)) {
            Main.pref.removeFromCollection("plugins", plugin.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPlugins(Window parent, Collection<PluginInformation> plugins, ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask(I18n.tr("Loading plugins ..."));
            monitor.subTask(I18n.tr("Checking plugin preconditions..."));
            LinkedList<PluginInformation> toLoad = new LinkedList<PluginInformation>();
            for (PluginInformation pi : plugins) {
                if (!PluginHandler.checkLoadPreconditions(parent, plugins, pi)) continue;
                toLoad.add(pi);
            }
            Collections.sort(toLoad, new Comparator<PluginInformation>(){

                @Override
                public int compare(PluginInformation o1, PluginInformation o2) {
                    if (o1.stage < o2.stage) {
                        return -1;
                    }
                    if (o1.stage == o2.stage) {
                        return 0;
                    }
                    return 1;
                }
            });
            if (toLoad.isEmpty()) {
                return;
            }
            ClassLoader pluginClassLoader = PluginHandler.createClassLoader(toLoad);
            ImageProvider.sources.add(0, pluginClassLoader);
            monitor.setTicksCount(toLoad.size());
            for (PluginInformation info : toLoad) {
                monitor.setExtraText(I18n.tr("Loading plugin ''{0}''...", info.name));
                PluginHandler.loadPlugin(parent, info, pluginClassLoader);
                monitor.worked(1);
            }
        }
        finally {
            monitor.finishTask();
        }
    }

    public static void loadEarlyPlugins(Window parent, Collection<PluginInformation> plugins, ProgressMonitor monitor) {
        ArrayList<PluginInformation> earlyPlugins = new ArrayList<PluginInformation>(plugins.size());
        for (PluginInformation pi : plugins) {
            if (!pi.early) continue;
            earlyPlugins.add(pi);
        }
        PluginHandler.loadPlugins(parent, earlyPlugins, monitor);
    }

    public static void loadLatePlugins(Window parent, Collection<PluginInformation> plugins, ProgressMonitor monitor) {
        ArrayList<PluginInformation> latePlugins = new ArrayList<PluginInformation>(plugins.size());
        for (PluginInformation pi : plugins) {
            if (pi.early) continue;
            latePlugins.add(pi);
        }
        PluginHandler.loadPlugins(parent, latePlugins, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Map<String, PluginInformation> loadLocallyAvailablePluginInformation(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            ReadLocalPluginInformationTask task = new ReadLocalPluginInformationTask(monitor);
            ExecutorService service = Executors.newSingleThreadExecutor();
            Future<?> future = service.submit(task);
            try {
                future.get();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                Map<String, PluginInformation> map = null;
                monitor.finishTask();
                return map;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Map<String, PluginInformation> map = null;
                monitor.finishTask();
                return map;
            }
            HashMap<String, PluginInformation> ret = new HashMap<String, PluginInformation>();
            for (PluginInformation pi : task.getAvailablePlugins()) {
                ret.put(pi.name, pi);
            }
            HashMap<String, PluginInformation> hashMap = ret;
            return hashMap;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            monitor.finishTask();
        }
    }

    private static void alertMissingPluginInformation(Window parent, Collection<String> plugins) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(I18n.trn("JOSM could not find information about the following plugin:", "JOSM could not find information about the following plugins:", plugins.size()));
        sb.append("<ul>");
        for (String plugin : plugins) {
            sb.append("<li>").append(plugin).append("</li>");
        }
        sb.append("</ul>");
        sb.append(I18n.trn("The plugin is not going to be loaded.", "The plugins are not going to be loaded.", plugins.size()));
        sb.append("</html>");
        HelpAwareOptionPane.showOptionDialog(parent, sb.toString(), I18n.tr("Warning"), 2, HelpUtil.ht("/Plugin/Loading#MissingPluginInfos"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PluginInformation> buildListOfPluginsToLoad(Window parent, ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask(I18n.tr("Determine plugins to load..."));
            HashSet<String> plugins = new HashSet<String>();
            plugins.addAll(Main.pref.getCollection("plugins", new LinkedList<String>()));
            if (System.getProperty("josm.plugins") != null) {
                plugins.addAll(Arrays.asList(System.getProperty("josm.plugins").split(",")));
            }
            monitor.subTask(I18n.tr("Removing deprecated plugins..."));
            PluginHandler.filterDeprecatedPlugins(parent, plugins);
            monitor.subTask(I18n.tr("Removing unmaintained plugins..."));
            PluginHandler.filterUnmaintainedPlugins(parent, plugins);
            Map<String, PluginInformation> infos = PluginHandler.loadLocallyAvailablePluginInformation(monitor.createSubTaskMonitor(1, false));
            LinkedList<PluginInformation> ret = new LinkedList<PluginInformation>();
            Iterator it = plugins.iterator();
            while (it.hasNext()) {
                String plugin = (String)it.next();
                if (!infos.containsKey(plugin)) continue;
                ret.add(infos.get(plugin));
                it.remove();
            }
            if (!plugins.isEmpty()) {
                PluginHandler.alertMissingPluginInformation(parent, plugins);
            }
            LinkedList<PluginInformation> linkedList = ret;
            return linkedList;
        }
        finally {
            monitor.finishTask();
        }
    }

    private static void alertFailedPluginUpdate(Window parent, Collection<PluginInformation> plugins) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append(I18n.trn("Updating the following plugin has failed:", "Updating the following plugins has failed:", plugins.size()));
        sb.append("<ul>");
        for (PluginInformation pi : plugins) {
            sb.append("<li>").append(pi.name).append("</li>");
        }
        sb.append("</ul>");
        sb.append(I18n.trn("Please open the Preference Dialog after JOSM has started and try to update it manually.", "Please open the Preference Dialog after JOSM has started and try to update them manually.", plugins.size()));
        sb.append("</html>");
        HelpAwareOptionPane.showOptionDialog(parent, sb.toString(), I18n.tr("Plugin update failed"), 0, HelpUtil.ht("/Plugin/Loading#FailedPluginUpdated"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static List<PluginInformation> updatePlugins(Window parent, List<PluginInformation> plugins, ProgressMonitor monitor) throws IllegalArgumentException {
        block14: {
            CheckParameterUtil.ensureParameterNotNull(plugins, "plugins");
            if (monitor == null) {
                monitor = NullProgressMonitor.INSTANCE;
            }
            try {
                monitor.beginTask("");
                ExecutorService service = Executors.newSingleThreadExecutor();
                ReadRemotePluginInformationTask task1 = new ReadRemotePluginInformationTask(monitor.createSubTaskMonitor(1, false), Main.pref.getPluginSites());
                Future<?> future = service.submit(task1);
                try {
                    future.get();
                    plugins = PluginHandler.buildListOfPluginsToLoad(parent, monitor.createSubTaskMonitor(1, false));
                }
                catch (ExecutionException e) {
                    System.out.println(I18n.tr("Warning: failed to download plugin information list"));
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    System.out.println(I18n.tr("Warning: failed to download plugin information list"));
                    e.printStackTrace();
                }
                ArrayList<PluginInformation> pluginsToUpdate = new ArrayList<PluginInformation>();
                for (PluginInformation pi : plugins) {
                    if (!pi.isUpdateRequired()) continue;
                    pluginsToUpdate.add(pi);
                }
                if (pluginsToUpdate.isEmpty()) break block14;
                PluginDownloadTask task2 = new PluginDownloadTask(monitor.createSubTaskMonitor(1, false), pluginsToUpdate, I18n.tr("Update plugins"));
                future = service.submit(task2);
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    PluginHandler.alertFailedPluginUpdate(parent, pluginsToUpdate);
                    List<PluginInformation> list = plugins;
                    monitor.finishTask();
                    return list;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    PluginHandler.alertFailedPluginUpdate(parent, pluginsToUpdate);
                    List<PluginInformation> list = plugins;
                    monitor.finishTask();
                    return list;
                }
                if (!task2.getFailedPlugins().isEmpty()) {
                    PluginHandler.alertFailedPluginUpdate(parent, task2.getFailedPlugins());
                    List<PluginInformation> list = plugins;
                    return list;
                }
                break block14;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                monitor.finishTask();
            }
        }
        Main.pref.putInteger("pluginmanager.version", Version.getInstance().getVersion());
        Main.pref.put("pluginmanager.lastupdate", Long.toString(System.currentTimeMillis()));
        return plugins;
    }

    public static boolean confirmDisablePlugin(Window parent, String reason, String name) {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Disable plugin"), ImageProvider.get("dialogs", "delete"), I18n.tr("Click to delete the plugin ''{0}''", name), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Keep plugin"), ImageProvider.get("cancel"), I18n.tr("Click to keep the plugin ''{0}''", name), null)};
        int ret = HelpAwareOptionPane.showOptionDialog(parent, reason, I18n.tr("Disable plugin"), 2, null, options, options[0], null);
        return ret == 0;
    }

    public static void notifyMapFrameChanged(MapFrame old, MapFrame map) {
        for (PluginProxy plugin : pluginList) {
            plugin.mapFrameInitialized(old, map);
        }
    }

    public static Object getPlugin(String name) {
        for (PluginProxy plugin : pluginList) {
            if (!plugin.getPluginInformation().name.equals(name)) continue;
            return plugin.plugin;
        }
        return null;
    }

    public static void addDownloadSelection(List<DownloadSelection> downloadSelections) {
        for (PluginProxy p : pluginList) {
            p.addDownloadSelection(downloadSelections);
        }
    }

    public static void getPreferenceSetting(Collection<PreferenceSettingFactory> settings) {
        for (PluginProxy plugin : pluginList) {
            settings.add(new PluginPreferenceFactory(plugin));
        }
    }

    public static void installDownloadedPlugins(boolean dowarn) {
        File[] files;
        File pluginDir = Main.pref.getPluginsDirectory();
        if (!(pluginDir.exists() && pluginDir.isDirectory() && pluginDir.canWrite())) {
            return;
        }
        for (File updatedPlugin : files = pluginDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar.new");
            }
        })) {
            String filePath = updatedPlugin.getPath();
            File plugin = new File(filePath.substring(0, filePath.length() - 4));
            String pluginName = updatedPlugin.getName().substring(0, updatedPlugin.getName().length() - 8);
            if (plugin.exists() && !plugin.delete() && dowarn) {
                System.err.println(I18n.tr("Warning: failed to delete outdated plugin ''{0}''.", plugin.toString()));
                System.err.println(I18n.tr("Warning: failed to install already downloaded plugin ''{0}''. Skipping installation. JOSM is still going to load the old plugin version.", pluginName));
                continue;
            }
            if (updatedPlugin.renameTo(plugin) || !dowarn) continue;
            System.err.println(I18n.tr("Warning: failed to install plugin ''{0}'' from temporary download file ''{1}''. Renaming failed.", plugin.toString(), updatedPlugin.toString()));
            System.err.println(I18n.tr("Warning: failed to install already downloaded plugin ''{0}''. Skipping installation. JOSM is still going to load the old plugin version.", pluginName));
        }
    }

    private static boolean confirmDeactivatingPluginAfterException(PluginProxy plugin) {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Disable plugin"), ImageProvider.get("dialogs", "delete"), I18n.tr("Click to disable the plugin ''{0}''", plugin.getPluginInformation().name), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Keep plugin"), ImageProvider.get("cancel"), I18n.tr("Click to keep the plugin ''{0}''", plugin.getPluginInformation().name), null)};
        StringBuffer msg = new StringBuffer();
        msg.append("<html>");
        msg.append(I18n.tr("An unexpected exception occurred that may have come from the ''{0}'' plugin.", plugin.getPluginInformation().name));
        msg.append("<br>");
        if (plugin.getPluginInformation().author != null) {
            msg.append(I18n.tr("According to the information within the plugin, the author is {0}.", plugin.getPluginInformation().author));
            msg.append("<br>");
        }
        msg.append(I18n.tr("Try updating to the newest version of this plugin before reporting a bug."));
        msg.append("<br>");
        msg.append(I18n.tr("Should the plugin be disabled?"));
        msg.append("</html>");
        int ret = HelpAwareOptionPane.showOptionDialog(Main.parent, msg.toString(), I18n.tr("Update plugins"), 3, null, options, options[0], HelpUtil.ht("/ErrorMessages#ErrorInPlugin"));
        return ret == 0;
    }

    private static PluginProxy getPluginCausingException(Throwable ex) {
        for (PluginProxy p : pluginList) {
            String baseClass = p.getPluginInformation().className;
            int i = baseClass.lastIndexOf(".");
            baseClass = baseClass.substring(0, i);
            for (StackTraceElement element : ex.getStackTrace()) {
                String c = element.getClassName();
                if (!c.startsWith(baseClass)) continue;
                return p;
            }
        }
        return null;
    }

    public static void disablePluginAfterException(Throwable e) {
        PluginProxy plugin = null;
        if (e instanceof PluginException) {
            plugin = ((PluginException)e).plugin;
        }
        if (plugin == null) {
            plugin = PluginHandler.getPluginCausingException(e);
        }
        if (plugin == null) {
            return;
        }
        HashSet<String> plugins = new HashSet<String>(Main.pref.getCollection("plugins", Collections.<String>emptySet()));
        if (!plugins.contains(plugin.getPluginInformation().name)) {
            return;
        }
        if (!PluginHandler.confirmDeactivatingPluginAfterException(plugin)) {
            return;
        }
        plugins.remove(plugin.getPluginInformation().name);
        Main.pref.putCollection("plugins", plugins);
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("The plugin has been removed from the configuration. Please restart JOSM to unload the plugin."), I18n.tr("Information"), 1);
    }

    public static String getBugReportText() {
        String text = "";
        LinkedList<String> pl = new LinkedList<String>(Main.pref.getCollection("plugins", new LinkedList<String>()));
        for (PluginProxy pp : pluginList) {
            PluginInformation pi = pp.getPluginInformation();
            pl.remove(pi.name);
            pl.add(pi.name + " (" + (pi.localversion != null && !pi.localversion.equals("") ? pi.localversion : "unknown") + ")");
        }
        Collections.sort(pl);
        for (String s : pl) {
            text = text + "Plugin: " + s + "\n";
        }
        return text;
    }

    public static JPanel getInfoPanel() {
        JPanel pluginTab = new JPanel(new GridBagLayout());
        for (PluginProxy p : pluginList) {
            final PluginInformation info = p.getPluginInformation();
            String name = info.name + (info.version != null && !info.version.equals("") ? " Version: " + info.version : "");
            pluginTab.add((Component)new JLabel(name), GBC.std());
            pluginTab.add(Box.createHorizontalGlue(), GBC.std().fill(2));
            pluginTab.add((Component)new JButton(new AbstractAction(I18n.tr("Information")){

                public void actionPerformed(ActionEvent event) {
                    StringBuilder b = new StringBuilder();
                    for (Map.Entry<String, String> e : info.attr.entrySet()) {
                        b.append(e.getKey());
                        b.append(": ");
                        b.append(e.getValue());
                        b.append("\n");
                    }
                    JTextArea a = new JTextArea(10, 40);
                    a.setEditable(false);
                    a.setText(b.toString());
                    JOptionPane.showMessageDialog(Main.parent, new JScrollPane(a), I18n.tr("Plugin information"), 1);
                }
            }), GBC.eol());
            JTextArea description = new JTextArea(info.description == null ? I18n.tr("no description available") : info.description);
            description.setEditable(false);
            description.setFont(new JLabel().getFont().deriveFont(2));
            description.setLineWrap(true);
            description.setWrapStyleWord(true);
            description.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            description.setBackground(UIManager.getColor("Panel.background"));
            pluginTab.add((Component)description, GBC.eop().fill(2));
        }
        return pluginTab;
    }

    private static class UpdatePluginsMessagePanel
    extends JPanel {
        private JMultilineLabel lblMessage;
        private JCheckBox cbDontShowAgain;

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.insets = new Insets(5, 5, 5, 5);
            this.lblMessage = new JMultilineLabel("");
            this.add((Component)this.lblMessage, gc);
            this.lblMessage.setFont(this.lblMessage.getFont().deriveFont(0));
            gc.gridy = 1;
            gc.fill = 2;
            gc.weighty = 0.0;
            this.cbDontShowAgain = new JCheckBox(I18n.tr("Do not ask again and remember my decision (go to Preferences->Plugins to change it later)"));
            this.add((Component)this.cbDontShowAgain, gc);
            this.cbDontShowAgain.setFont(this.cbDontShowAgain.getFont().deriveFont(0));
        }

        public UpdatePluginsMessagePanel() {
            this.build();
        }

        public void setMessage(String message) {
            this.lblMessage.setText(message);
        }

        public void initDontShowAgain(String preferencesKey) {
            String policy = Main.pref.get(preferencesKey, "ask");
            this.cbDontShowAgain.setSelected(!(policy = policy.trim().toLowerCase()).equals("ask"));
        }

        public boolean isRememberDecision() {
            return this.cbDontShowAgain.isSelected();
        }
    }
}

