/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.event;

import com.sun.jmx.remote.util.ClassLogger;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    private final String nameTemplate;
    private final ThreadGroup threadGroup;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private static final ClassLogger logger = new ClassLogger("com.sun.jmx.event", "DaemonThreadFactory");

    public DaemonThreadFactory(String string) {
        this(string, null);
    }

    public DaemonThreadFactory(String string, ThreadGroup threadGroup) {
        if (logger.debugOn()) {
            logger.debug("DaemonThreadFactory", "Construct a new daemon factory: " + string);
        }
        if (threadGroup == null) {
            SecurityManager securityManager = System.getSecurityManager();
            threadGroup = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }
        this.nameTemplate = string;
        this.threadGroup = threadGroup;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String string = String.format(this.nameTemplate, this.threadNumber.getAndIncrement());
        Thread thread = new Thread(this.threadGroup, runnable, string, 0L);
        thread.setDaemon(true);
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        if (logger.debugOn()) {
            logger.debug("newThread", "Create a new daemon thread with the name " + thread.getName());
        }
        return thread;
    }
}

