/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XmlDataContentHandler
implements DataContentHandler {
    private final DataFlavor[] flavors = new DataFlavor[2];

    public XmlDataContentHandler() throws ClassNotFoundException {
        this.flavors[0] = new ActivationDataFlavor(StreamSource.class, "text/xml", "XML");
        this.flavors[1] = new ActivationDataFlavor(StreamSource.class, "application/xml", "XML");
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public Object getTransferData(DataFlavor df, DataSource ds) throws IOException {
        for (DataFlavor aFlavor : this.flavors) {
            if (!aFlavor.equals(df)) continue;
            return this.getContent(ds);
        }
        return null;
    }

    @Override
    public Object getContent(DataSource dataSource) throws IOException {
        return new StreamSource(dataSource.getInputStream());
    }

    @Override
    public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
        if (!mimeType.equals("text/xml") && !mimeType.equals("application/xml")) {
            throw new IOException("Invalid content type \"" + mimeType + "\" for XmlDCH");
        }
        try {
            Transformer transformer = XmlUtil.newTransformer();
            StreamResult result = new StreamResult(os);
            if (obj instanceof DataSource) {
                transformer.transform((Source)this.getContent((DataSource)obj), result);
            } else {
                transformer.transform((Source)obj, result);
            }
        }
        catch (Exception ex) {
            throw new IOException("Unable to run the JAXP transformer on a stream " + ex.getMessage());
        }
    }
}

