/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.Attributes;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Set;
import sun.nio.fs.BasicFileAttributesHolder;

class FileTreeWalker {
    private final boolean followLinks;
    private final boolean detectCycles;
    private final LinkOption[] linkOptions;
    private final FileVisitor<? super Path> visitor;

    FileTreeWalker(Set<FileVisitOption> set, FileVisitor<? super Path> fileVisitor) {
        LinkOption[] linkOptionArray;
        boolean bl = false;
        boolean bl2 = false;
        block4: for (FileVisitOption fileVisitOption : set) {
            switch (fileVisitOption) {
                case FOLLOW_LINKS: {
                    bl = true;
                    continue block4;
                }
                case DETECT_CYCLES: {
                    bl2 = true;
                    continue block4;
                }
            }
            throw new AssertionError((Object)"Should not get here");
        }
        this.followLinks = bl;
        this.detectCycles = bl | bl2;
        if (bl) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        this.linkOptions = linkOptionArray;
        this.visitor = fileVisitor;
    }

    void walk(Path path, int n) {
        FileVisitResult fileVisitResult;
        if (path instanceof BasicFileAttributesHolder) {
            ((BasicFileAttributesHolder)((Object)path)).invalidate();
        }
        if ((fileVisitResult = this.walk(path, n, new ArrayList<AncestorDirectory>())) == null) {
            throw new NullPointerException("Visitor returned 'null'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FileVisitResult walk(Path var1_1, int var2_2, List<AncestorDirectory> var3_3) {
        block50: {
            if (var2_2-- < 0) {
                return FileVisitResult.CONTINUE;
            }
            var4_4 = null;
            if (var1_1 instanceof BasicFileAttributesHolder) {
                var5_5 = ((BasicFileAttributesHolder)var1_1).get();
                if (!this.followLinks || !var5_5.isSymbolicLink()) {
                    var4_4 = var5_5;
                }
            }
            var5_5 = null;
            if (var4_4 == null) {
                try {
                    try {
                        var4_4 = Attributes.readBasicFileAttributes(var1_1, this.linkOptions);
                    }
                    catch (IOException var6_6) {
                        if (this.followLinks) {
                            try {
                                var4_4 = Attributes.readBasicFileAttributes(var1_1, new LinkOption[]{LinkOption.NOFOLLOW_LINKS});
                            }
                            catch (IOException var7_9) {
                                var5_5 = var7_9;
                            }
                            break block50;
                        }
                        var5_5 = var6_6;
                    }
                }
                catch (SecurityException var6_7) {
                    return FileVisitResult.CONTINUE;
                }
            }
        }
        if (var5_5 != null) {
            return this.visitor.visitFileFailed(var1_1, (IOException)var5_5);
        }
        if (!var4_4.isDirectory()) {
            return this.visitor.visitFile(var1_1, var4_4);
        }
        if (this.detectCycles) {
            var6_8 = var4_4.fileKey();
            for (AncestorDirectory var8_11 : var3_3) {
                var9_17 /* !! */  = var8_11.fileKey();
                if (var6_8 != null && var9_17 /* !! */  != null) {
                    if (!var6_8.equals((Object)var9_17 /* !! */ )) continue;
                    return this.visitor.visitFile(var1_1, var4_4);
                }
                try {
                    if (!var1_1.isSameFile(var8_11.file())) continue;
                    return this.visitor.visitFile(var1_1, var4_4);
                }
                catch (IOException var10_22) {
                }
                catch (SecurityException var10_23) {
                }
            }
            var3_3.add(new AncestorDirectory(var1_1, var6_8));
        }
        try {
            block52: {
                var6_8 = null;
                try {
                    var6_8 = var1_1.newDirectoryStream();
                }
                catch (IOException var8_12) {
                    var9_17 /* !! */  = this.visitor.preVisitDirectoryFailed(var1_1, var8_12);
                    if (!this.detectCycles) return var9_17 /* !! */ ;
                    var3_3.remove(var3_3.size() - 1);
                    return var9_17 /* !! */ ;
                }
                catch (SecurityException var8_13) {
                    var9_17 /* !! */  = FileVisitResult.CONTINUE;
                    if (!this.detectCycles) return var9_17 /* !! */ ;
                    var3_3.remove(var3_3.size() - 1);
                    return var9_17 /* !! */ ;
                }
                var8_14 = null;
                try {
                    var7_10 /* !! */  = this.visitor.preVisitDirectory(var1_1);
                    if (var7_10 /* !! */  != FileVisitResult.CONTINUE) {
                        var9_17 /* !! */  = var7_10 /* !! */ ;
                        return var9_17 /* !! */ ;
                    }
                    var9_18 = false;
                    for (Path var11_26 : var6_8) {
                        var9_18 = true;
                        var7_10 /* !! */  = this.walk(var11_26, var2_2, var3_3);
                        var9_18 = false;
                        if (var7_10 /* !! */  != null && var7_10 /* !! */  != FileVisitResult.TERMINATE) ** break block51
                        var12_28 /* !! */  = var7_10 /* !! */ ;
                        return var12_28 /* !! */ ;
                    }
                    break block52;
                    {
                        try {
                            if (var7_10 /* !! */  != FileVisitResult.SKIP_SIBLINGS) continue;
                        }
                        catch (ConcurrentModificationException var10_25) {
                            if (!var9_18 && (var11_27 = var10_25.getCause()) instanceof IOException) {
                                var8_15 = (IOException)var11_27;
                            }
                            if (var8_16 == null) {
                                throw var10_25;
                            }
                            break block52;
                            break;
                        }
                    }
                }
                finally {
                    try {
                        var6_8.close();
                    }
                    catch (IOException var10_24) {}
                }
            }
            var9_20 = this.visitor.postVisitDirectory(var1_1, (IOException)var8_16);
            return var9_20;
            {
                catch (Throwable var16_32) {
                    throw var16_32;
                }
            }
        }
        finally {
            if (this.detectCycles) {
                var3_3.remove(var3_3.size() - 1);
            }
        }
    }

    private static class AncestorDirectory {
        private final Path dir;
        private final Object key;

        AncestorDirectory(Path path, Object object) {
            this.dir = path;
            this.key = object;
        }

        Path file() {
            return this.dir;
        }

        Object fileKey() {
            return this.key;
        }
    }
}

