/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.Util;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerDelegateMBean;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class MBeanServerDelegate
implements MBeanServerDelegateMBean,
NotificationEmitter {
    private String mbeanServerId;
    private String mbeanServerName = null;
    private final NotificationBroadcasterSupport broadcaster;
    private static long oldStamp = 0L;
    private final long stamp = MBeanServerDelegate.getStamp();
    private long sequenceNumber = 1L;
    private static final MBeanNotificationInfo[] notifsInfo;
    public static final ObjectName DELEGATE_NAME;

    public MBeanServerDelegate() {
        this.broadcaster = new NotificationBroadcasterSupport();
    }

    @Override
    public synchronized String getMBeanServerId() {
        if (this.mbeanServerId == null) {
            String string;
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                JmxProperties.MISC_LOGGER.finest("Can't get local host name, using \"localhost\" instead. Cause is: " + unknownHostException);
                string = "localhost";
            }
            this.mbeanServerId = Util.insertMBeanServerName(string + "_" + this.stamp, this.mbeanServerName);
        }
        return this.mbeanServerId;
    }

    public synchronized String getMBeanServerName() {
        if (Util.isMBeanServerNameUndefined(this.mbeanServerName)) {
            return "default";
        }
        return this.mbeanServerName;
    }

    public synchronized void setMBeanServerName(String string) {
        String string2 = Util.checkServerName(string);
        if (this.mbeanServerName != null && !this.mbeanServerName.equals(string2)) {
            throw new IllegalArgumentException("MBeanServerName already set to a different value");
        }
        this.mbeanServerName = string2;
        this.mbeanServerId = Util.insertMBeanServerName(this.getMBeanServerId(), string2);
        if (!string2.equals(Util.extractMBeanServerName(this.getMBeanServerId()))) {
            throw new UnsupportedOperationException("Can't set MBeanServerName in MBeanServerId - unsupported by " + this.getClass().getName() + "?");
        }
    }

    @Override
    public String getSpecificationName() {
        return "Java Management Extensions";
    }

    @Override
    public String getSpecificationVersion() {
        return "2.0";
    }

    @Override
    public String getSpecificationVendor() {
        return "Sun Microsystems";
    }

    @Override
    public String getImplementationName() {
        return "JMX";
    }

    @Override
    public String getImplementationVersion() {
        try {
            return System.getProperty("java.runtime.version");
        }
        catch (SecurityException securityException) {
            return "";
        }
    }

    @Override
    public String getImplementationVendor() {
        return "Sun Microsystems";
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        int n = notifsInfo.length;
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[n];
        System.arraycopy(notifsInfo, 0, mBeanNotificationInfoArray, 0, n);
        return mBeanNotificationInfoArray;
    }

    @Override
    public synchronized void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public synchronized void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public synchronized void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(notificationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(Notification notification) {
        if (notification.getSequenceNumber() < 1L) {
            MBeanServerDelegate mBeanServerDelegate = this;
            synchronized (mBeanServerDelegate) {
                notification.setSequenceNumber(this.sequenceNumber++);
            }
        }
        this.broadcaster.sendNotification(notification);
    }

    private static synchronized long getStamp() {
        long l = System.currentTimeMillis();
        if (oldStamp >= l) {
            l = oldStamp + 1L;
        }
        oldStamp = l;
        return l;
    }

    static {
        String[] stringArray = new String[]{"JMX.mbean.unregistered", "JMX.mbean.registered"};
        notifsInfo = new MBeanNotificationInfo[1];
        MBeanServerDelegate.notifsInfo[0] = new MBeanNotificationInfo(stringArray, "javax.management.MBeanServerNotification", "Notifications sent by the MBeanServerDelegate MBean");
        DELEGATE_NAME = ObjectName.valueOf("JMImplementation:type=MBeanServerDelegate");
    }
}

