/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import sun.management.MemoryNotifInfoCompositeData;
import sun.management.NotificationEmitterSupport;
import sun.management.Util;
import sun.management.VMManagement;
import sun.misc.VM;

class MemoryImpl
extends NotificationEmitterSupport
implements MemoryMXBean {
    private final VMManagement jvm;
    private static MemoryPoolMXBean[] pools = null;
    private static MemoryManagerMXBean[] mgrs = null;
    private static final String notifName = "javax.management.Notification";
    private static final String[] notifTypes = new String[]{"java.management.memory.threshold.exceeded", "java.management.memory.collection.threshold.exceeded"};
    private static final String[] notifMsgs = new String[]{"Memory usage exceeds usage threshold", "Memory usage exceeds collection usage threshold"};
    private MBeanNotificationInfo[] notifInfo = null;
    private static long seqNumber = 0L;

    MemoryImpl(VMManagement vMManagement) {
        this.jvm = vMManagement;
    }

    @Override
    public int getObjectPendingFinalizationCount() {
        return VM.getFinalRefCount();
    }

    @Override
    public void gc() {
        Runtime.getRuntime().gc();
    }

    @Override
    public MemoryUsage getHeapMemoryUsage() {
        return this.getMemoryUsage0(true);
    }

    @Override
    public MemoryUsage getNonHeapMemoryUsage() {
        return this.getMemoryUsage0(false);
    }

    @Override
    public boolean isVerbose() {
        return this.jvm.getVerboseGC();
    }

    @Override
    public void setVerbose(boolean bl) {
        Util.checkControlAccess();
        this.setVerboseGC(bl);
    }

    static synchronized MemoryPoolMXBean[] getMemoryPools() {
        if (pools == null) {
            pools = MemoryImpl.getMemoryPools0();
        }
        return pools;
    }

    static synchronized MemoryManagerMXBean[] getMemoryManagers() {
        if (mgrs == null) {
            mgrs = MemoryImpl.getMemoryManagers0();
        }
        return mgrs;
    }

    private static native MemoryPoolMXBean[] getMemoryPools0();

    private static native MemoryManagerMXBean[] getMemoryManagers0();

    private native MemoryUsage getMemoryUsage0(boolean var1);

    private native void setVerboseGC(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MemoryImpl memoryImpl = this;
        synchronized (memoryImpl) {
            if (this.notifInfo == null) {
                this.notifInfo = new MBeanNotificationInfo[1];
                this.notifInfo[0] = new MBeanNotificationInfo(notifTypes, notifName, "Memory Notification");
            }
        }
        return this.notifInfo;
    }

    private static String getNotifMsg(String string) {
        for (int i = 0; i < notifTypes.length; ++i) {
            if (string != notifTypes[i]) continue;
            return notifMsgs[i];
        }
        return "Unknown message";
    }

    private static long getNextSeqNumber() {
        return ++seqNumber;
    }

    static void createNotification(String string, String string2, MemoryUsage memoryUsage, long l) {
        MemoryImpl memoryImpl = (MemoryImpl)ManagementFactory.getMemoryMXBean();
        if (!memoryImpl.hasListeners()) {
            return;
        }
        long l2 = System.currentTimeMillis();
        String string3 = MemoryImpl.getNotifMsg(string);
        Notification notification = new Notification(string, memoryImpl.getObjectName(), MemoryImpl.getNextSeqNumber(), l2, string3);
        MemoryNotificationInfo memoryNotificationInfo = new MemoryNotificationInfo(string2, memoryUsage, l);
        CompositeData compositeData = MemoryNotifInfoCompositeData.toCompositeData(memoryNotificationInfo);
        notification.setUserData(compositeData);
        memoryImpl.sendNotification(notification);
    }

    @Override
    public ObjectName getObjectName() {
        return ObjectName.valueOf("java.lang:type=Memory");
    }
}

