/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.EUC_TWMapping;
import sun.nio.cs.ext.ExtendedCharsets;

public class EUC_TW
extends Charset
implements HistoricallyNamedCharset {
    private static final int SS2 = 142;

    public EUC_TW() {
        super("x-EUC-TW", ExtendedCharsets.aliasesFor("x-EUC-TW"));
    }

    @Override
    public String historicalName() {
        return "EUC_TW";
    }

    @Override
    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof EUC_TW;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    public static class Encoder
    extends CharsetEncoder {
        private byte[] bb = new byte[4];
        static final char[] c2b;
        static final char[] c2bIndex;
        static final char[] c2bSupp;
        static final char[] c2bSuppIndex;
        static final byte[] c2bPlane;

        public Encoder(Charset charset) {
            super(charset, 4.0f, 4.0f);
        }

        @Override
        public boolean canEncode(char c) {
            return c <= '\u007f' || this.toEUC(c, this.bb) != -1;
        }

        @Override
        public boolean canEncode(CharSequence charSequence) {
            int n = 0;
            while (n < charSequence.length()) {
                char c;
                if (Character.isHighSurrogate(c = charSequence.charAt(n++))) {
                    char c2;
                    if (n == charSequence.length()) {
                        return false;
                    }
                    if (Character.isLowSurrogate(c2 = charSequence.charAt(n++)) && this.toEUC(c, c2, this.bb) != -1) continue;
                    return false;
                }
                if (this.canEncode(c)) continue;
                return false;
            }
            return true;
        }

        public int toEUC(char c, char c2, byte[] byArray) {
            return Encoder.encode(c, c2, byArray);
        }

        public int toEUC(char c, byte[] byArray) {
            return Encoder.encode(c, byArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n;
            char[] cArray = charBuffer.array();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            try {
                int n5;
                for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; n += n5) {
                    int n6;
                    char c = cArray[n];
                    n5 = 1;
                    if (c < '\u0080') {
                        this.bb[0] = (byte)c;
                        n6 = 1;
                    } else {
                        n6 = this.toEUC(c, this.bb);
                        if (n6 == -1) {
                            if (Character.isHighSurrogate(c)) {
                                if (n + 1 == n2) {
                                    CoderResult coderResult = CoderResult.UNDERFLOW;
                                    return coderResult;
                                }
                                if (!Character.isLowSurrogate(cArray[n + 1])) {
                                    CoderResult coderResult = CoderResult.malformedForLength(1);
                                    return coderResult;
                                }
                                n6 = this.toEUC(c, cArray[n + 1], this.bb);
                                n5 = 2;
                            } else if (Character.isLowSurrogate(c)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                        }
                    }
                    if (n6 == -1) {
                        CoderResult coderResult = CoderResult.unmappableForLength(n5);
                        return coderResult;
                    }
                    if (n4 - n3 < n6) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    for (int i = 0; i < n6; ++i) {
                        byArray[n3++] = this.bb[i];
                    }
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    int n2;
                    int n3;
                    int n4 = 1;
                    char c = charBuffer.get();
                    if (c < '\u0080') {
                        n3 = 1;
                        this.bb[0] = (byte)c;
                    } else {
                        n3 = this.toEUC(c, this.bb);
                        if (n3 == -1) {
                            if (Character.isHighSurrogate(c)) {
                                if (!charBuffer.hasRemaining()) {
                                    CoderResult coderResult = CoderResult.UNDERFLOW;
                                    return coderResult;
                                }
                                n2 = charBuffer.get();
                                if (!Character.isLowSurrogate((char)n2)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(1);
                                    return coderResult;
                                }
                                n3 = this.toEUC(c, (char)n2, this.bb);
                                n4 = 2;
                            } else if (Character.isLowSurrogate(c)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                        }
                    }
                    if (n3 == -1) {
                        CoderResult coderResult = CoderResult.unmappableForLength(n4);
                        return coderResult;
                    }
                    if (byteBuffer.remaining() < n3) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        byteBuffer.put(this.bb[n2]);
                    }
                    n += n4;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }

        static int encode(char c, char c2, byte[] byArray) {
            int n = Surrogate.toUCS4(c, c2);
            if ((n & 0xF0000) != 131072) {
                return -1;
            }
            int n2 = c2bSuppIndex[(n -= 131072) >> 8];
            if (n2 == 65533) {
                return -1;
            }
            char c3 = c2bSupp[n2 += n & 0xFF];
            if (c3 == '\ufffd') {
                return -1;
            }
            int n3 = c2bPlane[n2] >> 4 & 0xF;
            byArray[0] = -114;
            byArray[1] = (byte)(0xA0 | n3);
            byArray[2] = (byte)(c3 >> 8);
            byArray[3] = (byte)c3;
            return 4;
        }

        static int encode(char c, byte[] byArray) {
            int n = c2bIndex[c >> 8];
            if (n == 65533) {
                return -1;
            }
            char c2 = c2b[n += c & 0xFF];
            if (c2 == '\ufffd') {
                return -1;
            }
            int n2 = c2bPlane[n] & 0xF;
            if (n2 == 0) {
                byArray[0] = (byte)(c2 >> 8);
                byArray[1] = (byte)c2;
                return 2;
            }
            byArray[0] = -114;
            byArray[1] = (byte)(0xA0 | n2);
            byArray[2] = (byte)(c2 >> 8);
            byArray[3] = (byte)c2;
            return 4;
        }

        static {
            int n = 161;
            int n2 = 254;
            int n3 = 161;
            int n4 = 254;
            int n5 = 94;
            String[] stringArray = Decoder.b2c;
            byte[] byArray = Decoder.b2cIsSupp;
            c2bIndex = EUC_TWMapping.c2bIndex;
            c2bSuppIndex = EUC_TWMapping.c2bSuppIndex;
            char[] cArray = new char[31744];
            char[] cArray2 = new char[43520];
            byte[] byArray2 = new byte[Math.max(31744, 43520)];
            Arrays.fill(cArray, '\ufffd');
            Arrays.fill(cArray2, '\ufffd');
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                int n6 = i;
                if (n6 == 7) {
                    n6 = 15;
                } else if (n6 != 0) {
                    n6 = i + 1;
                }
                int n7 = 0;
                for (int j = n; j <= n2; ++j) {
                    for (int k = n3; k <= n4; ++k) {
                        char c = string.charAt(n7);
                        if (c != '\ufffd') {
                            int n8;
                            if ((byArray[n7] & 1 << i) != 0) {
                                n8 = c2bSuppIndex[c >> 8] + (c & 0xFF);
                                cArray2[n8] = (char)((j << 8) + k);
                                int n9 = n8;
                                byArray2[n9] = (byte)(byArray2[n9] | (byte)(n6 << 4));
                            } else {
                                n8 = c2bIndex[c >> 8] + (c & 0xFF);
                                cArray[n8] = (char)((j << 8) + k);
                                int n10 = n8;
                                byArray2[n10] = (byte)(byArray2[n10] | (byte)n6);
                            }
                        }
                        ++n7;
                    }
                }
            }
            c2b = cArray;
            c2bSupp = cArray2;
            c2bPlane = byArray2;
        }
    }

    public static class Decoder
    extends CharsetDecoder {
        char[] c1 = new char[1];
        char[] c2 = new char[2];
        static final String[] b2c = EUC_TWMapping.b2c;
        static final int b1Min = 161;
        static final int b1Max = 254;
        static final int b2Min = 161;
        static final int b2Max = 254;
        static final int dbSegSize = 94;
        static final byte[] b2cIsSupp;
        static final byte[] cnspToIndex;

        public Decoder(Charset charset) {
            super(charset, 2.0f, 2.0f);
        }

        public char[] toUnicode(int n, int n2, int n3) {
            return Decoder.decode(n, n2, n3, this.c1, this.c2);
        }

        static boolean isLegalDB(int n) {
            return n >= 161 && n <= 254;
        }

        static char[] decode(int n, int n2, int n3, char[] cArray, char[] cArray2) {
            if (n < 161 || n > 254 || n2 < 161 || n2 > 254) {
                return null;
            }
            int n4 = (n - 161) * 94 + n2 - 161;
            char c = b2c[n3].charAt(n4);
            if (c == '\ufffd') {
                return null;
            }
            if ((b2cIsSupp[n4] & 1 << n3) == 0) {
                cArray[0] = c;
                return cArray;
            }
            cArray2[0] = Surrogate.high(131072 + c);
            cArray2[1] = Surrogate.low(131072 + c);
            return cArray2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            try {
                while (n < n2) {
                    Object object;
                    int n5;
                    int n6 = byArray[n] & 0xFF;
                    if (n6 == 142) {
                        if (n2 - n < 4) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        n5 = cnspToIndex[byArray[n + 1] & 0xFF];
                        if (n5 < 0) {
                            CoderResult coderResult = CoderResult.malformedForLength(2);
                            return coderResult;
                        }
                        n6 = byArray[n + 2] & 0xFF;
                        int n7 = byArray[n + 3] & 0xFF;
                        object = this.toUnicode(n6, n7, n5);
                        if (object == null) {
                            if (!Decoder.isLegalDB(n6) || !Decoder.isLegalDB(n7)) {
                                CoderResult coderResult = CoderResult.malformedForLength(4);
                                return coderResult;
                            }
                            CoderResult coderResult = CoderResult.unmappableForLength(4);
                            return coderResult;
                        }
                        if (n4 - n3 < ((Object)object).length) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        if (((Object)object).length == 1) {
                            cArray[n3++] = (char)object[0];
                        } else {
                            cArray[n3++] = (char)object[0];
                            cArray[n3++] = (char)object[1];
                        }
                        n += 4;
                        continue;
                    }
                    if (n6 < 128) {
                        if (n4 - n3 < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        cArray[n3++] = (char)n6;
                        ++n;
                        continue;
                    }
                    if (n2 - n < 2) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    n5 = byArray[n + 1] & 0xFF;
                    char[] cArray2 = this.toUnicode(n6, n5, 0);
                    if (cArray2 == null) {
                        if (!Decoder.isLegalDB(n6) || !Decoder.isLegalDB(n5)) {
                            object = CoderResult.malformedForLength(1);
                            return object;
                        }
                        object = CoderResult.unmappableForLength(2);
                        return object;
                    }
                    if (n4 - n3 < 1) {
                        object = CoderResult.OVERFLOW;
                        return object;
                    }
                    cArray[n3++] = cArray2[0];
                    n += 2;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            try {
                while (byteBuffer.hasRemaining()) {
                    Object object;
                    int n2;
                    int n3 = byteBuffer.get() & 0xFF;
                    if (n3 == 142) {
                        int n4;
                        if (byteBuffer.remaining() < 3) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        n2 = cnspToIndex[byteBuffer.get() & 0xFF];
                        if (n2 < 0) {
                            CoderResult coderResult = CoderResult.malformedForLength(2);
                            return coderResult;
                        }
                        n3 = byteBuffer.get() & 0xFF;
                        object = this.toUnicode(n3, n4 = byteBuffer.get() & 0xFF, n2);
                        if (object == null) {
                            if (!Decoder.isLegalDB(n3) || !Decoder.isLegalDB(n4)) {
                                CoderResult coderResult = CoderResult.malformedForLength(4);
                                return coderResult;
                            }
                            CoderResult coderResult = CoderResult.unmappableForLength(4);
                            return coderResult;
                        }
                        if (charBuffer.remaining() < ((Object)object).length) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        if (((Object)object).length == 1) {
                            charBuffer.put((char)object[0]);
                        } else {
                            charBuffer.put((char)object[0]);
                            charBuffer.put((char)object[1]);
                        }
                        n += 4;
                        continue;
                    }
                    if (n3 < 128) {
                        if (!charBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put((char)n3);
                        ++n;
                        continue;
                    }
                    if (!byteBuffer.hasRemaining()) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    n2 = byteBuffer.get() & 0xFF;
                    char[] cArray = this.toUnicode(n3, n2, 0);
                    if (cArray == null) {
                        if (!Decoder.isLegalDB(n3) || !Decoder.isLegalDB(n2)) {
                            object = CoderResult.malformedForLength(1);
                            return object;
                        }
                        object = CoderResult.unmappableForLength(2);
                        return object;
                    }
                    if (!charBuffer.hasRemaining()) {
                        object = CoderResult.OVERFLOW;
                        return object;
                    }
                    charBuffer.put(cArray[0]);
                    n += 2;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        static {
            cnspToIndex = new byte[256];
            Arrays.fill(cnspToIndex, (byte)-1);
            Decoder.cnspToIndex[162] = 1;
            Decoder.cnspToIndex[163] = 2;
            Decoder.cnspToIndex[164] = 3;
            Decoder.cnspToIndex[165] = 4;
            Decoder.cnspToIndex[166] = 5;
            Decoder.cnspToIndex[167] = 6;
            Decoder.cnspToIndex[175] = 7;
            String string = EUC_TWMapping.b2cIsSuppStr;
            byte[] byArray = new byte[string.length() << 1];
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                byArray[n++] = (byte)(c >> 8);
                byArray[n++] = (byte)(c & 0xFF);
            }
            b2cIsSupp = byArray;
        }
    }
}

