
from twisted.trial.unittest import TestCase, SkipTest
import platform

try:
    from elisa.plugins.lirc.lirc_input import LircInput
except:
    LircInput = None

from elisa.core.input_event import values

class TestLircInputParser(TestCase):
    
    def setUp(self):
        if not LircInput:
            raise SkipTest("Not supported on %s platform" % platform.system())    
        # we only create the Instance, that is all we need
        self.lirc = LircInput()

    def test_full_parsing_one_remote(self):
        """
        test full parsing of on remote
        """
        data = ""

        for key in values:
            data += "REMOTE %s_rm %s\n" % (key, key)

        self.lirc._parse_to_mapping(data)

        length = len(values)

        self.assertEquals(self.lirc.mappings.keys(), ['REMOTE'])
        self.assertEquals(len(self.lirc.mappings['REMOTE']), length)

    def test_some_parsing_one_remote(self):
        """
        test parsing of good and wrong code for one remote
        """

        data = """ASUS KEY_UP KEY_GO_UP
        ASUS KEY_DOWN KEY_GO_DOWN
        ASUS KEY_WRONG KEY_WRONG
        ASUS KEY_42 KEY_42
        ASUS KEY_MENU KEY_MENU
        ASUS KEY_PLAY KEY_PLAY
        """

        self.lirc._parse_to_mapping(data)

        self.assertEquals(self.lirc.mappings.keys(), ['ASUS'])
        self.assertEquals(len(self.lirc.mappings['ASUS']), 4)



    def test_some_parsing_two_remotes(self):
        """
        test parsing of good and wrong code for one remote
        """

        data = """ASUS1 KEY_UP KEY_GO_UP
        ASUS1 KEY_DOWN KEY_GO_DOWN
        ASUS1 KEY_WRONG KEY_WRONG
        ASUS KEY_42 KEY_42
        ASUS KEY_MENU KEY_MENU
        ASUS KEY_PLAY KEY_PLAY
        ASUS KEY_UP KEY_GO_UP
        ASUS KEY_DOWN KEY_GO_DOWN
        ASUS KEY_WRONG KEY_WRONG
        ASUS1 KEY_42 KEY_42
        ASUS1 KEY_MENU KEY_MENU
        ASUS1 KEY_PLAY KEY_PLAY
        """

        self.lirc._parse_to_mapping(data)

        self.assertEquals(self.lirc.mappings.keys(), ['ASUS1','ASUS'])
        self.assertEquals(len(self.lirc.mappings['ASUS']), 4)
        self.assertEquals(len(self.lirc.mappings['ASUS1']), 4)


    def test_comment(self):
        """
        test to parse it with a comment
        """
        data = """ASUS KEY_UP KEY_GO_UP
        # ASUS KEY_DOWN KEY_GO_DOWN
        #ASUS KEY_MENU KEY_MENU
        ASUS KEY_PLAY KEY_PLAY
        """

        self.lirc._parse_to_mapping(data)

        self.assertEquals(self.lirc.mappings.keys(), ['ASUS'])
        self.assertEquals(len(self.lirc.mappings['ASUS']), 2)
