/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.web.beans.api.model.Result;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.navigation.InjectableTreeNode;
import org.netbeans.modules.web.beans.navigation.MethodTreeNode;
import org.netbeans.modules.web.beans.navigation.TypeTreeNode;
import org.openide.filesystems.FileObject;

public final class InjectablesModel
extends DefaultTreeModel {
    private static final long serialVersionUID = -6845959436250662000L;
    private static final Logger LOG = Logger.getLogger(InjectablesModel.class.getName());
    static Element[] EMPTY_ELEMENTS_ARRAY = new Element[0];
    private List<ElementHandle<TypeElement>> myTypeHandles;
    private Map<ElementHandle<?>, List<TypeMirrorHandle<DeclaredType>>> myProductionHandles;
    private Set<ElementHandle<?>> myDisabledBeans;
    private MetadataModel<WebBeansModel> myModel;
    private Result.ResolutionResult myResult;

    public InjectablesModel(Result result, CompilationController compilationController, MetadataModel<WebBeansModel> metadataModel) {
        super(null);
        this.myModel = metadataModel;
        if (result.getKind() == Result.ResultKind.DEFINITION_ERROR || !(result instanceof Result.ApplicableResult)) {
            this.myTypeHandles = Collections.emptyList();
            this.myProductionHandles = Collections.emptyMap();
            return;
        }
        if (result instanceof Result.ResolutionResult) {
            this.myResult = (Result.ResolutionResult)result;
        }
        Result.ApplicableResult applicableResult = (Result.ApplicableResult)((Object)result);
        Set<TypeElement> set = applicableResult.getTypeElements();
        this.myProductionHandles = new HashMap();
        this.myDisabledBeans = new HashSet();
        HashSet<Element> hashSet = new HashSet<Element>();
        this.myTypeHandles = new ArrayList<ElementHandle<TypeElement>>(set.size());
        for (TypeElement object : set) {
            ElementHandle elementHandle = ElementHandle.create((Element)object);
            this.myTypeHandles.add((ElementHandle<TypeElement>)elementHandle);
            if (!applicableResult.isDisabled(object)) continue;
            this.myDisabledBeans.add(elementHandle);
            hashSet.add(object);
        }
        Map<Element, List<DeclaredType>> map = applicableResult.getAllProductions();
        for (Map.Entry entry : map.entrySet()) {
            ElementHandle elementHandle = ElementHandle.create((Element)((Element)entry.getKey()));
            ArrayList<TypeMirrorHandle> arrayList = new ArrayList<TypeMirrorHandle>(((List)entry.getValue()).size());
            for (DeclaredType declaredType : (List)entry.getValue()) {
                TypeMirrorHandle typeMirrorHandle = TypeMirrorHandle.create((TypeMirror)declaredType);
                arrayList.add(typeMirrorHandle);
            }
            this.myProductionHandles.put(elementHandle, arrayList);
            if (!applicableResult.isDisabled((Element)entry.getKey())) continue;
            this.myDisabledBeans.add(elementHandle);
            hashSet.add((Element)entry.getKey());
        }
        this.update(set, map, hashSet, compilationController);
    }

    void update() {
        this.update(this.myTypeHandles, this.myProductionHandles);
    }

    void fireTreeNodesChanged() {
        super.fireTreeNodesChanged(this, this.getPathToRoot((TreeNode)this.getRoot()), null, null);
    }

    private void update(final List<ElementHandle<TypeElement>> list, final Map<ElementHandle<?>, List<TypeMirrorHandle<DeclaredType>>> map) {
        try {
            this.getModel().runReadAction((MetadataModelAction)new MetadataModelAction<WebBeansModel, Void>(){

                public Void run(WebBeansModel webBeansModel) {
                    HashSet hashSet = new HashSet();
                    List list2 = InjectablesModel.this.fillTypes(list, webBeansModel, hashSet);
                    Map map2 = InjectablesModel.this.fillProductions(map, webBeansModel, hashSet);
                    InjectablesModel.this.update(list2, map2, hashSet, webBeansModel.getCompilationController());
                    return null;
                }
            });
            return;
        }
        catch (MetadataModelException metadataModelException) {
            LOG.log(Level.WARNING, metadataModelException.getMessage(), metadataModelException);
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, iOException.getMessage(), iOException);
        }
    }

    private Map<Element, List<DeclaredType>> fillProductions(Map<ElementHandle<?>, List<TypeMirrorHandle<DeclaredType>>> map, WebBeansModel webBeansModel, Set<Element> set) {
        Map<Element, List<DeclaredType>> map2;
        if (map == null || map.size() == 0) {
            map2 = Collections.emptyMap();
        } else {
            map2 = new HashMap<Element, List<DeclaredType>>();
            for (Map.Entry<ElementHandle<?>, List<TypeMirrorHandle<DeclaredType>>> entry : map.entrySet()) {
                ElementHandle<?> elementHandle = entry.getKey();
                Element element = elementHandle.resolve((CompilationInfo)webBeansModel.getCompilationController());
                if (element != null) {
                    if (this.myDisabledBeans.contains(elementHandle)) {
                        set.add(element);
                    }
                    ArrayList<DeclaredType> arrayList = new ArrayList<DeclaredType>(entry.getValue().size());
                    for (TypeMirrorHandle<DeclaredType> typeMirrorHandle : entry.getValue()) {
                        DeclaredType declaredType = (DeclaredType)typeMirrorHandle.resolve((CompilationInfo)webBeansModel.getCompilationController());
                        if (declaredType != null) {
                            arrayList.add(declaredType);
                            continue;
                        }
                        LOG.warning(typeMirrorHandle.toString() + " cannot be resolved using: " + webBeansModel.getCompilationController().getClasspathInfo());
                    }
                    if (arrayList.size() <= 0) continue;
                    map2.put(element, arrayList);
                    continue;
                }
                LOG.warning(elementHandle.toString() + " cannot be resolved using: " + webBeansModel.getCompilationController().getClasspathInfo());
            }
        }
        return map2;
    }

    private List<TypeElement> fillTypes(List<ElementHandle<TypeElement>> list, WebBeansModel webBeansModel, Set<Element> set) {
        List<TypeElement> list2;
        if (list != null && list.size() != 0) {
            list2 = new ArrayList<TypeElement>(list.size());
            for (ElementHandle<TypeElement> elementHandle : list) {
                TypeElement typeElement = (TypeElement)elementHandle.resolve((CompilationInfo)webBeansModel.getCompilationController());
                if (typeElement != null) {
                    list2.add(typeElement);
                    if (!this.myDisabledBeans.contains(elementHandle)) continue;
                    set.add(typeElement);
                    continue;
                }
                LOG.warning(elementHandle.toString() + " cannot be resolved using: " + webBeansModel.getCompilationController().getClasspathInfo());
            }
        } else {
            list2 = Collections.emptyList();
        }
        return list2;
    }

    private void update(Collection<TypeElement> collection, Map<Element, List<DeclaredType>> map, Set<Element> set, CompilationController compilationController) {
        TypeTreeNode typeTreeNode;
        Object object;
        if (collection.size() == 0 && map.size() == 0) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        LinkedHashMap<Element, InjectableTreeNode<? extends Element>> linkedHashMap = new LinkedHashMap<Element, InjectableTreeNode<? extends Element>>();
        for (TypeElement object2 : collection) {
            object = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)object2), (ClasspathInfo)compilationController.getClasspathInfo());
            typeTreeNode = new TypeTreeNode((FileObject)object, object2, set.contains(object2), (CompilationInfo)compilationController);
            this.insertTreeNode(linkedHashMap, object2, typeTreeNode, defaultMutableTreeNode, set.contains(object2), compilationController);
        }
        for (Map.Entry entry : map.entrySet()) {
            MethodTreeNode methodTreeNode;
            object = (Element)entry.getKey();
            typeTreeNode = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)object), (ClasspathInfo)compilationController.getClasspathInfo());
            if (object instanceof ExecutableElement) {
                methodTreeNode = new MethodTreeNode((FileObject)typeTreeNode, (ExecutableElement)object, (DeclaredType)((List)entry.getValue()).get(0), set.contains(object), (CompilationInfo)compilationController);
                this.insertTreeNode(linkedHashMap, (ExecutableElement)object, methodTreeNode, defaultMutableTreeNode, compilationController);
                if (((List)entry.getValue()).size() <= 1) continue;
            }
            methodTreeNode = new InjectableTreeNode((FileObject)typeTreeNode, object, (DeclaredType)((List)entry.getValue()).get(0), set.contains(object), (CompilationInfo)compilationController);
            this.insertTreeNode(linkedHashMap, methodTreeNode, defaultMutableTreeNode);
            if (((List)entry.getValue()).size() <= 1) continue;
        }
        this.setRoot(defaultMutableTreeNode);
    }

    private void insertTreeNode(Map<Element, InjectableTreeNode<? extends Element>> map, TypeElement typeElement, TypeTreeNode typeTreeNode, DefaultMutableTreeNode defaultMutableTreeNode, boolean bl, CompilationController compilationController) {
        Object object;
        Object object2;
        Object object3;
        Map.Entry<Element, InjectableTreeNode<? extends Element>> entry2;
        Object object4 = null;
        for (Map.Entry<Element, InjectableTreeNode<? extends Element>> entry2 : map.entrySet()) {
            object3 = entry2.getKey();
            if (!(object3 instanceof TypeElement)) continue;
            object2 = (TypeTreeNode)entry2.getValue();
            object = (TypeElement)object3;
            if (object == null || !compilationController.getTypes().isAssignable(typeElement.asType(), object.asType())) continue;
            if (object4 == null) {
                object4 = object2;
                continue;
            }
            if (!((TypeTreeNode)object4).isAssignableFrom((TypeElement)object, compilationController)) continue;
            object4 = object2;
        }
        Object object5 = object4;
        if (object5 == null) {
            object5 = defaultMutableTreeNode;
        }
        entry2 = ((DefaultMutableTreeNode)object5).children();
        object3 = new LinkedList();
        while (entry2.hasMoreElements()) {
            object2 = (TypeTreeNode)entry2.nextElement();
            if (!((TypeTreeNode)object2).isAssignable(typeElement, compilationController)) continue;
            object3.add(object2);
        }
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (TypeTreeNode)object2.next();
            ((DefaultMutableTreeNode)object5).remove((MutableTreeNode)object);
            typeTreeNode.add((MutableTreeNode)object);
        }
        ((DefaultMutableTreeNode)object5).add(typeTreeNode);
        map.put(typeElement, typeTreeNode);
    }

    private void insertTreeNode(Map<Element, InjectableTreeNode<? extends Element>> map, ExecutableElement executableElement, MethodTreeNode methodTreeNode, DefaultMutableTreeNode defaultMutableTreeNode, CompilationController compilationController) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6 = null;
        ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
        ExecutableElement executableElement2 = executableElement;
        while ((executableElement2 = compilationController.getElementUtilities().getOverriddenMethod(executableElement2)) != null) {
            arrayList.add(executableElement2);
        }
        if (arrayList.size() > 0) {
            object5 = map.entrySet().iterator();
            while (object5.hasNext()) {
                int n;
                object4 = (Map.Entry)object5.next();
                object3 = (Element)object4.getKey();
                if (!(object3 instanceof ExecutableElement)) continue;
                object2 = (MethodTreeNode)object4.getValue();
                object = (ExecutableElement)object3;
                if (object == null || (n = arrayList.indexOf(object)) == -1) continue;
                if (object6 == null) {
                    object6 = object2;
                    continue;
                }
                if (!((MethodTreeNode)object6).isOverridden(n, arrayList, compilationController)) continue;
                object6 = object2;
            }
        }
        if ((object5 = object6) == null) {
            object5 = defaultMutableTreeNode;
        }
        object4 = ((DefaultMutableTreeNode)object5).children();
        object3 = new LinkedList();
        while (object4.hasMoreElements()) {
            object2 = (MethodTreeNode)object4.nextElement();
            if (!((MethodTreeNode)object2).overridesMethod(executableElement, compilationController)) continue;
            object3.add(object2);
        }
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (MethodTreeNode)object2.next();
            ((DefaultMutableTreeNode)object5).remove((MutableTreeNode)object);
            methodTreeNode.add((MutableTreeNode)object);
        }
        ((DefaultMutableTreeNode)object5).add(methodTreeNode);
        map.put(executableElement, methodTreeNode);
    }

    private void insertTreeNode(Map<Element, InjectableTreeNode<? extends Element>> map, InjectableTreeNode<Element> injectableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode) {
        defaultMutableTreeNode.add(injectableTreeNode);
    }

    private MetadataModel<WebBeansModel> getModel() {
        return this.myModel;
    }
}

