/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.customizer;

import com.sun.javacard.filemodels.WebXmlModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.javacard.JCUtil;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.JCProjectProperties;
import org.netbeans.modules.javacard.spi.Card;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.netbeans.modules.javacard.spi.capabilities.UrlCapability;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ui.StoreGroup;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class WebProjectProperties
extends JCProjectProperties {
    Document SPECIFIC_URL;
    Document SERVLET_URL = new PlainDocument();
    Document COMPLETE_URL = new PlainDocument();
    ComboBoxModel PAGES;
    ButtonModel LAUNCH_BROWSER;
    ButtonModel SELECT_SERVLET;
    ButtonModel SELECT_PAGE;
    ButtonModel SELECT_URL;
    private StoreGroup projectGroup;
    private PropertyEvaluator eval;
    private AntProjectHelper antHelper;
    private WebXmlModel fromFileModel;
    private WebXmlModel fromUiModel;
    private String webContextPath;
    private String servletMapping;

    public WebProjectProperties(JCProject project, PropertyEvaluator eval, AntProjectHelper antHelper) {
        super(project);
        this.eval = eval;
        this.antHelper = antHelper;
        this.projectGroup = new StoreGroup();
        this.init();
    }

    void setWebContextPathAndMainUrl(String defaultServlet, String defaultMapping) {
        this.webContextPath = defaultServlet;
        this.servletMapping = defaultMapping;
        try {
            this.SERVLET_URL.remove(0, this.SERVLET_URL.getLength());
            String servletUrl = this.assembleUrl(this.baseUrl(), this.webContextPath, this.servletMapping);
            this.SERVLET_URL.insertString(0, servletUrl, null);
            this.updateFullUrl();
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void setWebXmlFileModel(WebXmlModel mdl) {
        assert (this.fromFileModel == null || this.fromFileModel != this.fromUiModel);
        this.fromFileModel = mdl;
    }

    void setWebXmlUiModel(WebXmlModel mdl) {
        assert (this.fromFileModel != this.fromUiModel);
        this.fromUiModel = mdl;
    }

    private void init() {
        this.LAUNCH_BROWSER = this.projectGroup.createToggleButtonModel(this.eval, "run.browser");
        this.SELECT_PAGE = new JToggleButton.ToggleButtonModel();
        this.SELECT_SERVLET = new JToggleButton.ToggleButtonModel();
        this.SELECT_URL = new JToggleButton.ToggleButtonModel();
        ProjectManager.mutex().readAccess(new Runnable(){

            @Override
            public void run() {
                WebProjectProperties.this.platformName = WebProjectProperties.this.eval.getProperty("platform.active");
                WebProjectProperties.this.activeDevice = WebProjectProperties.this.eval.getProperty("active.device");
                FileObject staticPagesDir = WebProjectProperties.this.antHelper.getProjectDirectory().getFileObject("html/");
                Vector<String> pages = new Vector<String>();
                if (staticPagesDir != null) {
                    Enumeration allFiles = staticPagesDir.getChildren(true);
                    while (allFiles.hasMoreElements()) {
                        FileObject file = (FileObject)allFiles.nextElement();
                        if ((!file.isData() || !"html".equals(file.getExt())) && !"htm".equals(file.getExt())) continue;
                        pages.add("/" + FileUtil.getRelativePath((FileObject)staticPagesDir, (FileObject)file));
                    }
                }
                WebProjectProperties.this.PAGES = new DefaultComboBoxModel(pages);
                WebProjectProperties.this.webContextPath = WebProjectProperties.this.eval.getProperty("webcontextpath");
                WebProjectProperties.this.servletMapping = WebProjectProperties.this.eval.getProperty("run.servlet.url");
                WebProjectProperties.this.SELECT_PAGE.setSelected(Boolean.valueOf(WebProjectProperties.this.eval.getProperty("use.page")));
                WebProjectProperties.this.SELECT_URL.setSelected(Boolean.valueOf(WebProjectProperties.this.eval.getProperty("use.url")));
                WebProjectProperties.this.SELECT_SERVLET.setSelected(Boolean.valueOf(WebProjectProperties.this.eval.getProperty("use.servlet")));
                WebProjectProperties.this.SPECIFIC_URL = WebProjectProperties.this.projectGroup.createStringDocument(WebProjectProperties.this.eval, "run.explicit.url");
                class L
                implements ActionListener,
                DocumentListener {
                    L() {
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WebProjectProperties.this.updateFullUrl();
                    }

                    private void change() {
                        WebProjectProperties.this.updateFullUrl();
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.change();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.change();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.change();
                    }
                }
                L cl = new L();
                WebProjectProperties.this.SELECT_PAGE.addActionListener(cl);
                WebProjectProperties.this.SELECT_URL.addActionListener(cl);
                WebProjectProperties.this.SELECT_SERVLET.addActionListener(cl);
                WebProjectProperties.this.SPECIFIC_URL.addDocumentListener(cl);
                try {
                    String url = WebProjectProperties.this.assembleUrl(WebProjectProperties.this.baseUrl(), WebProjectProperties.this.webContextPath, WebProjectProperties.this.servletMapping);
                    WebProjectProperties.this.SERVLET_URL.insertString(0, url, null);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                WebProjectProperties.this.updateFullUrl();
            }
        });
    }

    private String baseUrl() {
        JavacardPlatform platform = JCUtil.findPlatformNamed(this.platformName);
        Card card = platform.getCards().find(this.activeDevice, true);
        UrlCapability urls = (UrlCapability)card.getCapability(UrlCapability.class);
        String result = null;
        if (urls != null) {
            result = urls.getURL();
        }
        if (result == null) {
            result = "http://???/";
        }
        return result;
    }

    private String trimSlashes(String s) {
        if (s == null) {
            return "";
        }
        if (s.startsWith("/") && s.length() > 1) {
            s = s.substring(1);
        }
        if (s.endsWith("/") && s.length() > 1) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private String assembleUrl(String base, String webContextPath, String servletMapping) {
        return this.trimSlashes(base) + '/' + this.trimSlashes(webContextPath) + '/' + this.trimSlashes(servletMapping);
    }

    private void updateFullUrl() {
        try {
            this.COMPLETE_URL.remove(0, this.COMPLETE_URL.getLength());
            String fullUrl = null;
            if (this.SELECT_URL.isSelected()) {
                fullUrl = this.SPECIFIC_URL.getText(0, this.SPECIFIC_URL.getLength());
            } else {
                String baseUrl = this.baseUrl();
                if (this.SELECT_SERVLET.isSelected()) {
                    fullUrl = this.assembleUrl(baseUrl, this.webContextPath, this.servletMapping);
                } else {
                    String page = (String)this.PAGES.getSelectedItem();
                    if (page.startsWith("/")) {
                        page = page.substring(1);
                    }
                    String sel = this.PAGES.getSelectedItem() == null ? "" : this.PAGES.getSelectedItem().toString();
                    fullUrl = this.trimSlashes(baseUrl) + '/' + this.trimSlashes(sel);
                }
            }
            this.COMPLETE_URL.insertString(0, fullUrl, null);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static boolean isPropertyFromRuntimeDescriptor(String property) {
        return "webcontextpath".equals(property);
    }

    public String getWebContextPath() {
        return this.webContextPath;
    }

    public String getServletMapping() {
        return this.servletMapping;
    }

    @Override
    public Boolean onStoreProperties(EditableProperties projectProps) throws IOException {
        this.projectGroup.store(projectProps);
        if (this.fromUiModel != null && this.fromFileModel != null && !this.fromFileModel.equals((Object)this.fromUiModel)) {
            try {
                this.rewriteWebXml(this.fromUiModel);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        if (this.webContextPath != null) {
            projectProps.setProperty("webcontextpath", this.webContextPath);
        }
        if (this.servletMapping != null) {
            projectProps.setProperty("run.servlet.url", this.servletMapping);
        }
        if (this.LAUNCH_BROWSER.isSelected()) {
            projectProps.setProperty("run.browser", "true");
        } else {
            projectProps.remove((Object)"run.browser");
        }
        if (this.SELECT_SERVLET.isSelected()) {
            projectProps.setProperty("use.servlet", Boolean.TRUE.toString());
        } else {
            projectProps.remove((Object)"use.servlet");
        }
        if (this.SELECT_PAGE.isSelected()) {
            projectProps.setProperty("use.page", Boolean.TRUE.toString());
        } else {
            projectProps.remove((Object)"use.page");
        }
        if (this.SELECT_URL.isSelected()) {
            projectProps.setProperty("use.url", Boolean.TRUE.toString());
        } else {
            projectProps.remove((Object)"use.url");
        }
        Object o = this.PAGES.getSelectedItem();
        if (o != null && o.toString().length() > 0) {
            projectProps.setProperty("run.page.url", o.toString());
        } else {
            projectProps.remove((Object)"run.page.url");
        }
        this.antHelper.putProperties("nbproject/project.properties", projectProps);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteWebXml(WebXmlModel fromUiModel) throws IOException {
        FileObject file = this.project.getProjectDirectory().getFileObject("WEB-INF/web.xml");
        if (file == null) {
            file = FileUtil.createData((FileObject)this.project.getProjectDirectory(), (String)"WEB-INF/web.xml");
        }
        FileLock lock = file.lock();
        OutputStream out = file.getOutputStream(lock);
        PrintWriter writer = new PrintWriter(out);
        try {
            writer.print(fromUiModel.toXml());
            writer.flush();
        }
        finally {
            writer.close();
            out.close();
            lock.releaseLock();
        }
    }
}

