/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.source;

import java.net.URL;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.AnnotationProcessingQuery;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.spi.java.queries.AnnotationProcessingQueryImplementation;
import org.openide.filesystems.FileObject;

public class JavacardAPQI
implements AnnotationProcessingQueryImplementation {
    private final JCProject project;
    private static final Logger log = Logger.getLogger(JavacardAPQI.class.getName());

    public JavacardAPQI(JCProject project) {
        log.log(Level.FINER, "Create an AnnotationProcessingQueryImplementation for {0}", project);
        this.project = project;
    }

    public AnnotationProcessingQuery.Result getAnnotationProcessingOptions(FileObject file) {
        log.log(Level.FINER, "get AP Options for {0} project {1}", new Object[]{file, this.project});
        return new Res(this.project);
    }

    private static final class Res
    implements AnnotationProcessingQuery.Result {
        private final JCProject project;

        public Res(JCProject project) {
            this.project = project;
        }

        public Set<? extends AnnotationProcessingQuery.Trigger> annotationProcessingEnabled() {
            return EnumSet.allOf(AnnotationProcessingQuery.Trigger.class);
        }

        public Iterable<? extends String> annotationProcessorsToRun() {
            return Collections.emptySet();
        }

        public URL sourceOutputDirectory() {
            return null;
        }

        public Map<? extends String, ? extends String> processorOptions() {
            log.log(Level.FINER, "get AP Options for {0} kind {1}", new Object[]{this.project, this.project.kind()});
            if (this.project.kind().isClassic()) {
                return Collections.singletonMap("netbeans_private_enable_javacard_processor", Boolean.TRUE.toString());
            }
            return Collections.singletonMap("netbeans_private_enable_javacard_processor", Boolean.FALSE.toString());
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

