/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.discovery.wizard.AdditionalLibrariesListPanel;
import org.netbeans.modules.cnd.discovery.wizard.SimpleConfigurationWizard;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class SimpleConfigurationPanel
extends JPanel {
    private SimpleConfigurationWizard wizard;
    private JButton additionalLibrariesButton;
    private JComboBox configurationComboBox;
    private JLabel configurationLabel;
    private JPanel discoveryPanel;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JLabel librariesLabel;
    private JComboBox librariesTextField;

    public SimpleConfigurationPanel(SimpleConfigurationWizard wizard) {
        this.wizard = wizard;
        this.initComponents();
        this.configurationComboBox.addItem(new ConfigutationItem("project", this.getString("CONFIGURATION_LEVEL_project")));
        this.configurationComboBox.addItem(new ConfigutationItem("folder", this.getString("CONFIGURATION_LEVEL_folder")));
        this.configurationComboBox.addItem(new ConfigutationItem("file", this.getString("CONFIGURATION_LEVEL_file")));
        this.configurationComboBox.setSelectedIndex(2);
        this.addListeners();
    }

    private void addListeners() {
        this.librariesTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleConfigurationPanel.this.update();
            }
        });
        ComboBoxEditor editor = this.librariesTextField.getEditor();
        Component component = editor.getEditorComponent();
        if (component instanceof JTextField) {
            ((JTextField)component).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    SimpleConfigurationPanel.this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    SimpleConfigurationPanel.this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    SimpleConfigurationPanel.this.update();
                }
            });
        }
    }

    private void update() {
        this.wizard.stateChanged(null);
    }

    private void initComponents() {
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.discoveryPanel = new JPanel();
        this.configurationComboBox = new JComboBox();
        this.configurationLabel = new JLabel();
        this.librariesLabel = new JLabel();
        this.additionalLibrariesButton = new JButton();
        this.librariesTextField = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.instructionPanel.setLayout(new GridBagLayout());
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.instructionPanel.add((Component)this.instructionsTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
        this.discoveryPanel.setLayout(new GridBagLayout());
        this.configurationComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SimpleConfigurationPanel.this.configurationComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.discoveryPanel.add((Component)this.configurationComboBox, gridBagConstraints);
        this.configurationLabel.setLabelFor(this.configurationComboBox);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.configurationLabel, (String)bundle.getString("ConfigurationLevelLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.discoveryPanel.add((Component)this.configurationLabel, gridBagConstraints);
        this.librariesLabel.setLabelFor(this.librariesTextField);
        Mnemonics.setLocalizedText((JLabel)this.librariesLabel, (String)bundle.getString("AdditionalLibrariesLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.discoveryPanel.add((Component)this.librariesLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.additionalLibrariesButton, (String)bundle.getString("LIBRARY_BROWSE_BUTTON_TXT"));
        this.additionalLibrariesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleConfigurationPanel.this.additionalLibrariesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.discoveryPanel.add((Component)this.additionalLibrariesButton, gridBagConstraints);
        this.librariesTextField.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.discoveryPanel.add((Component)this.librariesTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.discoveryPanel, gridBagConstraints);
    }

    private void configurationComboBoxItemStateChanged(ItemEvent evt) {
        Object item = evt.getItem();
        if (item instanceof ConfigutationItem) {
            ConfigutationItem conf = (ConfigutationItem)item;
            this.instructionsTextArea.setText(this.getString("SimpleInstructionText_" + conf.getID()));
        }
    }

    private void additionalLibrariesButtonActionPerformed(ActionEvent evt) {
        StringTokenizer tokenizer = new StringTokenizer(this.getLibraryText(), ";");
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        AdditionalLibrariesListPanel panel = new AdditionalLibrariesListPanel(list);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)AdditionalLibrariesListPanel.wrapPanel(panel), this.getString("ADDITIONAL_LIBRARIES_TXT"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            List newList = panel.getListData();
            StringBuilder includes = new StringBuilder();
            for (int i = 0; i < newList.size(); ++i) {
                if (i > 0) {
                    includes.append(';');
                }
                includes.append((String)newList.get(i));
            }
            this.librariesTextField.setSelectedItem(includes.toString());
        }
    }

    private String getString(String key) {
        return NbBundle.getBundle(SimpleConfigurationPanel.class).getString(key);
    }

    void read(DiscoveryDescriptor wizardDescriptor) {
        String providerID = wizardDescriptor.getProviderID();
        if ("dwarf-executable".equals(providerID)) {
            this.additionalLibrariesButton.setVisible(true);
            this.librariesLabel.setVisible(true);
            this.librariesTextField.setVisible(true);
        } else if ("make-log".equals(providerID)) {
            this.additionalLibrariesButton.setVisible(false);
            this.librariesLabel.setVisible(false);
            this.librariesTextField.setVisible(false);
        } else if ("dwarf-folder".equals(providerID)) {
            this.additionalLibrariesButton.setVisible(false);
            this.librariesLabel.setVisible(false);
            this.librariesTextField.setVisible(false);
        }
        if (this.librariesTextField.isVisible()) {
            ArrayList<String> vector = new ArrayList<String>();
            vector.add("");
            Preferences prefs = NbPreferences.forModule(SimpleConfigurationPanel.class);
            String old = prefs.get("libraries", "");
            StringTokenizer st = new StringTokenizer(old, "\u0000");
            int history = 5;
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (vector.contains(s)) continue;
                vector.add(s);
                if (--history != 0) continue;
                break;
            }
            DefaultComboBoxModel<Object> rootModel = new DefaultComboBoxModel<Object>(vector.toArray());
            this.librariesTextField.setModel(rootModel);
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < 35; ++i) {
                buf.append("w");
            }
            this.librariesTextField.setPrototypeDisplayValue(buf.toString());
        }
    }

    private String getLibraryText() {
        Component component;
        ComboBoxEditor editor = this.librariesTextField.getEditor();
        if (editor != null && (component = editor.getEditorComponent()) instanceof JTextField) {
            return ((JTextField)component).getText();
        }
        if (this.librariesTextField.getSelectedItem() != null) {
            return this.librariesTextField.getSelectedItem().toString();
        }
        return "";
    }

    void store(DiscoveryDescriptor wizardDescriptor) {
        ConfigutationItem level = (ConfigutationItem)this.configurationComboBox.getSelectedItem();
        wizardDescriptor.setLevel(level.getID());
        wizardDescriptor.setAditionalLibraries(this.getLibraryText());
        ArrayList<String> vector = new ArrayList<String>();
        vector.add(this.getLibraryText());
        for (int i = 0; i < this.librariesTextField.getModel().getSize(); ++i) {
            String s = this.librariesTextField.getModel().getElementAt(i).toString();
            if (vector.contains(s)) continue;
            vector.add(s);
        }
        StringBuilder buf = new StringBuilder();
        for (String s : vector) {
            if (buf.length() > 0) {
                buf.append('\u0000');
            }
            buf.append(s);
        }
        Preferences prefs = NbPreferences.forModule(SimpleConfigurationPanel.class);
        prefs.put("libraries", buf.toString());
    }

    boolean valid() {
        StringTokenizer st = new StringTokenizer(this.getLibraryText(), ";");
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            File file = new File(path);
            if (file.exists() && file.isFile()) continue;
            return false;
        }
        return true;
    }

    private static class ConfigutationItem {
        private String ID;
        private String name;

        private ConfigutationItem(String ID, String name) {
            this.ID = ID;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getID() {
            return this.ID;
        }
    }
}

