/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.gsf.GsfEditorKitFactory;
import org.netbeans.modules.gsf.GsfIndentTaskFactory;
import org.netbeans.modules.gsf.GsfReformatTaskFactory;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.spi.editor.mimelookup.MimeLookupInitializer;
import org.openide.util.Lookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public class MimeLookupInitializerImpl
implements MimeLookupInitializer {
    private static final int EDITOR_KIT_ID = 1;
    private static final int INDENT_ID = 2;
    private static final int FORMAT_ID = 3;
    private static final int BRACES_ID = 4;
    private String[] mimeTypes;
    private Map<String, Lookup.Result> children = new HashMap<String, Lookup.Result>();
    private Lookup lookup;

    public MimeLookupInitializerImpl() {
        this(new String[0]);
    }

    public MimeLookupInitializerImpl(String[] mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup.Result child(String mimeType) {
        Map<String, Lookup.Result> map = this.children;
        synchronized (map) {
            String[] newMimeType = new String[this.mimeTypes.length + 1];
            System.arraycopy(this.mimeTypes, 0, newMimeType, 0, this.mimeTypes.length);
            newMimeType[this.mimeTypes.length] = mimeType;
            Lookup.Result child = this.children.get(mimeType);
            if (child == null) {
                child = Lookups.fixed((Object[])new Object[]{new MimeLookupInitializerImpl(newMimeType)}).lookup(new Lookup.Template(MimeLookupInitializerImpl.class));
                this.children.put(mimeType, child);
            }
            return child;
        }
    }

    public Lookup lookup() {
        if (this.lookup == null) {
            if (this.mimeTypes.length != 1) {
                this.lookup = Lookup.EMPTY;
                return this.lookup;
            }
            if (LanguageRegistry.getInstance().isSupported(this.mimeTypes[0])) {
                final Language language = LanguageRegistry.getInstance().getLanguageByMimeType(this.mimeTypes[0]);
                assert (language != null);
                if (language.useCustomEditorKit()) {
                    return null;
                }
                Object[] supportedOps = null;
                supportedOps = language.hasFormatter() ? new Integer[]{1, 2, 3} : new Integer[]{1, 2};
                this.lookup = Lookups.fixed((Object[])supportedOps, (InstanceContent.Convertor)new InstanceContent.Convertor<Integer, Object>(){

                    public Object convert(Integer i) {
                        switch (i) {
                            case 1: {
                                GsfEditorKitFactory outer = new GsfEditorKitFactory(language);
                                return outer.kit();
                            }
                            case 3: {
                                return new GsfReformatTaskFactory();
                            }
                            case 2: {
                                return new GsfIndentTaskFactory();
                            }
                        }
                        return null;
                    }

                    public Class<? extends Object> type(Integer i) {
                        switch (i) {
                            case 1: {
                                return GsfEditorKitFactory.GsfEditorKit.class;
                            }
                            case 3: {
                                return GsfReformatTaskFactory.class;
                            }
                            case 2: {
                                return GsfIndentTaskFactory.class;
                            }
                        }
                        return null;
                    }

                    public String id(Integer i) {
                        return i.toString();
                    }

                    public String displayName(Integer i) {
                        return i.toString();
                    }
                });
            }
        }
        return this.lookup;
    }
}

