/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.configurations;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.spi.actions.AbstractMavenActionsProvider;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class M2Configuration
extends AbstractMavenActionsProvider
implements ProjectConfiguration {
    public static String DEFAULT = "%%DEFAULT%%";
    private final String id;
    private List<String> profiles;
    private final NbMavenProjectImpl project;
    static final String FILENAME = "nbactions.xml";
    static final String FILENAME_PREFIX = "nbactions-";
    static final String FILENAME_SUFFIX = ".xml";
    private Date lastModified = new Date();
    private boolean lastTimeExists = true;
    private final Properties properties = new Properties();

    static M2Configuration createDefault(NbMavenProjectImpl prj) {
        return new M2Configuration(DEFAULT, prj);
    }

    public M2Configuration(String id, NbMavenProjectImpl proj) {
        this.id = id;
        this.project = proj;
        this.profiles = Collections.emptyList();
    }

    public String getDisplayName() {
        if (DEFAULT.equals(this.id)) {
            return NbBundle.getMessage(M2Configuration.class, (String)"TXT_DefaultConfig");
        }
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public void setActivatedProfiles(List<String> profs) {
        this.profiles = profs;
    }

    public List<String> getActivatedProfiles() {
        return this.profiles;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static String getFileNameExt(String id) {
        if (DEFAULT.equals(id)) {
            return FILENAME;
        }
        return FILENAME_PREFIX + id + FILENAME_SUFFIX;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        M2Configuration other = (M2Configuration)obj;
        return this.id == other.id || this.id != null && this.id.equals(other.id);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.id != null ? this.id.hashCode() : 0);
        return hash;
    }

    @Override
    public InputStream getActionDefinitionStream() {
        FileObject fo = this.project.getProjectDirectory().getFileObject(M2Configuration.getFileNameExt(this.id));
        boolean bl = this.lastTimeExists = fo != null;
        if (fo != null) {
            try {
                this.lastModified = fo.lastModified();
                return fo.getInputStream();
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        this.lastModified = new Date();
        return null;
    }

    public NetbeansActionMapping[] getCustomMappings() {
        NetbeansActionMapping[] fallbackActions = new NetbeansActionMapping[]{};
        try {
            ArrayList<NetbeansActionMapping> toRet = new ArrayList<NetbeansActionMapping>();
            Reader read = this.performDynamicSubstitutions(Collections.EMPTY_MAP, this.getRawMappingsAsString());
            ActionToGoalMapping mapping = this.reader.read(read);
            List<NetbeansActionMapping> lst = mapping.getActions();
            if (lst != null) {
                for (NetbeansActionMapping mapp : lst) {
                    if (!mapp.getActionName().startsWith("CUSTOM-")) continue;
                    toRet.add(mapp);
                }
            }
            return toRet.toArray(new NetbeansActionMapping[toRet.size()]);
        }
        catch (XmlPullParserException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return fallbackActions;
    }

    @Override
    protected boolean reloadStream() {
        FileObject fo = this.project.getProjectDirectory().getFileObject(M2Configuration.getFileNameExt(this.id));
        boolean prevExists = this.lastTimeExists;
        this.lastTimeExists = fo != null;
        return fo == null && prevExists || fo != null && fo.lastModified().after(this.lastModified);
    }
}

