/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

final class ProxyIterable<T>
implements Iterable<T> {
    private final Collection<? extends Iterable<? extends T>> delegates;
    private final boolean allowDuplicates;

    public ProxyIterable(Collection<? extends Iterable<? extends T>> delegates) {
        this(delegates, true);
    }

    public ProxyIterable(Collection<? extends Iterable<? extends T>> delegates, boolean allowDuplicates) {
        assert (delegates != null);
        this.delegates = delegates;
        this.allowDuplicates = allowDuplicates;
    }

    @Override
    public Iterator<T> iterator() {
        return new ProxyIterator(this.delegates.iterator(), this.allowDuplicates);
    }

    public String toString() {
        return "ProxyIterable@" + Integer.toHexString(System.identityHashCode(this)) + " [" + this.delegates + "]";
    }

    private static final class ProxyIterator<T>
    implements Iterator<T> {
        private final Iterator<? extends Iterable<? extends T>> iterables;
        private final Set<T> seen;
        private Iterator<? extends T> currentIterator;
        private T currentObject;

        public ProxyIterator(Iterator<? extends Iterable<? extends T>> iterables, boolean allowDuplicates) {
            assert (iterables != null);
            this.iterables = iterables;
            this.seen = allowDuplicates ? null : new HashSet();
        }

        @Override
        public boolean hasNext() {
            return this.getCurrent(false) != null;
        }

        @Override
        public T next() {
            T curObj = this.getCurrent(true);
            if (curObj == null) {
                throw new NoSuchElementException();
            }
            return curObj;
        }

        private T getCurrent(boolean move) {
            if (this.currentObject != null && !move) {
                return this.currentObject;
            }
            T oldCurObj = this.currentObject;
            while (true) {
                if (this.currentIterator != null) {
                    while (this.currentIterator.hasNext()) {
                        T o = this.currentIterator.next();
                        if (this.seen != null && !this.seen.add(o)) continue;
                        this.currentObject = o;
                        return oldCurObj != null ? oldCurObj : this.currentObject;
                    }
                }
                if (!this.iterables.hasNext()) break;
                this.currentIterator = this.iterables.next().iterator();
            }
            this.currentIterator = null;
            this.currentObject = null;
            return oldCurObj;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

