/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime.load;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import org.jruby.nb.CompatVersion;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyFile;
import org.jruby.nb.RubyHash;
import org.jruby.nb.RubyString;
import org.jruby.nb.ast.executable.Script;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.runtime.Constants;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.load.ClassExtensionLibrary;
import org.jruby.nb.runtime.load.ExternalScript;
import org.jruby.nb.runtime.load.IAutoloadMethod;
import org.jruby.nb.runtime.load.JarredScript;
import org.jruby.nb.runtime.load.JavaCompiledScript;
import org.jruby.nb.runtime.load.Library;
import org.jruby.nb.runtime.load.LoadServiceResource;
import org.jruby.nb.util.JRubyFile;

public class LoadService {
    protected static final String[] sourceSuffixes = new String[]{".class", ".rb"};
    protected static final String[] extensionSuffixes = new String[]{".so", ".jar"};
    protected static final String[] allSuffixes = new String[]{".class", ".rb", ".so", ".jar"};
    protected static final Pattern sourcePattern = Pattern.compile("\\.(?:rb)$");
    protected static final Pattern extensionPattern = Pattern.compile("\\.(?:so|o|dll|jar)$");
    protected RubyArray loadPath;
    protected RubyArray loadedFeatures;
    protected List loadedFeaturesInternal;
    protected final Map<String, Library> builtinLibraries = new HashMap<String, Library>();
    protected final Map<String, JarFile> jarFiles = new HashMap<String, JarFile>();
    protected final Map<String, IAutoloadMethod> autoloadMap = new HashMap<String, IAutoloadMethod>();
    protected final Ruby runtime;

    public LoadService(Ruby runtime) {
        this.runtime = runtime;
    }

    public void init(List additionalDirectories) {
        String jrubyHome;
        RubyString env_rubylib;
        this.loadPath = RubyArray.newArray(this.runtime);
        this.loadedFeatures = RubyArray.newArray(this.runtime);
        this.loadedFeaturesInternal = Collections.synchronizedList(this.loadedFeatures);
        Iterator iter = additionalDirectories.iterator();
        while (iter.hasNext()) {
            this.addPath((String)iter.next());
        }
        RubyHash env = (RubyHash)this.runtime.getObject().fastGetConstant("ENV");
        if (env.has_key_p(env_rubylib = this.runtime.newString("RUBYLIB")).isTrue()) {
            String rubylib = env.op_aref(this.runtime.getCurrentContext(), env_rubylib).toString();
            String[] paths = rubylib.split(File.pathSeparator);
            for (int i = 0; i < paths.length; ++i) {
                this.addPath(paths[i]);
            }
        }
        if (!Ruby.isSecurityRestricted() && (jrubyHome = this.runtime.getJRubyHome()) != null) {
            char sep = '/';
            String rubyDir = jrubyHome + sep + "lib" + sep + "ruby" + sep;
            if (this.runtime.getInstanceConfig().getCompatVersion() == CompatVersion.RUBY1_9) {
                this.addPath(rubyDir + "site_ruby" + sep + Constants.RUBY1_9_MAJOR_VERSION);
                this.addPath(rubyDir + "site_ruby");
                this.addPath(rubyDir + Constants.RUBY1_9_MAJOR_VERSION);
                this.addPath(rubyDir + Constants.RUBY1_9_MAJOR_VERSION + sep + "java");
            }
            this.addPath(rubyDir + "site_ruby" + sep + Constants.RUBY_MAJOR_VERSION);
            this.addPath(rubyDir + "site_ruby");
            this.addPath(rubyDir + "site_ruby" + sep + "shared");
            this.addPath(rubyDir + Constants.RUBY_MAJOR_VERSION);
            this.addPath(rubyDir + Constants.RUBY_MAJOR_VERSION + sep + "java");
            this.addPath("lib" + sep + "ruby" + sep + Constants.RUBY_MAJOR_VERSION);
        }
        if (this.runtime.getSafeLevel() == 0) {
            this.addPath(".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPath(String path) {
        if (path == null || path.length() == 0) {
            return;
        }
        RubyArray rubyArray = this.loadPath;
        synchronized (rubyArray) {
            this.loadPath.append(this.runtime.newString(path.replace('\\', '/')));
        }
    }

    public void load(String file, boolean wrap) {
        if (!this.runtime.getProfile().allowLoad(file)) {
            throw this.runtime.newLoadError("No such file to load -- " + file);
        }
        Library library = this.findLibrary(file, false);
        if (library == null && (library = this.findLibraryWithClassloaders(file)) == null) {
            throw this.runtime.newLoadError("No such file to load -- " + file);
        }
        try {
            library.load(this.runtime, wrap);
        }
        catch (IOException e) {
            if (this.runtime.getDebug().isTrue()) {
                e.printStackTrace();
            }
            throw this.runtime.newLoadError("IO error -- " + file);
        }
    }

    public boolean smartLoad(String file) {
        RubyString loadNameRubyString;
        int i;
        if (file.equals("")) {
            throw this.runtime.newLoadError("No such file to load -- " + file);
        }
        Library library = null;
        String loadName = file;
        String[] extensionsToSearch = null;
        if (file.lastIndexOf(46) > file.lastIndexOf(47)) {
            Matcher matcher = null;
            matcher = sourcePattern.matcher(file);
            if (matcher.find()) {
                extensionsToSearch = sourceSuffixes;
                file = file.substring(0, matcher.start());
            } else {
                matcher = extensionPattern.matcher(file);
                if (matcher.find()) {
                    extensionsToSearch = extensionSuffixes;
                    file = file.substring(0, matcher.start());
                } else {
                    extensionsToSearch = allSuffixes;
                }
            }
        } else {
            extensionsToSearch = allSuffixes;
        }
        for (i = 0; i < extensionsToSearch.length; ++i) {
            library = Ruby.isSecurityRestricted() ? this.findLibrary(file + extensionsToSearch[i], false) : this.findLibrary(file + extensionsToSearch[i], true);
            if (library == null) continue;
            loadName = file + extensionsToSearch[i];
            break;
        }
        if (library == null) {
            for (i = 0; i < extensionsToSearch.length; ++i) {
                library = this.findLibraryWithClassloaders(file + extensionsToSearch[i]);
                if (library == null) continue;
                loadName = file + extensionsToSearch[i];
                break;
            }
        }
        library = this.tryLoadExtension(library, file);
        Script script = null;
        if (library == null) {
            int lastSlashIndex;
            String className = file;
            if ((className = className.replaceFirst("^\\.\\/", "")).lastIndexOf(".") != -1) {
                className = className.substring(0, className.lastIndexOf("."));
            }
            if ((lastSlashIndex = (className = className.replace("-", "_minus_").replace('.', '_')).lastIndexOf(47)) > -1 && lastSlashIndex < className.length() - 1 && !Character.isJavaIdentifierStart(className.charAt(lastSlashIndex + 1))) {
                className = lastSlashIndex == -1 ? "_" + className : className.substring(0, lastSlashIndex + 1) + "_" + className.substring(lastSlashIndex + 1);
            }
            className = className.replace('/', '.');
            try {
                Class<?> scriptClass = Class.forName(className);
                script = (Script)scriptClass.newInstance();
            }
            catch (Exception cnfe) {
                throw this.runtime.newLoadError("no such file to load -- " + file);
            }
        }
        if (this.loadedFeaturesInternal.contains(loadNameRubyString = this.runtime.newString(loadName))) {
            return false;
        }
        try {
            this.loadedFeaturesInternal.add(loadNameRubyString);
            if (script != null) {
                this.runtime.loadScript(script);
                return true;
            }
            library.load(this.runtime, false);
            return true;
        }
        catch (Throwable e) {
            if (library instanceof JarredScript && file.endsWith(".jar")) {
                return true;
            }
            this.loadedFeaturesInternal.remove(loadNameRubyString);
            if (e instanceof RaiseException) {
                throw (RaiseException)e;
            }
            if (this.runtime.getDebug().isTrue()) {
                e.printStackTrace();
            }
            RaiseException re = this.runtime.newLoadError("IO error -- " + file);
            re.initCause(e);
            throw re;
        }
    }

    public boolean require(String file) {
        if (!this.runtime.getProfile().allowRequire(file)) {
            throw this.runtime.newLoadError("No such file to load -- " + file);
        }
        return this.smartLoad(file);
    }

    public IRubyObject getLoadPath() {
        return this.loadPath;
    }

    public IRubyObject getLoadedFeatures() {
        return this.loadedFeatures;
    }

    public IAutoloadMethod autoloadFor(String name) {
        return this.autoloadMap.get(name);
    }

    public void removeAutoLoadFor(String name) {
        this.autoloadMap.remove(name);
    }

    public IRubyObject autoload(String name) {
        IAutoloadMethod loadMethod = this.autoloadMap.remove(name);
        if (loadMethod != null) {
            return loadMethod.load(this.runtime, name);
        }
        return null;
    }

    public void addAutoload(String name, IAutoloadMethod loadMethod) {
        this.autoloadMap.put(name, loadMethod);
    }

    public void addBuiltinLibrary(String name, Library library) {
        this.builtinLibraries.put(name, library);
    }

    public void removeBuiltinLibrary(String name) {
        this.builtinLibraries.remove(name);
    }

    public void removeInternalLoadedFeature(String name) {
        this.loadedFeaturesInternal.remove(name);
    }

    private Library findLibrary(String file, boolean checkCWD) {
        if (this.builtinLibraries.containsKey(file)) {
            return this.builtinLibraries.get(file);
        }
        return this.createLibrary(file, this.findFile(file, checkCWD));
    }

    private Library findLibraryWithClassloaders(String file) {
        return this.createLibrary(file, this.findFileInClasspath(file));
    }

    private Library createLibrary(String file, LoadServiceResource resource) {
        if (resource == null) {
            return null;
        }
        if (file.endsWith(".jar")) {
            return new JarredScript(resource);
        }
        if (file.endsWith(".class")) {
            return new JavaCompiledScript(resource);
        }
        return new ExternalScript(resource, file);
    }

    private LoadServiceResource findFile(String name, boolean checkCWD) {
        Object file;
        if (name.startsWith("jar:")) {
            try {
                return new LoadServiceResource(new URL(name), name);
            }
            catch (MalformedURLException e) {
                throw this.runtime.newIOErrorFromException(e);
            }
        }
        if (name.startsWith("file:") && name.indexOf("!/") != -1) {
            try {
                file = new JarFile(name.substring(5, name.indexOf("!/")));
                String filename = name.substring(name.indexOf("!/") + 2);
                if (((JarFile)file).getJarEntry(filename) != null) {
                    return new LoadServiceResource(new URL("jar:" + name), name);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Iterator pathIter = this.loadPath.getList().iterator();
        while (pathIter.hasNext()) {
            Object current;
            String entry = ((IRubyObject)pathIter.next()).toString();
            if (entry.startsWith("jar:") || entry.endsWith(".jar") || entry.startsWith("file:") && entry.indexOf("!/") != -1) {
                String before;
                current = this.jarFiles.get(entry);
                String after = entry.startsWith("file:") && entry.indexOf("!/") != -1 ? entry.substring(entry.indexOf("!/") + 2) + "/" : "";
                String string = before = entry.startsWith("file:") && entry.indexOf("!/") != -1 ? entry.substring(0, entry.indexOf("!/")) : entry;
                if (null == current) {
                    try {
                        current = entry.startsWith("jar:") ? new JarFile(entry.substring(4)) : (entry.endsWith(".jar") ? new JarFile(entry) : new JarFile(entry.substring(5, entry.indexOf("!/"))));
                        this.jarFiles.put(entry, (JarFile)current);
                    }
                    catch (ZipException ignored) {
                        if (this.runtime.getInstanceConfig().isVerbose()) {
                            this.runtime.getErr().println("ZipException trying to access " + entry + ", stack trace follows:");
                            ignored.printStackTrace(this.runtime.getErr());
                        }
                    }
                    catch (FileNotFoundException ignored) {
                    }
                    catch (IOException e) {
                        throw this.runtime.newIOErrorFromException(e);
                    }
                }
                String canonicalEntry = after + name;
                if (after.length() > 0) {
                    try {
                        canonicalEntry = new File(after + name).getCanonicalPath().substring(new File(".").getCanonicalPath().length() + 1).replaceAll("\\\\", "/");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (current != null && ((JarFile)current).getJarEntry(canonicalEntry) != null) {
                    try {
                        if (entry.endsWith(".jar")) {
                            return new LoadServiceResource(new URL("jar:file:" + entry + "!/" + canonicalEntry), "/" + name);
                        }
                        if (entry.startsWith("file:")) {
                            return new LoadServiceResource(new URL("jar:" + before + "!/" + canonicalEntry), entry + "/" + name);
                        }
                        return new LoadServiceResource(new URL("jar:file:" + entry.substring(4) + "!/" + name), entry + name);
                    }
                    catch (MalformedURLException e) {
                        throw this.runtime.newIOErrorFromException(e);
                    }
                }
            }
            try {
                if (Ruby.isSecurityRestricted() || !((File)(current = JRubyFile.create(JRubyFile.create(this.runtime.getCurrentDirectory(), entry).getAbsolutePath(), RubyFile.expandUserPath(this.runtime.getCurrentContext(), name)))).isFile()) continue;
                try {
                    String resourcePath = name.startsWith("./") ? name : ((JRubyFile)current).getPath();
                    return new LoadServiceResource(((File)current).toURI().toURL(), resourcePath);
                }
                catch (MalformedURLException e) {
                    throw this.runtime.newIOErrorFromException(e);
                }
            }
            catch (SecurityException secEx) {
            }
        }
        if (checkCWD) {
            try {
                file = JRubyFile.create(this.runtime.getCurrentDirectory(), RubyFile.expandUserPath(this.runtime.getCurrentContext(), name));
                if (((File)file).isFile() && ((File)file).isAbsolute()) {
                    try {
                        return new LoadServiceResource(((File)file).toURI().toURL(), name);
                    }
                    catch (MalformedURLException e) {
                        throw this.runtime.newIOErrorFromException(e);
                    }
                }
            }
            catch (IllegalArgumentException illArgEx) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    private LoadServiceResource findFileInClasspath(String name) {
        ClassLoader classLoader = this.runtime.getJRubyClassLoader();
        if (Ruby.isSecurityRestricted() && classLoader == null) {
            classLoader = this.runtime.getInstanceConfig().getLoader();
        }
        Iterator pathIter = this.loadPath.getList().iterator();
        while (pathIter.hasNext()) {
            URL loc;
            String entry = pathIter.next().toString();
            if (entry.charAt(0) == '/' || entry.length() > 1 && entry.charAt(1) == ':' || !this.isRequireable(loc = classLoader.getResource(entry + "/" + name))) continue;
            return new LoadServiceResource(loc, loc.getPath());
        }
        if (name.charAt(0) == '/' || name.length() > 1 && name.charAt(1) == ':') {
            return null;
        }
        URL loc = classLoader.getResource(name);
        return this.isRequireable(loc) ? new LoadServiceResource(loc, loc.getPath()) : null;
    }

    private Library tryLoadExtension(Library library, String file) {
        Library oldLibrary = library;
        if ((library == null || library instanceof JarredScript) && !file.equalsIgnoreCase("")) {
            String[] all = file.split("/");
            StringBuilder finName = new StringBuilder();
            int j = all.length - 1;
            for (int i = 0; i < j; ++i) {
                finName.append(all[i].toLowerCase()).append(".");
            }
            try {
                String[] last = all[all.length - 1].split("_");
                int j2 = last.length;
                for (int i = 0; i < j2; ++i) {
                    finName.append(Character.toUpperCase(last[i].charAt(0))).append(last[i].substring(1));
                }
                finName.append("Service");
                String className = finName.toString().replaceAll("^\\.*", "");
                if (library instanceof JarredScript) {
                    this.runtime.getJRubyClassLoader().addURL(((JarredScript)library).getResource().getURL());
                }
                Class theClass = this.runtime.getJavaSupport().loadJavaClassQuiet(className);
                library = new ClassExtensionLibrary(theClass);
            }
            catch (Exception ee) {
                library = null;
                this.runtime.getGlobalVariables().set("$!", this.runtime.getNil());
            }
        }
        if (library == null && oldLibrary != null) {
            library = oldLibrary;
        }
        return library;
    }

    private boolean isRequireable(URL loc) {
        if (loc != null) {
            if (loc.getProtocol().equals("file") && new File(loc.getFile()).isDirectory()) {
                return false;
            }
            try {
                loc.openConnection();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

