/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.stackanalyzer;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.NbBundle;

class StackLineAnalyser {
    private static final String IDENTIFIER = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern LINE_PATTERN = Pattern.compile("at\\s((\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*)\\.)?(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\.(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*|\\<init\\>|\\<clinit\\>)\\(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.java\\:([0-9]*)\\)");

    StackLineAnalyser() {
    }

    static boolean matches(String line) {
        Matcher matcher = LINE_PATTERN.matcher(line);
        return matcher.find();
    }

    static Link analyse(String line) {
        Matcher matcher = LINE_PATTERN.matcher(line);
        if (matcher.find()) {
            int lineNumber = -1;
            try {
                lineNumber = Integer.parseInt(matcher.group(6));
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            return new Link(matcher.group(1) + matcher.group(4).split("\\$")[0], lineNumber, matcher.start(1), matcher.end(6) + 1);
        }
        return null;
    }

    static class Link {
        private String className;
        private int lineNumber;
        private int startOffset;
        private int endOffset;

        private Link(String className, int lineNumber, int startOffset, int endOffset) {
            this.className = className;
            this.lineNumber = lineNumber;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        int getStartOffset() {
            return this.startOffset;
        }

        int getEndOffset() {
            return this.endOffset;
        }

        void show() {
            String resource = this.className.replace('.', '/') + ".java";
            ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])GlobalPathRegistry.getDefault().getSourceRoots().toArray(new FileObject[0]));
            FileObject fileObject = classPath.findResource(resource);
            if (fileObject == null) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StackLineAnalyser.class, (String)"AnalyzeStackTopComponent.sourceNotFound", (Object[])new Object[]{resource}));
                return;
            }
            try {
                Line l;
                StyledDocument doc;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
                if (editorCookie != null && lineCookie != null && this.lineNumber != -1 && (doc = editorCookie.openDocument()) != null && this.lineNumber != -1 && (l = lineCookie.getLineSet().getCurrent(this.lineNumber - 1)) != null) {
                    l.show(2);
                    return;
                }
                OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
                if (openCookie != null) {
                    openCookie.open();
                    return;
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }
}

