/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.Severity;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.gsf.api.annotations.CheckForNull;
import org.netbeans.modules.gsf.api.annotations.NonNull;

public abstract class ParserResult {
    @NonNull
    protected final ParserFile file;
    @CheckForNull
    private List<Error> errors;
    @NonNull
    private Parser parser;
    @CheckForNull
    protected TranslatedSource translatedSource;
    @NonNull
    private String mimeType;
    @NonNull
    private CompilationInfo info;
    @NonNull
    protected UpdateState updateState = UpdateState.NOT_SUPPORTED;
    private int editVersion = -1;
    private final boolean valid;

    public ParserResult(@NonNull Parser parser, @NonNull ParserFile file, @NonNull String mimeType) {
        this(parser, file, mimeType, true);
    }

    public ParserResult(@NonNull Parser parser, @NonNull ParserFile file, @NonNull String mimeType, boolean isValid) {
        this.parser = parser;
        this.file = file;
        this.mimeType = mimeType;
        this.valid = isValid;
    }

    @NonNull
    public String getMimeType() {
        return this.mimeType;
    }

    @NonNull
    public Parser getParser() {
        return this.parser;
    }

    public void setTranslatedSource(@NonNull TranslatedSource translatedSource) {
        this.translatedSource = translatedSource;
    }

    @CheckForNull
    public TranslatedSource getTranslatedSource() {
        return this.translatedSource;
    }

    public boolean isValid() {
        return this.valid;
    }

    @NonNull
    public List<Error> getDiagnostics() {
        if (this.errors == null) {
            return Collections.emptyList();
        }
        ArrayList<Error> localErrors = new ArrayList<Error>(this.errors.size());
        for (Error m : this.errors) {
            assert (this.file.getFileObject() == m.getFile());
            localErrors.add(m);
        }
        return localErrors;
    }

    public boolean hasErrors() {
        if (this.errors == null) {
            return false;
        }
        for (Error m : this.errors) {
            if (m.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    public void addError(@NonNull Error message) {
        if (this.errors == null) {
            this.errors = new ArrayList<Error>();
        }
        this.errors.add(message);
    }

    @CheckForNull
    public abstract AstTreeNode getAst();

    @NonNull
    public ParserFile getFile() {
        return this.file;
    }

    @NonNull
    public CompilationInfo getInfo() {
        return this.info;
    }

    public void setInfo(@NonNull CompilationInfo info) {
        this.info = info;
    }

    public int getEditVersion() {
        return this.editVersion;
    }

    public void setEditVersion(int editVersion) {
        this.editVersion = editVersion;
    }

    @NonNull
    public UpdateState getUpdateState() {
        return this.updateState;
    }

    public void setUpdateState(@NonNull UpdateState updateState) {
        this.updateState = updateState;
    }

    public static enum UpdateState {
        NOT_SUPPORTED,
        FAILED,
        NO_CHANGE,
        NO_SEMANTIC_CHANGE,
        UPDATED;


        public boolean isUnchanged() {
            return this == NO_CHANGE || this == NO_SEMANTIC_CHANGE;
        }
    }

    public static interface AstTreeNode
    extends TreeNode {
        public Object getAstNode();

        public int getStartOffset();

        public int getEndOffset();
    }
}

